/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.csv.io;

import com.orangesignal.csv.CsvReader;
import com.orangesignal.csv.filters.CsvNamedValueFilter;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CsvColumnNameMapReader
implements Closeable {
    private CsvReader reader;
    private List<String> columnNames;
    private int columnCount = -1;
    private Map<String, String> base;
    private CsvNamedValueFilter filter;

    public CsvColumnNameMapReader(CsvReader reader) {
        this(reader, null);
    }

    public CsvColumnNameMapReader(CsvReader reader, List<String> columnNames) {
        if (reader == null) {
            throw new IllegalArgumentException("CsvReader must not be null");
        }
        this.reader = reader;
        if (columnNames != null) {
            this.columnNames = Collections.unmodifiableList(columnNames);
        }
    }

    private void ensureOpen() throws IOException {
        if (this.reader == null) {
            throw new IOException("CsvReader closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureHeader() throws IOException {
        CsvColumnNameMapReader csvColumnNameMapReader = this;
        synchronized (csvColumnNameMapReader) {
            if (this.columnNames == null) {
                this.columnNames = Collections.unmodifiableList(this.reader.readValues());
                if (this.columnNames == null) {
                    throw new IOException("No header is available");
                }
            }
            if (this.columnCount == -1) {
                this.columnCount = this.columnNames.size();
                this.base = new LinkedHashMap<String, String>(this.columnCount);
                for (String columnName : this.columnNames) {
                    this.base.put(columnName, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        CsvColumnNameMapReader csvColumnNameMapReader = this;
        synchronized (csvColumnNameMapReader) {
            this.ensureOpen();
            this.reader.close();
            this.reader = null;
            this.columnNames = null;
            this.columnCount = -1;
            this.base = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getHeader() throws IOException {
        CsvColumnNameMapReader csvColumnNameMapReader = this;
        synchronized (csvColumnNameMapReader) {
            this.ensureOpen();
            this.ensureHeader();
            return this.columnNames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> read() throws IOException {
        CsvColumnNameMapReader csvColumnNameMapReader = this;
        synchronized (csvColumnNameMapReader) {
            this.ensureOpen();
            this.ensureHeader();
            List<String> values = this.nextValues();
            if (values == null) {
                return null;
            }
            return this.convert(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readValues() throws IOException {
        CsvColumnNameMapReader csvColumnNameMapReader = this;
        synchronized (csvColumnNameMapReader) {
            this.ensureOpen();
            this.ensureHeader();
            return this.nextValues();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> toMap(List<String> values) throws IOException {
        CsvColumnNameMapReader csvColumnNameMapReader = this;
        synchronized (csvColumnNameMapReader) {
            this.ensureOpen();
            this.ensureHeader();
            return this.convert(values);
        }
    }

    private List<String> nextValues() throws IOException {
        List<String> values;
        while ((values = this.reader.readValues()) != null) {
            if (this.filter != null && !this.filter.accept(this.columnNames, values)) continue;
            return values;
        }
        return null;
    }

    private Map<String, String> convert(List<String> values) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(this.base);
        int len = Math.min(this.columnCount, values.size());
        for (int pos = 0; pos < len; ++pos) {
            map.put(this.columnNames.get(pos), values.get(pos));
        }
        return map;
    }

    public CsvNamedValueFilter getFilter() {
        return this.filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilter(CsvNamedValueFilter filter) {
        CsvColumnNameMapReader csvColumnNameMapReader = this;
        synchronized (csvColumnNameMapReader) {
            this.filter = filter;
        }
    }
}

