/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.csv.io;

import com.orangesignal.csv.CsvWriter;
import com.orangesignal.csv.bean.CsvColumnNameMappingBeanTemplate;
import com.orangesignal.csv.bean.FieldUtils;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;

public class CsvColumnNameMappingBeanWriter<T>
implements Closeable,
Flushable {
    private CsvWriter writer;
    private final CsvColumnNameMappingBeanTemplate<T> template;
    private final boolean header;
    private List<String> columnNames;
    private int columnCount = -1;

    public static <T> CsvColumnNameMappingBeanWriter<T> newInstance(CsvWriter writer, Class<T> type) {
        return new CsvColumnNameMappingBeanWriter<T>(writer, type);
    }

    public static <T> CsvColumnNameMappingBeanWriter<T> newInstance(CsvWriter writer, Class<T> type, boolean header) {
        return new CsvColumnNameMappingBeanWriter<T>(writer, type, header);
    }

    public static <T> CsvColumnNameMappingBeanWriter<T> newInstance(CsvWriter writer, CsvColumnNameMappingBeanTemplate<T> template) {
        return new CsvColumnNameMappingBeanWriter<T>(writer, template);
    }

    public static <T> CsvColumnNameMappingBeanWriter<T> newInstance(CsvWriter writer, CsvColumnNameMappingBeanTemplate<T> template, boolean header) {
        return new CsvColumnNameMappingBeanWriter<T>(writer, template, header);
    }

    public CsvColumnNameMappingBeanWriter(CsvWriter writer, Class<T> type) {
        this(writer, new CsvColumnNameMappingBeanTemplate<T>(type), true);
    }

    public CsvColumnNameMappingBeanWriter(CsvWriter writer, Class<T> type, boolean header) {
        this(writer, new CsvColumnNameMappingBeanTemplate<T>(type), header);
    }

    public CsvColumnNameMappingBeanWriter(CsvWriter writer, CsvColumnNameMappingBeanTemplate<T> template) {
        this(writer, template, true);
    }

    public CsvColumnNameMappingBeanWriter(CsvWriter writer, CsvColumnNameMappingBeanTemplate<T> template, boolean header) {
        if (writer == null) {
            throw new IllegalArgumentException("CsvWriter must not be null");
        }
        if (template == null) {
            throw new IllegalArgumentException("CsvColumnNameMappingBeanTemplate must not be null");
        }
        this.writer = writer;
        this.template = template;
        this.header = header;
    }

    private void ensureOpen() throws IOException {
        if (this.writer == null) {
            throw new IOException("CsvWriter closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureHeader() throws IOException {
        CsvColumnNameMappingBeanWriter csvColumnNameMappingBeanWriter = this;
        synchronized (csvColumnNameMappingBeanWriter) {
            if (this.columnNames == null) {
                this.template.setupColumnMappingIfNeed();
                List<String> names = this.template.createColumnNames();
                if (this.header) {
                    this.writer.writeValues(names);
                }
                this.columnNames = names;
                this.columnCount = names.size();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        CsvColumnNameMappingBeanWriter csvColumnNameMappingBeanWriter = this;
        synchronized (csvColumnNameMappingBeanWriter) {
            this.ensureOpen();
            this.writer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        CsvColumnNameMappingBeanWriter csvColumnNameMappingBeanWriter = this;
        synchronized (csvColumnNameMappingBeanWriter) {
            this.ensureOpen();
            this.writer.close();
            this.writer = null;
            this.columnNames = null;
            this.columnCount = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHeader() throws IOException {
        CsvColumnNameMappingBeanWriter csvColumnNameMappingBeanWriter = this;
        synchronized (csvColumnNameMappingBeanWriter) {
            this.ensureOpen();
            this.ensureHeader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(T bean) throws IOException {
        CsvColumnNameMappingBeanWriter csvColumnNameMappingBeanWriter = this;
        synchronized (csvColumnNameMappingBeanWriter) {
            this.ensureOpen();
            this.ensureHeader();
            if (bean == null) {
                this.writer.writeValues(null);
                return true;
            }
            List<String> values = this.toValues(bean);
            if (this.template.isAccept(this.columnNames, values)) {
                return false;
            }
            this.writer.writeValues(values);
            return true;
        }
    }

    private List<String> toValues(T bean) throws IOException {
        String[] values = new String[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            String fieldName;
            String columnName = this.columnNames.get(i);
            if (columnName == null || (fieldName = this.template.getFieldName(columnName)) == null) continue;
            Field f = FieldUtils.getField(bean.getClass(), fieldName);
            values[i] = this.template.objectToString(columnName, FieldUtils.getFieldValue(bean, f));
        }
        return Arrays.asList(values);
    }

    public CsvColumnNameMappingBeanTemplate<T> getTemplate() {
        return this.template;
    }
}

