/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.csv.io;

import com.orangesignal.csv.CsvReader;
import com.orangesignal.csv.annotation.CsvColumn;
import com.orangesignal.csv.annotation.CsvColumnException;
import com.orangesignal.csv.annotation.CsvColumns;
import com.orangesignal.csv.annotation.CsvEntity;
import com.orangesignal.csv.bean.CsvEntityTemplate;
import com.orangesignal.csv.bean.FieldUtils;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;

public class CsvEntityReader<T>
implements Closeable {
    private CsvReader reader;
    private final CsvEntityTemplate<T> template;
    private List<String> columnNames;
    private Field[] fields;

    public static <T> CsvEntityReader<T> newInstance(CsvReader reader, Class<T> entityClass) {
        return new CsvEntityReader<T>(reader, entityClass);
    }

    public static <T> CsvEntityReader<T> newInstance(CsvReader reader, CsvEntityTemplate<T> template) {
        return new CsvEntityReader<T>(reader, template);
    }

    public CsvEntityReader(CsvReader reader, Class<T> entityClass) {
        this(reader, new CsvEntityTemplate<T>(entityClass));
    }

    public CsvEntityReader(CsvReader reader, CsvEntityTemplate<T> template) {
        if (reader == null) {
            throw new IllegalArgumentException("CsvReader must not be null");
        }
        if (template == null) {
            throw new IllegalArgumentException("CsvEntityTemplate must not be null");
        }
        this.reader = reader;
        this.template = template;
    }

    private void ensureOpen() throws IOException {
        if (this.reader == null) {
            throw new IOException("CsvReader closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureHeader() throws IOException {
        CsvEntityReader csvEntityReader = this;
        synchronized (csvEntityReader) {
            if (this.columnNames == null) {
                List<String> names = this.template.getType().getAnnotation(CsvEntity.class).header() ? this.reader.readValues() : this.template.createColumnNames();
                this.fields = this.template.getType().getDeclaredFields();
                this.template.prepare(names, this.fields);
                this.columnNames = Collections.unmodifiableList(names);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        CsvEntityReader csvEntityReader = this;
        synchronized (csvEntityReader) {
            this.ensureOpen();
            this.reader.close();
            this.reader = null;
            this.columnNames = null;
            this.fields = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getHeader() throws IOException {
        CsvEntityReader csvEntityReader = this;
        synchronized (csvEntityReader) {
            this.ensureOpen();
            this.ensureHeader();
            return this.columnNames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T read() throws IOException {
        CsvEntityReader csvEntityReader = this;
        synchronized (csvEntityReader) {
            this.ensureOpen();
            this.ensureHeader();
            List<String> values = this.nextValues();
            if (values == null) {
                return null;
            }
            return this.convert(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readValues() throws IOException {
        CsvEntityReader csvEntityReader = this;
        synchronized (csvEntityReader) {
            this.ensureOpen();
            this.ensureHeader();
            return this.nextValues();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T toEntity(List<String> values) throws IOException {
        CsvEntityReader csvEntityReader = this;
        synchronized (csvEntityReader) {
            this.ensureOpen();
            this.ensureHeader();
            return this.convert(values);
        }
    }

    private List<String> nextValues() throws IOException {
        List<String> values;
        while ((values = this.reader.readValues()) != null) {
            if (this.template.isAccept(this.columnNames, values)) continue;
            return values;
        }
        return null;
    }

    private T convert(List<String> values) throws IOException {
        Object entity = this.template.createBean();
        for (Field field : this.fields) {
            int pos;
            CsvColumn column;
            Object object = null;
            CsvColumns columns = field.getAnnotation(CsvColumns.class);
            if (columns != null) {
                CsvColumn column2;
                int i$;
                if (field.getType().isArray()) {
                    object = Array.newInstance(field.getType().getComponentType(), columns.value().length);
                    int arrayIndex = 0;
                    CsvColumn[] arr$ = columns.value();
                    int len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        column2 = arr$[i$];
                        if (!column2.access().isReadable()) continue;
                        int pos2 = CsvEntityTemplate.getPosition(column2, field, this.columnNames);
                        String value = pos2 != -1 ? values.get(pos2) : null;
                        if (value == null && !column2.defaultValue().isEmpty()) {
                            value = column2.defaultValue();
                        }
                        if (value == null && column2.required()) {
                            throw new CsvColumnException(String.format("[line: %d] %s must not be null", this.reader.getStartLineNumber(), this.columnNames.get(pos2)), values);
                        }
                        Array.set(object, arrayIndex++, this.template.stringToObject(field, value));
                    }
                } else {
                    StringBuilder sb = new StringBuilder();
                    CsvColumn[] arr$ = columns.value();
                    int len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        int pos3;
                        column2 = arr$[i$];
                        if (!column2.access().isReadable() || (pos3 = CsvEntityTemplate.getPosition(column2, field, this.columnNames)) == -1) continue;
                        String s = values.get(pos3);
                        if (s != null) {
                            sb.append(s);
                            continue;
                        }
                        if (!column2.defaultValue().isEmpty()) {
                            sb.append(column2.defaultValue());
                            continue;
                        }
                        if (!column2.required()) continue;
                        throw new CsvColumnException(String.format("[line: %d] %s must not be null", this.reader.getStartLineNumber(), this.columnNames.get(pos3)), values);
                    }
                    object = this.template.stringToObject(field, sb.toString());
                }
            }
            if ((column = field.getAnnotation(CsvColumn.class)) != null && column.access().isReadable() && (pos = CsvEntityTemplate.getPosition(column, field, this.columnNames)) != -1) {
                String value = values.get(pos);
                if (value == null && !column.defaultValue().isEmpty()) {
                    value = column.defaultValue();
                }
                if (value == null && column.required()) {
                    throw new CsvColumnException(String.format("[line: %d] %s must not be null", this.reader.getStartLineNumber(), this.columnNames.get(pos)), values);
                }
                object = this.template.stringToObject(field, value);
            }
            if (object == null) continue;
            FieldUtils.setFieldValue(entity, field, object);
        }
        return entity;
    }

    public CsvEntityTemplate<T> getTemplate() {
        return this.template;
    }
}

