/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.csv.io;

import com.orangesignal.csv.CsvWriter;
import com.orangesignal.csv.annotation.CsvColumn;
import com.orangesignal.csv.annotation.CsvColumnException;
import com.orangesignal.csv.annotation.CsvColumns;
import com.orangesignal.csv.annotation.CsvEntity;
import com.orangesignal.csv.bean.CsvEntityTemplate;
import com.orangesignal.csv.bean.FieldUtils;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CsvEntityWriter<T>
implements Closeable,
Flushable {
    private CsvWriter writer;
    private final CsvEntityTemplate<T> template;
    private final boolean disableWriteHeader;
    private List<String> columnNames;
    private int columnCount = -1;

    public static <T> CsvEntityWriter<T> newInstance(CsvWriter writer, Class<T> entityClass) {
        return new CsvEntityWriter<T>(writer, entityClass);
    }

    public static <T> CsvEntityWriter<T> newInstance(CsvWriter writer, Class<T> entityClass, boolean disableWriteHeader) {
        return new CsvEntityWriter<T>(writer, entityClass, disableWriteHeader);
    }

    public static <T> CsvEntityWriter<T> newInstance(CsvWriter writer, CsvEntityTemplate<T> template) {
        return new CsvEntityWriter<T>(writer, template);
    }

    public static <T> CsvEntityWriter<T> newInstance(CsvWriter writer, CsvEntityTemplate<T> template, boolean disableWriteHeader) {
        return new CsvEntityWriter<T>(writer, template, disableWriteHeader);
    }

    public CsvEntityWriter(CsvWriter writer, Class<T> entityClass) {
        this(writer, new CsvEntityTemplate<T>(entityClass), false);
    }

    public CsvEntityWriter(CsvWriter writer, Class<T> entityClass, boolean disableWriteHeader) {
        this(writer, new CsvEntityTemplate<T>(entityClass), disableWriteHeader);
    }

    public CsvEntityWriter(CsvWriter writer, CsvEntityTemplate<T> template) {
        this(writer, template, false);
    }

    public CsvEntityWriter(CsvWriter writer, CsvEntityTemplate<T> template, boolean disableWriteHeader) {
        if (writer == null) {
            throw new IllegalArgumentException("CsvWriter must not be null");
        }
        if (template == null) {
            throw new IllegalArgumentException("CsvEntityTemplate must not be null");
        }
        this.writer = writer;
        this.template = template;
        this.disableWriteHeader = disableWriteHeader;
    }

    private void ensureOpen() throws IOException {
        if (this.writer == null) {
            throw new IOException("CsvWriter closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureHeader() throws IOException {
        CsvEntityWriter csvEntityWriter = this;
        synchronized (csvEntityWriter) {
            if (this.columnNames == null) {
                List<String> names = this.template.createWritableColumnNames();
                if (!this.disableWriteHeader && this.template.getType().getAnnotation(CsvEntity.class).header()) {
                    this.writer.writeValues(names);
                }
                this.template.prepare(names, this.template.getType().getDeclaredFields());
                this.columnNames = Collections.unmodifiableList(names);
                this.columnCount = names.size();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        CsvEntityWriter csvEntityWriter = this;
        synchronized (csvEntityWriter) {
            this.ensureOpen();
            this.writer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        CsvEntityWriter csvEntityWriter = this;
        synchronized (csvEntityWriter) {
            this.ensureOpen();
            this.writer.close();
            this.writer = null;
            this.columnNames = null;
            this.columnCount = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHeader() throws IOException {
        CsvEntityWriter csvEntityWriter = this;
        synchronized (csvEntityWriter) {
            this.ensureOpen();
            this.ensureHeader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(T entity) throws IOException {
        CsvEntityWriter csvEntityWriter = this;
        synchronized (csvEntityWriter) {
            this.ensureOpen();
            this.ensureHeader();
            if (entity == null || entity.getClass().getAnnotation(CsvEntity.class) == null) {
                this.writer.writeValues(null);
                return true;
            }
            List<String> values = this.toValues(entity);
            if (this.template.isAccept(this.columnNames, values)) {
                return false;
            }
            this.writer.writeValues(values);
            return true;
        }
    }

    private List<String> toValues(T entity) throws IOException {
        String[] values = new String[this.columnCount];
        for (Field field : entity.getClass().getDeclaredFields()) {
            CsvColumn column;
            CsvColumns columns = field.getAnnotation(CsvColumns.class);
            if (columns != null) {
                int arrayIndex = 0;
                for (CsvColumn column2 : columns.value()) {
                    if (!column2.access().isWriteable()) {
                        ++arrayIndex;
                        continue;
                    }
                    int pos = column2.position();
                    if (pos < 0) {
                        pos = this.columnNames.indexOf(CsvEntityTemplate.defaultIfEmpty(column2.name(), field.getName()));
                    }
                    if (pos == -1) {
                        throw new IOException(String.format("Invalid CsvColumn field %s", field.getName()));
                    }
                    Object o = FieldUtils.getFieldValue(entity, field);
                    if (field.getType().isArray()) {
                        if (o != null) {
                            o = Array.get(o, arrayIndex);
                        }
                        ++arrayIndex;
                    }
                    values[pos] = this.template.objectToString(pos, o);
                    if (values[pos] == null && !column2.defaultValue().isEmpty()) {
                        values[pos] = column2.defaultValue();
                    }
                    if (values[pos] != null || !column2.required()) continue;
                    throw new CsvColumnException(String.format("%s must not be null", this.columnNames.get(pos)), entity);
                }
            }
            if ((column = field.getAnnotation(CsvColumn.class)) == null || !column.access().isWriteable()) continue;
            int pos = column.position();
            if (pos < 0) {
                pos = this.columnNames.indexOf(CsvEntityTemplate.defaultIfEmpty(column.name(), field.getName()));
            }
            if (pos == -1) {
                throw new IOException(String.format("Invalid CsvColumn field %s", field.getName()));
            }
            values[pos] = this.template.objectToString(pos, FieldUtils.getFieldValue(entity, field));
            if (values[pos] == null && !column.defaultValue().isEmpty()) {
                values[pos] = column.defaultValue();
            }
            if (values[pos] != null || !column.required()) continue;
            throw new CsvColumnException(String.format("%s must not be null", this.columnNames.get(pos)), entity);
        }
        return Arrays.asList(values);
    }

    public CsvEntityTemplate<T> getTemplate() {
        return this.template;
    }

    public boolean isDisableWriteHeader() {
        return this.disableWriteHeader;
    }
}

