/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.jlha;

import com.orangesignal.jlha.BitDataBrokenException;
import com.orangesignal.jlha.NotEnoughBitsException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class BitInputStream
extends InputStream {
    private static final int DefaultCacheSize = 1024;
    private InputStream in;
    private byte[] cache;
    private int cacheLimit;
    private int cachePosition;
    private int bitBuffer;
    private int bitCount;
    private boolean markPositionIsInCache;
    private byte[] markCache;
    private int markCacheLimit;
    private int markCachePosition;
    private int markBitBuffer;
    private int markBitCount;

    public BitInputStream(InputStream in) {
        this(in, 1024);
    }

    public BitInputStream(InputStream in, int CacheSize) {
        if (in == null || 4 > CacheSize) {
            if (in == null) {
                throw new NullPointerException("in");
            }
            throw new IllegalArgumentException("CacheSize must be 4 or more.");
        }
        this.in = in;
        this.cache = new byte[CacheSize];
        this.cacheLimit = 0;
        this.cachePosition = 0;
        this.bitBuffer = 0;
        this.bitCount = 0;
        this.markPositionIsInCache = false;
        this.markCache = null;
        this.markCacheLimit = 0;
        this.markCachePosition = 0;
        this.markBitBuffer = 0;
        this.markBitCount = 0;
    }

    @Override
    public int read() throws IOException {
        try {
            return this.readBits(8);
        }
        catch (LocalEOFException exception) {
            if (exception.thrownBy(this)) {
                return -1;
            }
            throw exception;
        }
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int index, int length) throws IOException {
        int requested = length;
        try {
            while (0 < length) {
                buffer[index++] = (byte)this.readBits(8);
                --length;
            }
            return requested;
        }
        catch (LocalEOFException exception) {
            if (exception.thrownBy(this)) {
                if (requested != length) {
                    return requested - length;
                }
                return -1;
            }
            throw exception;
        }
        catch (BitDataBrokenException exception) {
            if (exception.getCause() instanceof LocalEOFException && ((LocalEOFException)exception.getCause()).thrownBy(this)) {
                this.bitBuffer >>>= exception.getBitCount();
                this.bitCount += exception.getBitCount();
                this.bitBuffer |= exception.getBitData() << 32 - exception.getBitCount();
                return requested - length;
            }
            throw exception;
        }
    }

    @Override
    public long skip(long length) throws IOException {
        long requested = length = 0L < length ? length : 0L;
        try {
            while (0L < length) {
                this.readBits(8);
                --length;
            }
            return requested;
        }
        catch (LocalEOFException exception) {
            return requested - length;
        }
        catch (BitDataBrokenException exception) {
            if (exception.getCause() instanceof LocalEOFException && ((LocalEOFException)exception.getCause()).thrownBy(this)) {
                this.bitBuffer >>>= exception.getBitCount();
                this.bitCount += exception.getBitCount();
                this.bitBuffer |= exception.getBitData() << 32 - exception.getBitCount();
                return requested - length;
            }
            throw exception;
        }
    }

    @Override
    public void mark(int readLimit) {
        readLimit -= this.cacheLimit - this.cachePosition;
        readLimit -= this.bitCount / 8;
        readLimit = (readLimit += 4) / this.cache.length * this.cache.length + (readLimit % this.cache.length == 0 ? 0 : this.cache.length);
        this.in.mark(readLimit);
        if (this.markCache == null) {
            this.markCache = (byte[])this.cache.clone();
        } else {
            System.arraycopy(this.cache, 0, this.markCache, 0, this.cacheLimit);
        }
        this.markCacheLimit = this.cacheLimit;
        this.markCachePosition = this.cachePosition;
        this.markBitBuffer = this.bitBuffer;
        this.markBitCount = this.bitCount;
        this.markPositionIsInCache = true;
    }

    @Override
    public void reset() throws IOException {
        if (this.markPositionIsInCache) {
            this.cachePosition = this.markCachePosition;
            this.bitBuffer = this.markBitBuffer;
            this.bitCount = this.markBitCount;
        } else {
            if (!this.in.markSupported()) {
                throw new IOException("not support mark()/reset().");
            }
            if (this.markCache == null) {
                throw new IOException("not marked.");
            }
            this.in.reset();
            System.arraycopy(this.markCache, 0, this.cache, 0, this.markCacheLimit);
            this.cacheLimit = this.markCacheLimit;
            this.cachePosition = this.markCachePosition;
            this.bitBuffer = this.markBitBuffer;
            this.bitCount = this.markBitCount;
        }
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int available() throws IOException {
        return this.availableBits() / 8;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.in = null;
        this.cache = null;
        this.cacheLimit = 0;
        this.cachePosition = 0;
        this.bitBuffer = 0;
        this.bitCount = 0;
        this.markCache = null;
        this.markCacheLimit = 0;
        this.markCachePosition = 0;
        this.markBitBuffer = 0;
        this.markBitCount = 0;
        this.markPositionIsInCache = false;
    }

    public int readBit() throws IOException {
        if (0 < this.bitCount) {
            int bit = this.bitBuffer >>> 31;
            this.bitBuffer <<= 1;
            --this.bitCount;
            return bit;
        }
        try {
            this.fillBitBuffer();
            int bit = this.bitBuffer >>> 31;
            this.bitBuffer <<= 1;
            --this.bitCount;
            return bit;
        }
        catch (LocalEOFException exception) {
            if (exception.thrownBy(this)) {
                return -1;
            }
            throw exception;
        }
    }

    public boolean readBoolean() throws IOException {
        if (0 < this.bitCount) {
            boolean bool = this.bitBuffer < 0;
            this.bitBuffer <<= 1;
            --this.bitCount;
            return bool;
        }
        this.fillBitBuffer();
        boolean bool = this.bitBuffer < 0;
        this.bitBuffer <<= 1;
        --this.bitCount;
        return bool;
    }

    public int readBits(int count) throws IOException {
        if (0 < count) {
            if (count <= this.bitCount) {
                int bits = this.bitBuffer >>> 32 - count;
                this.bitBuffer <<= count;
                this.bitCount -= count;
                return bits;
            }
            int requested = count;
            int bits = 0;
            try {
                this.fillBitBuffer();
                while (this.bitCount < count) {
                    if ((count -= this.bitCount) < 32) {
                        bits |= this.bitBuffer >>> 32 - this.bitCount << count;
                    }
                    this.bitBuffer = 0;
                    this.bitCount = 0;
                    this.fillBitBuffer();
                }
                this.bitBuffer <<= count;
                this.bitCount -= count;
                return bits |= this.bitBuffer >>> 32 - count;
            }
            catch (LocalEOFException exception) {
                if (exception.thrownBy(this) && count < requested) {
                    throw new BitDataBrokenException(exception, bits >>> count, requested - count);
                }
                throw exception;
            }
        }
        return 0;
    }

    public int skipBits(int count) throws IOException {
        if ((count = Math.max(count, 0)) < this.bitCount) {
            this.bitBuffer <<= count;
            this.bitCount -= count;
            return count;
        }
        int requested = count;
        count -= this.bitCount;
        this.bitCount = 0;
        this.bitBuffer = 0;
        try {
            while ((this.cacheLimit - this.cachePosition) * 8 <= count) {
                count -= (this.cacheLimit - this.cachePosition) * 8;
                this.cachePosition = this.cacheLimit;
                this.fillCache();
                if (this.cacheLimit != this.cachePosition) continue;
                throw new LocalEOFException(this);
            }
            this.cachePosition += count >> 3;
            if (0 < (count &= 7)) {
                this.bitCount = 8 - count;
                this.bitBuffer = this.cache[this.cachePosition++] << 24 + count;
                count = 0;
            }
        }
        catch (LocalEOFException localEOFException) {
            // empty catch block
        }
        return requested - count;
    }

    public int peekBit() throws IOException {
        if (0 < this.bitCount) {
            return this.bitBuffer >>> 31;
        }
        try {
            this.fillBitBuffer();
            return this.bitBuffer >>> 31;
        }
        catch (LocalEOFException exception) {
            if (exception.thrownBy(this)) {
                return -1;
            }
            throw exception;
        }
    }

    public boolean peekBoolean() throws IOException {
        if (0 < this.bitCount) {
            return this.bitBuffer < 0;
        }
        this.fillBitBuffer();
        return this.bitBuffer < 0;
    }

    public int peekBits(int count) throws IOException {
        if (0 < count) {
            if (count <= this.bitCount) {
                return this.bitBuffer >>> 32 - count;
            }
            this.fillBitBuffer();
            if (count <= this.bitCount) {
                return this.bitBuffer >>> 32 - count;
            }
            if (count <= this.cachedBits()) {
                if (count <= 32) {
                    int bits = this.bitBuffer;
                    return (bits |= (this.cache[this.cachePosition] & 0xFF) >> this.bitCount - 24) >>> 32 - count;
                }
                if (count - 32 < this.bitCount) {
                    int bcnt;
                    int bits = this.bitBuffer << count - 32;
                    int pos = this.cachePosition;
                    for (bcnt = this.bitCount - (count - 32); bcnt < 25; bcnt += 8) {
                        bits |= (this.cache[pos++] & 0xFF) << 24 - bcnt;
                    }
                    if (bcnt < 32) {
                        bits |= (this.cache[pos] & 0xFF) >> bcnt - 24;
                    }
                    return bits;
                }
                count -= this.bitCount;
                int pos = this.cachePosition + ((count -= 32) >> 3);
                if (0 < (count &= 7)) {
                    return this.cache[pos] << 24 + count | (this.cache[pos + 1] & 0xFF) << 16 + count | (this.cache[pos + 2] & 0xFF) << 8 + count | (this.cache[pos + 3] & 0xFF) << count | (this.cache[pos + 4] & 0xFF) >> 8 - count;
                }
                return this.cache[pos] << 24 | (this.cache[pos + 1] & 0xFF) << 16 | (this.cache[pos + 2] & 0xFF) << 8 | this.cache[pos + 3] & 0xFF;
            }
            throw new NotEnoughBitsException(this.cachedBits());
        }
        return 0;
    }

    public int availableBits() throws IOException {
        int avail = this.cacheLimit - this.cachePosition + this.in.available() / this.cache.length * this.cache.length;
        return Math.max(avail += this.bitCount - 32, 0);
    }

    private int cachedBits() {
        return this.bitCount + (this.cacheLimit - this.cachePosition << 3);
    }

    private void fillBitBuffer() throws IOException {
        if (32 <= this.cachedBits()) {
            if (this.bitCount <= 24) {
                if (this.bitCount <= 16) {
                    if (this.bitCount <= 8) {
                        if (this.bitCount <= 0) {
                            this.bitBuffer = this.cache[this.cachePosition++] << 24;
                            this.bitCount = 8;
                        }
                        this.bitBuffer |= (this.cache[this.cachePosition++] & 0xFF) << 24 - this.bitCount;
                        this.bitCount += 8;
                    }
                    this.bitBuffer |= (this.cache[this.cachePosition++] & 0xFF) << 24 - this.bitCount;
                    this.bitCount += 8;
                }
                this.bitBuffer |= (this.cache[this.cachePosition++] & 0xFF) << 24 - this.bitCount;
                this.bitCount += 8;
            }
        } else if (this.bitCount < 25) {
            if (this.bitCount == 0) {
                this.bitBuffer = 0;
            }
            int count = Math.min(32 - this.bitCount >> 3, this.cacheLimit - this.cachePosition);
            while (0 < count--) {
                this.bitBuffer |= (this.cache[this.cachePosition++] & 0xFF) << 24 - this.bitCount;
                this.bitCount += 8;
            }
            this.fillCache();
            if (this.cachePosition < this.cacheLimit) {
                count = Math.min(32 - this.bitCount >> 3, this.cacheLimit - this.cachePosition);
                while (0 < count--) {
                    this.bitBuffer |= (this.cache[this.cachePosition++] & 0xFF) << 24 - this.bitCount;
                    this.bitCount += 8;
                }
            } else if (this.bitCount <= 0) {
                throw new LocalEOFException(this);
            }
        }
    }

    private void fillCache() throws IOException {
        this.markPositionIsInCache = false;
        this.cacheLimit = 0;
        this.cachePosition = 0;
        int read = 0;
        while (0 <= read && this.cacheLimit < this.cache.length) {
            read = this.in.read(this.cache, this.cacheLimit, this.cache.length - this.cacheLimit);
            if (0 >= read) continue;
            this.cacheLimit += read;
        }
    }

    private static class LocalEOFException
    extends EOFException {
        private final Object owner;

        public LocalEOFException(Object object) {
            this.owner = object;
        }

        public boolean thrownBy(Object object) {
            return this.owner == object;
        }
    }
}

