/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.jlha;

import com.orangesignal.jlha.Factory;
import com.orangesignal.jlha.HashMethod;
import com.orangesignal.jlha.HashShort;
import com.orangesignal.jlha.LzssOutputStream;
import com.orangesignal.jlha.LzssSearchMethod;
import java.lang.reflect.InvocationTargetException;

public class HashAndBinaryTreeSearch
implements LzssSearchMethod {
    private static final int UNUSED = -1;
    private static final int ROOT_NODE = -2;
    private int dictionarySize;
    private int maxMatch;
    private int threshold;
    private byte[] textBuffer;
    private int dictionaryLimit;
    private HashMethod hashMethod;
    private int[] hashTable;
    private int[] parent;
    private int[] small;
    private int[] large;

    public HashAndBinaryTreeSearch(int dictionarySize, int maxMatch, int threshold, byte[] textBuffer) {
        this(dictionarySize, maxMatch, threshold, textBuffer, HashShort.class.getName());
    }

    public HashAndBinaryTreeSearch(int dictionarySize, int maxMatch, int threshold, byte[] textBuffer, String hashMethodClassName) {
        int i;
        this.dictionarySize = dictionarySize;
        this.maxMatch = maxMatch;
        this.threshold = threshold;
        this.textBuffer = textBuffer;
        this.dictionaryLimit = this.dictionarySize;
        try {
            this.hashMethod = (HashMethod)Factory.createInstance(hashMethodClassName, new Object[]{textBuffer});
        }
        catch (ClassNotFoundException exception) {
            throw new NoClassDefFoundError(exception.getMessage());
        }
        catch (InvocationTargetException exception) {
            throw new Error(exception.getTargetException().getMessage());
        }
        catch (NoSuchMethodException exception) {
            throw new NoSuchMethodError(exception.getMessage());
        }
        catch (InstantiationException exception) {
            throw new InstantiationError(exception.getMessage());
        }
        this.hashTable = new int[this.hashMethod.tableSize()];
        for (i = 0; i < this.hashTable.length; ++i) {
            this.hashTable[i] = -1;
        }
        this.parent = new int[dictionarySize];
        this.large = new int[dictionarySize];
        this.small = new int[dictionarySize];
        for (i = 0; i < this.parent.length; ++i) {
            this.parent[i] = -1;
        }
    }

    @Override
    public void put(int position) {
        this.deleteNode(position - this.dictionarySize);
        int hash = this.hashMethod.hash(position);
        int parentpos = this.hashTable[hash];
        int scanpos = this.hashTable[hash];
        byte[] buf = this.textBuffer;
        int max = position + this.maxMatch;
        int p = 0;
        int s = 0;
        while (scanpos != -1) {
            s = scanpos;
            p = position;
            while (buf[s] == buf[p]) {
                ++s;
                if (max > ++p) continue;
                this.replaceNode(scanpos, position);
                return;
            }
            parentpos = scanpos;
            scanpos = buf[s] < buf[p] ? this.large[scanpos & this.dictionarySize - 1] : this.small[scanpos & this.dictionarySize - 1];
        }
        if (this.hashTable[hash] != -1) {
            this.addNode(parentpos, position, p - position);
        } else {
            this.hashTable[hash] = position;
            int node = position & this.dictionarySize - 1;
            this.parent[node] = -2;
            this.small[node] = -1;
            this.large[node] = -1;
        }
    }

    @Override
    public int searchAndPut(int position) {
        this.deleteNode(position - this.dictionarySize);
        int hash = this.hashMethod.hash(position);
        int matchlen = -1;
        int matchpos = this.hashTable[hash];
        int parentpos = this.hashTable[hash];
        int scanpos = this.hashTable[hash];
        byte[] buf = this.textBuffer;
        int max = position + this.maxMatch;
        int p = 0;
        int s = 0;
        int len = 0;
        while (scanpos != -1) {
            s = scanpos;
            p = position;
            while (buf[s] == buf[p]) {
                ++s;
                if (max > ++p) continue;
                this.replaceNode(matchpos, position);
                return LzssOutputStream.createSearchReturn(matchlen, matchpos);
            }
            len = p - position;
            if (matchlen < len) {
                matchpos = scanpos;
                matchlen = len;
            } else if (matchlen == len && matchpos < scanpos) {
                matchpos = scanpos;
            }
            parentpos = scanpos;
            scanpos = buf[s] < buf[p] ? this.large[scanpos & this.dictionarySize - 1] : this.small[scanpos & this.dictionarySize - 1];
        }
        if (this.hashTable[hash] != -1) {
            this.addNode(parentpos, position, len);
        } else {
            this.hashTable[hash] = position;
            int node = position & this.dictionarySize - 1;
            this.parent[node] = -2;
            this.small[node] = -1;
            this.large[node] = -1;
        }
        scanpos = position - this.dictionarySize;
        if (this.dictionaryLimit <= scanpos) {
            len = 0;
            while (this.textBuffer[scanpos + len] == this.textBuffer[position + len] && this.maxMatch > ++len) {
            }
            if (matchlen < len) {
                matchpos = scanpos;
                matchlen = len;
            }
        }
        if (this.threshold <= matchlen) {
            return LzssOutputStream.createSearchReturn(matchlen, matchpos);
        }
        return -1;
    }

    @Override
    public int search(int position, int lastPutPos) {
        int scanpos;
        int matchlen = this.threshold - 1;
        int matchpos = position;
        int scanlimit = Math.max(this.dictionaryLimit, lastPutPos);
        byte[] buf = this.textBuffer;
        int max = Math.min(this.textBuffer.length, position + this.maxMatch);
        int s = 0;
        int p = 0;
        int len = 0;
        for (scanpos = position - 1; scanlimit < scanpos; --scanpos) {
            s = scanpos;
            p = position;
            while (buf[s] == buf[p]) {
                ++s;
                if (max > ++p) continue;
            }
            if (matchlen >= len) continue;
            matchpos = scanpos;
            matchlen = len;
        }
        if (this.hashMethod.hashRequires() <= this.textBuffer.length - position) {
            int hash = this.hashMethod.hash(position);
            scanpos = this.hashTable[hash];
            scanlimit = Math.max(this.dictionaryLimit, position - this.dictionarySize);
            while (scanpos != -1) {
                s = scanpos;
                p = position;
                while (buf[s] == buf[p]) {
                    ++s;
                    if (max > ++p) continue;
                }
                if (p >= max) break;
                len = p - position;
                if (scanlimit <= scanpos) {
                    if (matchlen < len) {
                        matchpos = scanpos;
                        matchlen = len;
                    } else if (matchlen == len && matchpos < scanpos) {
                        matchpos = scanpos;
                    }
                }
                scanpos = buf[s] < buf[p] ? this.large[scanpos & this.dictionarySize - 1] : this.small[scanpos & this.dictionarySize - 1];
            }
        }
        if (this.threshold <= matchlen) {
            return LzssOutputStream.createSearchReturn(matchlen, matchpos);
        }
        return -1;
    }

    @Override
    public void slide() {
        this.dictionaryLimit = Math.max(0, this.dictionaryLimit - this.dictionarySize);
        this.slideTree(this.hashTable);
        this.slideTree(this.parent);
        this.slideTree(this.small);
        this.slideTree(this.large);
    }

    @Override
    public int putRequires() {
        return this.maxMatch;
    }

    private void addNode(int parentpos, int position, int len) {
        int parentnode = parentpos & this.dictionarySize - 1;
        int node = position & this.dictionarySize - 1;
        if (this.textBuffer[parentpos + len] < this.textBuffer[position + len]) {
            this.large[parentnode] = position;
        } else {
            this.small[parentnode] = position;
        }
        this.parent[node] = parentpos;
        this.small[node] = -1;
        this.large[node] = -1;
    }

    private void deleteNode(int position) {
        int node = position & this.dictionarySize - 1;
        if (this.parent[node] != -1) {
            if (this.small[node] == -1 && this.large[node] == -1) {
                this.contractNode(position, -1);
            } else if (this.small[node] == -1) {
                this.contractNode(position, this.large[node]);
            } else if (this.large[node] == -1) {
                this.contractNode(position, this.small[node]);
            } else {
                int replace = this.findNext(position);
                this.deleteNode(replace);
                this.replaceNode(position, replace);
            }
        }
    }

    private void contractNode(int oldpos, int newpos) {
        int oldnode = oldpos & this.dictionarySize - 1;
        int newnode = newpos & this.dictionarySize - 1;
        int parentpos = this.parent[oldnode];
        int parentnode = parentpos & this.dictionarySize - 1;
        if (parentpos != -2) {
            if (oldpos == this.small[parentnode]) {
                this.small[parentnode] = newpos;
            } else {
                this.large[parentnode] = newpos;
            }
        } else {
            this.hashTable[this.hashMethod.hash((int)oldpos)] = newpos;
        }
        if (newpos != -1) {
            this.parent[newnode] = parentpos;
        }
        this.parent[oldnode] = -1;
    }

    private void replaceNode(int oldpos, int newpos) {
        int oldnode = oldpos & this.dictionarySize - 1;
        int newnode = newpos & this.dictionarySize - 1;
        int parentpos = this.parent[oldnode];
        int parentnode = parentpos & this.dictionarySize - 1;
        if (parentpos != -2) {
            if (oldpos == this.small[parentnode]) {
                this.small[parentnode] = newpos;
            } else {
                this.large[parentnode] = newpos;
            }
        } else {
            this.hashTable[this.hashMethod.hash((int)oldpos)] = newpos;
        }
        this.parent[newnode] = parentpos;
        this.small[newnode] = this.small[oldnode];
        this.large[newnode] = this.large[oldnode];
        if (this.small[newnode] != -1) {
            this.parent[this.small[newnode] & this.dictionarySize - 1] = newpos;
        }
        if (this.large[newnode] != -1) {
            this.parent[this.large[newnode] & this.dictionarySize - 1] = newpos;
        }
        this.parent[oldnode] = -1;
        this.large[oldnode] = -1;
        this.small[oldnode] = -1;
    }

    private int findNext(int position) {
        int node = position & this.dictionarySize - 1;
        position = this.small[node];
        node = position & this.dictionarySize - 1;
        while (-1 != this.large[node]) {
            position = this.large[node];
            node = position & this.dictionarySize - 1;
        }
        return position;
    }

    private void slideTree(int[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = 0 <= array[i] ? array[i] - this.dictionarySize : array[i];
        }
    }
}

