/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.jlha;

import com.orangesignal.jlha.CRC16;
import com.orangesignal.jlha.CompressMethod;
import com.orangesignal.jlha.LhaHeader;
import com.orangesignal.jlha.LhaProperty;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Properties;

public class LhaImmediateOutputStream
extends OutputStream {
    private RandomAccessFile archive;
    private OutputStream out;
    private LhaHeader header;
    private String encoding;
    private long headerpos;
    private CRC16 crc;
    private Properties property;

    public LhaImmediateOutputStream(String filename) throws FileNotFoundException {
        if (filename == null) {
            throw new NullPointerException("filename");
        }
        RandomAccessFile file = new RandomAccessFile(filename, "rw");
        Properties property = LhaProperty.getProperties();
        this.constructerHelper(file, property);
    }

    public LhaImmediateOutputStream(String filename, Properties property) throws FileNotFoundException {
        if (filename == null) {
            throw new NullPointerException("filename");
        }
        RandomAccessFile file = new RandomAccessFile(filename, "rw");
        this.constructerHelper(file, property);
    }

    public LhaImmediateOutputStream(File filename) throws IOException {
        if (filename == null) {
            throw new NullPointerException("filename");
        }
        RandomAccessFile file = new RandomAccessFile(filename, "rw");
        Properties property = LhaProperty.getProperties();
        this.constructerHelper(file, property);
    }

    public LhaImmediateOutputStream(File filename, Properties property) throws IOException {
        if (filename == null) {
            throw new NullPointerException("filename");
        }
        RandomAccessFile file = new RandomAccessFile(filename, "rw");
        this.constructerHelper(file, property);
    }

    public LhaImmediateOutputStream(RandomAccessFile file) {
        if (file == null) {
            throw new NullPointerException("out");
        }
        Properties property = LhaProperty.getProperties();
        this.constructerHelper(file, property);
    }

    public LhaImmediateOutputStream(RandomAccessFile file, Properties property) {
        if (file == null || property == null) {
            if (file == null) {
                throw new NullPointerException("null");
            }
            throw new NullPointerException("property");
        }
        this.constructerHelper(file, property);
    }

    private void constructerHelper(RandomAccessFile file, Properties property) {
        this.archive = file;
        this.out = null;
        this.header = null;
        this.headerpos = -1L;
        this.crc = new CRC16();
        this.property = property;
    }

    @Override
    public void write(int data) throws IOException {
        if (this.out != null) {
            if (this.header != null) {
                this.crc.update(data);
            }
        } else {
            throw new IOException("no entry");
        }
        this.out.write(data);
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(byte[] buffer, int index, int length) throws IOException {
        if (this.out != null) {
            if (this.header != null) {
                this.crc.update(buffer, index, length);
            }
        } else {
            throw new IOException("no entry");
        }
        this.out.write(buffer, index, length);
    }

    @Override
    public void flush() throws IOException {
        if (this.out == null) {
            throw new IOException("no entry");
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            this.closeEntry();
        }
        this.archive.write(0);
        try {
            this.archive.setLength(this.archive.getFilePointer());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        this.archive.close();
        this.archive = null;
        this.crc = null;
        this.property = null;
        this.encoding = null;
    }

    public void putNextEntry(LhaHeader header) throws IOException {
        if (header.getCompressedSize() == -1L || header.getCrc() == -1) {
            this.putNextEntryNotYetCompressed(header);
        } else {
            this.putNextEntryAlreadyCompressed(header);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void putNextEntryAlreadyCompressed(LhaHeader header) throws IOException {
        if (this.out != null) throw new IllegalStateException("entry is not closed.");
        if (header.getOriginalSize() != -1L && header.getCompressedSize() != -1L && header.getCrc() != -1) {
            this.headerpos = this.archive.getFilePointer();
            this.encoding = this.property.getProperty("lha.encoding");
            if (this.encoding == null) {
                this.encoding = LhaProperty.getProperty("lha.encoding");
            }
        } else {
            if (header.getOriginalSize() == -1L) {
                throw new IllegalArgumentException("OriginalSize must not \"LhaHeader.UNKNOWN\".");
            }
            if (header.getCompressedSize() != -1L) throw new IllegalArgumentException("CRC must not \"LhaHeader.UNKNOWN\".");
            throw new IllegalArgumentException("CompressedSize must not \"LhaHeader.UNKNOWN\".");
        }
        this.archive.write(header.getBytes(this.encoding));
        this.out = new RandomAccessFileOutputStream(this.archive, header.getCompressedSize());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void putNextEntryNotYetCompressed(LhaHeader header) throws IOException {
        if (this.out != null) throw new IllegalStateException("entry is not closed.");
        if (header.getOriginalSize() == -1L) throw new IllegalArgumentException("OriginalSize must not \"LhaHeader.UNKNOWN\".");
        this.crc.reset();
        this.headerpos = this.archive.getFilePointer();
        this.header = (LhaHeader)header.clone();
        this.header.setCompressedSize(0L);
        this.header.setCrc(0);
        this.encoding = this.property.getProperty("lha.encoding");
        if (this.encoding == null) {
            this.encoding = LhaProperty.getProperty("lha.encoding");
        }
        this.archive.write(this.header.getBytes(this.encoding));
        this.out = new RandomAccessFileOutputStream(this.archive, header.getOriginalSize());
        this.out = CompressMethod.connectEncoder(this.out, header.getCompressMethod(), this.property);
    }

    public boolean closeEntry() throws IOException {
        if (this.out != null) {
            this.out.close();
            if (this.header != null) {
                long pos = this.archive.getFilePointer();
                long size = pos - this.headerpos - (long)this.header.getBytes(this.encoding).length;
                this.header.setCompressedSize(size);
                if (this.header.getCrc() != -2) {
                    this.header.setCrc((int)this.crc.getValue());
                }
                this.archive.seek(this.headerpos);
                if (this.header.getCompressMethod().equals("-lh0-") || this.header.getCompressMethod().equals("-lhd-") || this.header.getCompressMethod().equals("-lz4-") || this.header.getCompressedSize() < this.header.getOriginalSize()) {
                    this.archive.write(this.header.getBytes(this.encoding));
                    this.archive.seek(pos);
                    this.header = null;
                    this.out = null;
                    return true;
                }
                this.header = null;
                this.out = null;
                return false;
            }
            this.out = null;
            return true;
        }
        return true;
    }

    private static class RandomAccessFileOutputStream
    extends OutputStream {
        private RandomAccessFile archive;
        private long pos;
        private final long limit;

        public RandomAccessFileOutputStream(RandomAccessFile archive, long length) throws IOException {
            this.archive = archive;
            this.pos = this.archive.getFilePointer();
            this.limit = this.pos + length;
        }

        @Override
        public void write(int data) throws IOException {
            if (this.pos < this.limit) {
                ++this.pos;
                this.archive.write(data);
            }
        }

        @Override
        public void write(byte[] buffer) throws IOException {
            this.write(buffer, 0, buffer.length);
        }

        @Override
        public void write(byte[] buffer, int index, int length) throws IOException {
            if (this.limit < this.pos + (long)length) {
                length = (int)Math.max(this.limit - this.pos, 0L);
            }
            this.archive.write(buffer, index, length);
            this.pos += (long)length;
        }

        @Override
        public void close() {
            this.archive = null;
        }
    }
}

