/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.jlha;

import com.orangesignal.jlha.CRC16;
import com.orangesignal.jlha.CompressMethod;
import com.orangesignal.jlha.GrowthByteBuffer;
import com.orangesignal.jlha.LhaHeader;
import com.orangesignal.jlha.LhaProperty;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Properties;

public class LhaOutputStream
extends OutputStream {
    private OutputStream out;
    private CRC16 crc;
    private Temporary temp;
    private LhaHeader header;
    private OutputStream tempOut;
    private long length;
    private Properties property;

    public LhaOutputStream(OutputStream out) {
        if (out == null) {
            throw new NullPointerException("out");
        }
        Properties property = LhaProperty.getProperties();
        this.constructerHelper(out, new TemporaryBuffer(), property);
    }

    public LhaOutputStream(OutputStream out, Properties property) {
        if (out == null || property == null) {
            if (out == null) {
                throw new NullPointerException("out");
            }
            throw new NullPointerException("property");
        }
        this.constructerHelper(out, new TemporaryBuffer(), property);
    }

    public LhaOutputStream(OutputStream out, RandomAccessFile file) {
        if (out == null || file == null) {
            if (out == null) {
                throw new NullPointerException("out");
            }
            throw new NullPointerException("file");
        }
        Properties property = LhaProperty.getProperties();
        this.constructerHelper(out, new TemporaryFile(file), property);
    }

    public LhaOutputStream(OutputStream out, RandomAccessFile file, Properties property) {
        if (out == null || file == null || property == null) {
            if (out == null) {
                throw new NullPointerException("out");
            }
            if (file == null) {
                throw new NullPointerException("file");
            }
            throw new NullPointerException("property");
        }
        this.constructerHelper(out, new TemporaryFile(file), property);
    }

    private void constructerHelper(OutputStream out, Temporary temp, Properties property) {
        this.out = out;
        this.temp = temp;
        this.property = property;
        this.crc = new CRC16();
        this.header = null;
        this.tempOut = null;
    }

    @Override
    public void write(int data) throws IOException {
        if (this.tempOut != null) {
            if (this.header != null) {
                this.crc.update(data);
            }
            this.tempOut.write(data);
            ++this.length;
        } else {
            throw new IOException("no entry");
        }
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(byte[] buffer, int index, int length) throws IOException {
        if (this.tempOut != null) {
            if (this.header != null) {
                this.crc.update(buffer, index, length);
            }
            this.tempOut.write(buffer, index, length);
            this.length += (long)length;
        } else {
            throw new IOException("no entry");
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.tempOut != null) {
            this.tempOut.flush();
        }
        if (this.tempOut != this.out) {
            this.out.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.tempOut != null) {
            this.closeEntry();
        }
        this.out.write(0);
        this.out.close();
        this.out = null;
        this.temp.close();
        this.temp = null;
        this.property = null;
        this.crc = null;
        this.header = null;
    }

    public void putNextEntry(LhaHeader header) throws IOException {
        if (header.getCompressedSize() == -1L || header.getOriginalSize() == -1L || header.getCrc() == -1) {
            this.putNextEntryNotYetCompressed(header);
        } else {
            this.putNextEntryAlreadyCompressed(header);
        }
    }

    public void putNextEntryAlreadyCompressed(LhaHeader header) throws IOException {
        String encoding;
        if (header.getOriginalSize() != -1L && header.getCompressedSize() != -1L && header.getCrc() != -1) {
            if (this.tempOut != null) {
                this.closeEntry();
            }
            if ((encoding = this.property.getProperty("lha.encoding")) == null) {
                encoding = LhaProperty.getProperty("lha.encoding");
            }
        } else {
            if (header.getOriginalSize() == -1L) {
                throw new IllegalArgumentException("OriginalSize must not \"LhaHeader.UNKNOWN\".");
            }
            if (header.getCompressedSize() == -1L) {
                throw new IllegalArgumentException("CompressedSize must not \"LhaHeader.UNKNOWN\".");
            }
            throw new IllegalArgumentException("CRC must not \"LhaHeader.UNKNOWN\".");
        }
        this.out.write(header.getBytes(encoding));
        this.tempOut = this.out;
    }

    public void putNextEntryNotYetCompressed(LhaHeader header) throws IOException {
        if (this.tempOut != null) {
            this.closeEntry();
        }
        this.crc.reset();
        this.length = 0L;
        this.header = (LhaHeader)header.clone();
        this.tempOut = CompressMethod.connectEncoder(this.temp.getOutputStream(), header.getCompressMethod(), this.property);
    }

    public void closeEntry() throws IOException {
        if (this.header != null) {
            int length;
            InputStream in;
            this.tempOut.close();
            if (this.temp.length() < this.length) {
                this.header.setOriginalSize(this.length);
                this.header.setCompressedSize(this.temp.length());
                this.header.setCrc((int)this.crc.getValue());
                in = this.temp.getInputStream();
            } else {
                String method = this.header.getCompressMethod();
                this.header.setOriginalSize(this.length);
                this.header.setCompressedSize(this.length);
                this.header.setCrc((int)this.crc.getValue());
                if (!this.header.getCompressMethod().equalsIgnoreCase("-lhd-")) {
                    this.header.setCompressMethod("-lh0-");
                }
                in = this.temp.getInputStream();
                in = CompressMethod.connectDecoder(in, method, this.property, this.temp.length());
            }
            String encoding = this.property.getProperty("lha.encoding");
            if (encoding == null) {
                encoding = LhaProperty.getProperty("lha.encoding");
            }
            this.out.write(this.header.getBytes(encoding));
            byte[] buffer = new byte[8192];
            while (0 <= (length = in.read(buffer))) {
                this.out.write(buffer, 0, length);
            }
        }
        this.header = null;
        this.tempOut = null;
    }

    private static class TemporaryBuffer
    implements Temporary {
        private GrowthByteBuffer tempbuffer = new GrowthByteBuffer();

        @Override
        public InputStream getInputStream() {
            return new TemporaryBufferInputStream();
        }

        @Override
        public OutputStream getOutputStream() {
            return new TemporaryBufferOutputStream();
        }

        @Override
        public long length() {
            return this.tempbuffer.length();
        }

        @Override
        public void close() {
            this.tempbuffer = null;
        }

        private class TemporaryBufferOutputStream
        extends OutputStream {
            public TemporaryBufferOutputStream() {
                TemporaryBuffer.this.tempbuffer.seek(0);
                TemporaryBuffer.this.tempbuffer.setLength(0);
            }

            @Override
            public void write(int data) {
                TemporaryBuffer.this.tempbuffer.write(data);
            }

            @Override
            public void write(byte[] buffer) {
                TemporaryBuffer.this.tempbuffer.write(buffer);
            }

            @Override
            public void write(byte[] buffer, int index, int length) {
                TemporaryBuffer.this.tempbuffer.write(buffer, index, length);
            }
        }

        private class TemporaryBufferInputStream
        extends InputStream {
            public TemporaryBufferInputStream() {
                TemporaryBuffer.this.tempbuffer.seek(0);
            }

            @Override
            public int read() {
                return TemporaryBuffer.this.tempbuffer.read();
            }

            @Override
            public int read(byte[] buffer) {
                return TemporaryBuffer.this.tempbuffer.read(buffer);
            }

            @Override
            public int read(byte[] buffer, int index, int length) {
                return TemporaryBuffer.this.tempbuffer.read(buffer, index, length);
            }
        }
    }

    private static class TemporaryFile
    implements Temporary {
        private RandomAccessFile tempfile;
        private long length;

        public TemporaryFile(RandomAccessFile file) {
            if (file == null) {
                throw new NullPointerException("file");
            }
            this.tempfile = file;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new TemporaryFileInputStream();
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return new TemporaryFileOutputStream();
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public void close() throws IOException {
            this.tempfile.close();
            this.tempfile = null;
        }

        private class TemporaryFileOutputStream
        extends OutputStream {
            public TemporaryFileOutputStream() throws IOException {
                TemporaryFile.this.tempfile.seek(0L);
                TemporaryFile.this.length = 0L;
            }

            @Override
            public void write(int data) throws IOException {
                TemporaryFile.this.tempfile.write(data);
                TemporaryFile.this.length++;
            }

            @Override
            public void write(byte[] buffer) throws IOException {
                TemporaryFile.this.tempfile.write(buffer);
                TemporaryFile.this.length += buffer.length;
            }

            @Override
            public void write(byte[] buffer, int index, int length) throws IOException {
                TemporaryFile.this.tempfile.write(buffer, index, length);
                TemporaryFile.this.length += length;
            }
        }

        private class TemporaryFileInputStream
        extends InputStream {
            public TemporaryFileInputStream() throws IOException {
                TemporaryFile.this.tempfile.seek(0L);
            }

            @Override
            public int read() throws IOException {
                long limit;
                long pos = TemporaryFile.this.tempfile.getFilePointer();
                if (pos < (limit = TemporaryFile.this.length)) {
                    return TemporaryFile.this.tempfile.read();
                }
                return -1;
            }

            @Override
            public int read(byte[] buffer) throws IOException {
                return this.read(buffer, 0, buffer.length);
            }

            @Override
            public int read(byte[] buffer, int index, int length) throws IOException {
                long pos = TemporaryFile.this.tempfile.getFilePointer();
                long limit = TemporaryFile.this.length;
                length = (int)(Math.min(pos + (long)length, limit) - pos);
                if (pos < limit) {
                    return TemporaryFile.this.tempfile.read(buffer, index, length);
                }
                return -1;
            }
        }
    }

    private static interface Temporary {
        public InputStream getInputStream() throws IOException;

        public OutputStream getOutputStream() throws IOException;

        public long length() throws IOException;

        public void close() throws IOException;
    }
}

