/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.jlha;

import com.orangesignal.jlha.Bits;
import com.orangesignal.jlha.LzssOutputStream;
import com.orangesignal.jlha.LzssSearchMethod;
import java.math.BigInteger;

public class PatriciaTrieSearch
implements LzssSearchMethod {
    private static final int UNUSED = 0;
    private final int dictionarySize;
    private final int maxMatch;
    private final int threshold;
    private final byte[] textBuffer;
    private int dictionaryLimit;
    private final int[] parent;
    private final int[] hashTable;
    private final int[] prev;
    private final int[] next;
    private final int[] position;
    private final int[] level;
    private final int[] childnum;
    private int avail;
    private final int shift;
    private int lastMatchPos;
    private int lastMatchLen;

    public PatriciaTrieSearch(int DictionarySize, int MaxMatch, int Threshold, byte[] TextBuffer) {
        int i;
        this.dictionarySize = DictionarySize;
        this.maxMatch = MaxMatch;
        this.threshold = Threshold;
        this.textBuffer = TextBuffer;
        this.dictionaryLimit = this.dictionarySize;
        this.parent = new int[this.dictionarySize * 2];
        this.prev = new int[this.dictionarySize * 2];
        this.next = new int[this.dictionarySize * 2];
        this.position = new int[this.dictionarySize];
        this.level = new int[this.dictionarySize];
        this.childnum = new int[this.dictionarySize];
        this.hashTable = new int[PatriciaTrieSearch.generateProbablePrime(this.dictionarySize + (this.dictionarySize >> 2))];
        for (i = 2; i < this.dictionarySize; ++i) {
            this.next[i] = i - 1;
        }
        this.avail = this.dictionarySize - 1;
        for (i = 0; i < this.dictionarySize * 2; ++i) {
            this.parent[i] = 0;
        }
        for (i = 0; i < this.hashTable.length; ++i) {
            this.hashTable[i] = 0;
        }
        this.shift = Bits.len(this.dictionarySize) - 8;
        this.lastMatchLen = 0;
        this.lastMatchPos = 0;
    }

    @Override
    public void put(int position) {
        int matchlen;
        int matchpos;
        block13: {
            int max;
            int scannode;
            int posnode = (position & this.dictionarySize - 1) + this.dictionarySize;
            this.deleteNode(posnode);
            int matchnode = -1;
            matchpos = position;
            if (3 < this.lastMatchLen) {
                scannode = this.lastMatchPos + 1 | this.dictionarySize;
                while (this.parent[scannode] == 0) {
                    scannode = this.next[scannode];
                }
                int node = this.parent[scannode];
                --this.lastMatchLen;
                while (0 < node && this.lastMatchLen <= this.level[node]) {
                    scannode = node;
                    node = this.parent[node];
                }
                while (0 < node) {
                    this.position[node] = position;
                    node = this.parent[node];
                }
                matchlen = this.lastMatchLen;
            } else {
                scannode = this.child(this.textBuffer[position] - 128, this.textBuffer[position + 1] & 0xFF);
                matchlen = 2;
                if (scannode == 0) {
                    this.attachNode(this.textBuffer[position] - 128, posnode, this.textBuffer[position + 1] & 0xFF);
                    this.lastMatchLen = matchlen;
                    return;
                }
            }
            while (true) {
                if (scannode < this.dictionarySize) {
                    max = this.level[scannode];
                    matchnode = scannode;
                    matchpos = this.position[scannode];
                } else {
                    max = this.maxMatch;
                    matchnode = scannode;
                    int n = matchpos = position <= scannode ? scannode - this.dictionarySize : scannode;
                }
                while (matchlen < max && this.textBuffer[matchpos + matchlen] == this.textBuffer[position + matchlen]) {
                    ++matchlen;
                }
                if (matchlen != max || matchlen >= this.maxMatch) break;
                this.position[scannode] = position;
                if ((scannode = this.child(scannode, this.textBuffer[position + matchlen] & 0xFF)) == 0) {
                    this.attachNode(matchnode, posnode, this.textBuffer[position + matchlen] & 0xFF);
                    break block13;
                }
                ++matchlen;
            }
            if (matchlen < max) {
                this.splitNode(matchnode, matchpos, posnode, position, matchlen);
            } else {
                this.replaceNode(matchnode, posnode);
                this.next[matchnode] = position;
            }
        }
        this.lastMatchLen = matchlen;
        this.lastMatchPos = matchpos;
    }

    @Override
    public int searchAndPut(int position) {
        int matchlen;
        int scannode;
        int matchpos;
        block18: {
            int posnode = (position & this.dictionarySize - 1) + this.dictionarySize;
            this.deleteNode(posnode);
            int matchnode = -1;
            matchpos = position;
            scannode = 0;
            matchlen = 0;
            if (3 < this.lastMatchLen) {
                scannode = this.lastMatchPos + 1 | this.dictionarySize;
                while (this.parent[scannode] == 0) {
                    scannode = this.next[scannode];
                }
                int node = this.parent[scannode];
                --this.lastMatchLen;
                while (0 < node && this.lastMatchLen <= this.level[node]) {
                    scannode = node;
                    node = this.parent[node];
                }
                while (0 < node) {
                    this.position[node] = position;
                    node = this.parent[node];
                }
                matchlen = this.lastMatchLen;
            } else {
                scannode = this.child(this.textBuffer[position] - 128, this.textBuffer[position + 1] & 0xFF);
                matchlen = 2;
            }
            if (scannode != 0) {
                int max;
                while (true) {
                    if (scannode < this.dictionarySize) {
                        max = this.level[scannode];
                        matchnode = scannode;
                        matchpos = this.position[scannode];
                    } else {
                        max = this.maxMatch;
                        matchnode = scannode;
                        int n = matchpos = position <= scannode ? scannode - this.dictionarySize : scannode;
                    }
                    while (matchlen < max && this.textBuffer[matchpos + matchlen] == this.textBuffer[position + matchlen]) {
                        ++matchlen;
                    }
                    if (matchlen != max || matchlen >= this.maxMatch) break;
                    this.position[scannode] = position;
                    if ((scannode = this.child(scannode, this.textBuffer[position + matchlen] & 0xFF)) == 0) {
                        this.attachNode(matchnode, posnode, this.textBuffer[position + matchlen] & 0xFF);
                        break block18;
                    }
                    ++matchlen;
                }
                if (matchlen < max) {
                    this.splitNode(matchnode, matchpos, posnode, position, matchlen);
                } else {
                    this.replaceNode(matchnode, posnode);
                    this.next[matchnode] = position;
                }
            } else {
                this.attachNode(this.textBuffer[position] - 128, posnode, this.textBuffer[position + 1] & 0xFF);
                matchlen = 0;
            }
        }
        this.lastMatchLen = matchlen;
        this.lastMatchPos = matchpos;
        scannode = position - this.dictionarySize;
        if (this.dictionaryLimit <= scannode) {
            int len = 0;
            while (this.textBuffer[scannode + len] == this.textBuffer[position + len] && this.maxMatch > ++len) {
            }
            if (matchlen < len) {
                matchpos = scannode;
                matchlen = len;
            }
        }
        if (this.threshold <= matchlen) {
            return LzssOutputStream.createSearchReturn(matchlen, matchpos);
        }
        return -1;
    }

    @Override
    public int search(int position, int lastPutPos) {
        int scanpos;
        int scanlimit = Math.max(this.dictionaryLimit, lastPutPos);
        int matchlen = 0;
        int matchpos = 0;
        byte[] buf = this.textBuffer;
        int max = Math.min(this.textBuffer.length, position + this.maxMatch);
        int s = 0;
        int p = 0;
        int len = 0;
        for (scanpos = position - 1; scanlimit < scanpos; --scanpos) {
            s = scanpos;
            p = position;
            while (buf[s] == buf[p]) {
                ++s;
                if (max > ++p) continue;
            }
            if (matchlen >= (len = p - position)) continue;
            matchpos = scanpos;
            matchlen = len;
            if (max <= p) break;
        }
        if (2 < this.textBuffer.length - position) {
            int matchnode = this.child(this.textBuffer[position] - 128, this.textBuffer[position + 1] & 0xFF);
            scanlimit = Math.max(this.dictionaryLimit, position - this.dictionarySize);
            len = 2;
            while (matchnode != 0) {
                int maxlen;
                if (matchnode < this.dictionarySize) {
                    maxlen = this.level[matchnode];
                    scanpos = this.position[matchnode];
                } else {
                    maxlen = this.maxMatch;
                    int n = scanpos = lastPutPos < matchnode ? matchnode - this.dictionarySize : matchnode;
                }
                if (scanlimit > scanpos) break;
                max = Math.min(this.textBuffer.length, position + maxlen);
                s = scanpos + len;
                p = position + len;
                if (p < max) {
                    while (buf[s] == buf[p]) {
                        ++s;
                        if (max > ++p) continue;
                    }
                }
                if (matchlen < (len = p - position)) {
                    matchpos = scanpos;
                    matchlen = len;
                }
                if (len != maxlen || matchlen >= this.maxMatch || position + len >= this.textBuffer.length) break;
                if ((matchnode = this.child(matchnode, this.textBuffer[position + len] & 0xFF)) == 0) continue;
                ++len;
            }
        }
        if (this.threshold <= matchlen) {
            return LzssOutputStream.createSearchReturn(matchlen, matchpos);
        }
        return -1;
    }

    @Override
    public void slide() {
        this.dictionaryLimit = Math.max(0, this.dictionaryLimit - this.dictionarySize);
        this.lastMatchPos -= this.dictionarySize;
        for (int i = 0; i < this.position.length; ++i) {
            int pos = this.position[i] - this.dictionarySize;
            this.position[i] = 0 < pos ? pos : 0;
        }
    }

    @Override
    public int putRequires() {
        return this.maxMatch;
    }

    private void splitNode(int oldnode, int oldpos, int posnode, int position, int splitLen) {
        int newnode = this.avail;
        this.avail = this.next[newnode];
        this.replaceNode(oldnode, newnode);
        this.level[newnode] = splitLen;
        this.position[newnode] = position;
        this.childnum[newnode] = 0;
        this.attachNode(newnode, oldnode, this.textBuffer[oldpos + splitLen] & 0xFF);
        this.attachNode(newnode, posnode, this.textBuffer[position + splitLen] & 0xFF);
    }

    private void deleteNode(int node) {
        if (this.parent[node] != 0) {
            int parent = this.parent[node];
            int prev = this.prev[node];
            int next = this.next[node];
            this.parent[node] = 0;
            this.prev[node] = 0;
            this.next[node] = 0;
            if (0 <= prev) {
                this.next[prev] = next;
            } else {
                this.hashTable[prev ^ 0xFFFFFFFF] = next;
            }
            this.prev[next] = prev;
            if (0 < parent) {
                int n = parent;
                this.childnum[n] = this.childnum[n] - 1;
                if (this.childnum[parent] <= 1) {
                    this.contractNode(this.child(parent, this.textBuffer[this.position[parent] + this.level[parent]] & 0xFF));
                }
            }
        }
    }

    private void attachNode(int parentnode, int childnode, int ch) {
        int hash = this.hash(parentnode, ch);
        int node = this.hashTable[hash];
        this.hashTable[hash] = childnode;
        this.parent[childnode] = parentnode;
        this.prev[childnode] = ~hash;
        this.next[childnode] = node;
        this.prev[node] = childnode;
        if (0 < parentnode) {
            int n = parentnode;
            this.childnum[n] = this.childnum[n] + 1;
        }
    }

    private void replaceNode(int oldnode, int newnode) {
        this.parent[newnode] = this.parent[oldnode];
        this.prev[newnode] = this.prev[oldnode];
        this.next[newnode] = this.next[oldnode];
        this.prev[this.next[newnode]] = newnode;
        if (this.prev[newnode] < 0) {
            this.hashTable[this.prev[newnode] ^ 0xFFFFFFFF] = newnode;
        } else {
            this.next[this.prev[newnode]] = newnode;
        }
        this.parent[oldnode] = 0;
        this.prev[oldnode] = 0;
        this.next[oldnode] = 0;
    }

    private void contractNode(int node) {
        int parentnode = this.parent[node];
        this.prev[this.next[node]] = this.prev[node];
        if (0 <= this.prev[node]) {
            this.next[this.prev[node]] = this.next[node];
        } else {
            this.hashTable[this.prev[node] ^ 0xFFFFFFFF] = this.next[node];
        }
        this.replaceNode(parentnode, node);
        this.next[parentnode] = this.avail;
        this.avail = parentnode;
    }

    private int child(int parent, int ch) {
        int node = this.hashTable[this.hash(parent, ch)];
        while (node != 0 && this.parent[node] != parent) {
            node = this.next[node];
        }
        return node;
    }

    private int hash(int node, int ch) {
        return (node + (ch << this.shift) + 256) % this.hashTable.length;
    }

    private static int generateProbablePrime(int num) {
        num += (num & 1) == 0 ? 1 : 0;
        while (!new BigInteger(Integer.toString(num)).isProbablePrime(8)) {
            num += (num += (num += (num += 2) % 3 == 0 ? 2 : 0) % 5 == 0 ? 2 : 0) % 7 == 0 ? 2 : 0;
        }
        return num;
    }
}

