/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.jlha;

import com.orangesignal.jlha.BitOutputStream;
import com.orangesignal.jlha.Bits;
import com.orangesignal.jlha.PostLzssEncoder;
import java.io.IOException;
import java.io.OutputStream;

public class PostLzsEncoder
implements PostLzssEncoder {
    private static final int DICTIONARY_SIZE = 2048;
    private static final int MAX_MATCH = 17;
    private static final int THRESHOLD = 2;
    private static final int PositionBits = Bits.len(2047);
    private static final int LengthBits = Bits.len(15);
    private BitOutputStream out;
    private int position;
    private int matchLength;

    public PostLzsEncoder(OutputStream out) {
        if (out == null) {
            throw new NullPointerException("out");
        }
        this.out = out instanceof BitOutputStream ? (BitOutputStream)out : new BitOutputStream(out);
        this.position = 0;
        this.matchLength = 0;
    }

    @Override
    public void writeCode(int code) throws IOException {
        if (code < 256) {
            this.out.writeBit(1);
            this.out.writeBits(8, code);
            ++this.position;
        } else {
            this.out.writeBit(0);
            this.matchLength = code - 256;
        }
    }

    @Override
    public void writeOffset(int offset) throws IOException {
        int pos = this.position - offset - 1 - 17 & 0x7FF;
        this.position += this.matchLength + 2;
        this.out.writeBits(PositionBits, pos);
        this.out.writeBits(LengthBits, this.matchLength);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        this.out = null;
    }

    @Override
    public int getDictionarySize() {
        return 2048;
    }

    @Override
    public int getMaxMatch() {
        return 17;
    }

    @Override
    public int getThreshold() {
        return 2;
    }
}

