/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.jlha;

import com.orangesignal.jlha.BadHuffmanTableException;

final class StaticHuffman {
    public static final int LIMIT_LEN = 16;

    private StaticHuffman() {
    }

    public static int[] FreqListToLenList(int[] FreqList) {
        int[] NodeWeight = new int[FreqList.length * 2 - 1];
        int[] SmallNode = new int[FreqList.length * 2 - 1];
        int[] LargeNode = new int[FreqList.length * 2 - 1];
        int TreeCount = FreqList.length;
        int[] Leafs = new int[FreqList.length];
        int LeafCount = 0;
        int[] Nodes = new int[FreqList.length - 1];
        int NodeCount = 0;
        for (int i = 0; i < FreqList.length; ++i) {
            NodeWeight[i] = FreqList[i];
            if (0 >= FreqList[i]) continue;
            Leafs[LeafCount++] = i;
        }
        if (2 <= LeafCount) {
            StaticHuffman.mergeSort(Leafs, 0, LeafCount - 1, FreqList, new int[LeafCount / 2 + 1]);
            int LeafIndex = 0;
            int NodeIndex = 0;
            do {
                int small = NodeCount <= NodeIndex ? Leafs[LeafIndex++] : (LeafCount <= LeafIndex ? Nodes[NodeIndex++] : (NodeWeight[Leafs[LeafIndex]] <= NodeWeight[Nodes[NodeIndex]] ? Leafs[LeafIndex++] : Nodes[NodeIndex++]));
                int large = NodeCount <= NodeIndex ? Leafs[LeafIndex++] : (LeafCount <= LeafIndex ? Nodes[NodeIndex++] : (NodeWeight[Leafs[LeafIndex]] <= NodeWeight[Nodes[NodeIndex]] ? Leafs[LeafIndex++] : Nodes[NodeIndex++]));
                int newNode = TreeCount++;
                NodeWeight[newNode] = NodeWeight[small] + NodeWeight[large];
                SmallNode[newNode] = small;
                LargeNode[newNode] = large;
                Nodes[NodeCount++] = newNode;
            } while (NodeIndex + LeafIndex < NodeCount + LeafCount - 1);
            int[] LenFreq = StaticHuffman.huffmanTreeToLenFreq(SmallNode, LargeNode, TreeCount - 1);
            int[] LenList = new int[FreqList.length];
            LeafIndex = 0;
            int len = 16;
            while (0 < len) {
                while (true) {
                    int n = len--;
                    int n2 = LenFreq[n];
                    LenFreq[n] = n2 - 1;
                    if (0 >= n2) break;
                    LenList[Leafs[LeafIndex++]] = len;
                }
            }
            return LenList;
        }
        return new int[FreqList.length];
    }

    public static int[] FreqListToLenListOriginal(int[] FreqList) {
        int i;
        int[] NodeWeight = new int[FreqList.length * 2 - 1];
        int[] SmallNode = new int[FreqList.length * 2 - 1];
        int[] LargeNode = new int[FreqList.length * 2 - 1];
        int TreeCount = FreqList.length;
        int[] Leafs = new int[FreqList.length];
        int LeafCount = 0;
        int[] Heap = new int[FreqList.length * 2];
        int HeapLast = 0;
        for (i = 0; i < FreqList.length; ++i) {
            NodeWeight[i] = FreqList[i];
            if (0 >= FreqList[i]) continue;
            Heap[++HeapLast] = i;
        }
        if (2 <= HeapLast) {
            for (i = HeapLast / 2; 1 <= i; --i) {
                StaticHuffman.downHeap(Heap, HeapLast, NodeWeight, i);
            }
            do {
                int small;
                if ((small = Heap[1]) < FreqList.length) {
                    Leafs[LeafCount++] = small;
                }
                Heap[1] = Heap[HeapLast--];
                StaticHuffman.downHeap(Heap, HeapLast, NodeWeight, 1);
                int large = Heap[1];
                if (large < FreqList.length) {
                    Leafs[LeafCount++] = large;
                }
                int newNode = TreeCount++;
                NodeWeight[newNode] = NodeWeight[small] + NodeWeight[large];
                SmallNode[newNode] = small;
                LargeNode[newNode] = large;
                Heap[1] = newNode;
                StaticHuffman.downHeap(Heap, HeapLast, NodeWeight, 1);
            } while (1 < HeapLast);
            int[] LenFreq = StaticHuffman.huffmanTreeToLenFreq(SmallNode, LargeNode, TreeCount - 1);
            int[] LenList = new int[FreqList.length];
            int LeafIndex = 0;
            int len = 16;
            while (0 < len) {
                while (true) {
                    int n = len--;
                    int n2 = LenFreq[n];
                    LenFreq[n] = n2 - 1;
                    if (0 >= n2) break;
                    LenList[Leafs[LeafIndex++]] = len;
                }
            }
            return LenList;
        }
        return new int[FreqList.length];
    }

    public static int[] LenListToCodeList(int[] LenList) throws BadHuffmanTableException {
        int i;
        int[] LenFreq = new int[17];
        int[] CodeStart = new int[18];
        for (i = 0; i < LenList.length; ++i) {
            int n = LenList[i];
            LenFreq[n] = LenFreq[n] + 1;
        }
        if (LenFreq[0] < LenList.length) {
            for (i = 1; i <= 16; ++i) {
                CodeStart[i + 1] = CodeStart[i] + LenFreq[i] << 1;
            }
            if (CodeStart[17] != 131072) {
                throw new BadHuffmanTableException();
            }
            int[] CodeList = new int[LenList.length];
            for (int i2 = 0; i2 < CodeList.length; ++i2) {
                if (0 >= LenList[i2]) continue;
                int n = LenList[i2];
                CodeStart[n] = CodeStart[n] + 1;
            }
            return CodeList;
        }
        return new int[LenList.length];
    }

    public static short[] createTable(int[] LenList) throws BadHuffmanTableException {
        int[] CodeList = StaticHuffman.LenListToCodeList(LenList);
        int TableBits = 0;
        int LastCode = 0;
        for (int i = 0; i < LenList.length; ++i) {
            if (TableBits > LenList[i]) continue;
            TableBits = LenList[i];
            LastCode = i;
        }
        short[] Table = new short[1 << TableBits];
        for (int i = 0; i < LenList.length; ++i) {
            if (0 >= LenList[i]) continue;
            int start = CodeList[i] << TableBits - LenList[i];
            int end = i != LastCode ? start + (1 << TableBits - LenList[i]) : Table.length;
            for (int j = start; j < end; ++j) {
                Table[j] = (short)i;
            }
        }
        return Table;
    }

    public static short[][] createTableAndTree(int[] LenList, int TableBits) throws BadHuffmanTableException {
        int[] CodeList = StaticHuffman.LenListToCodeList(LenList);
        short[] Table = new short[1 << TableBits];
        int LastCode = 0;
        for (int i = 0; i < LenList.length; ++i) {
            if (LenList[LastCode] <= LenList[i]) {
                LastCode = i;
            }
            if (TableBits >= LenList[i]) continue;
            int n = CodeList[i] >> LenList[i] - TableBits;
            Table[n] = (short)(Table[n] + 1);
        }
        int INIT = -1;
        int count = 0;
        for (int i = 0; i < Table.length; ++i) {
            if (0 < Table[i]) {
                count += Table[i] - 1;
            }
            Table[i] = -1;
        }
        short[] Small = new short[count];
        short[] Large = new short[count];
        int avail = 0;
        for (int i = 0; i < LenList.length; ++i) {
            int j;
            if (0 >= LenList[i]) continue;
            int TreeBits = LenList[i] - TableBits;
            if (TreeBits <= 0) {
                int start = CodeList[i] << TableBits - LenList[i];
                int end = i != LastCode ? start + (1 << TableBits - LenList[i]) : Table.length;
                for (j = start; j < end; ++j) {
                    Table[j] = (short)(~i);
                }
                continue;
            }
            int TableCode = CodeList[i] >> TreeBits;
            short node = Table[TableCode] == -1 ? (Table[TableCode] = (short)avail++) : Table[TableCode];
            for (j = TableBits + 1; j < LenList[i]; ++j) {
                if (0 == (CodeList[i] & 1 << LenList[i] - j)) {
                    if (Small[node] == 0) {
                        node = Small[node] = (short)avail++;
                        continue;
                    }
                    node = Small[node];
                    continue;
                }
                node = Large[node] == 0 ? (Large[node] = (short)avail++) : Large[node];
            }
            if (0 == (CodeList[i] & 1)) {
                Small[node] = (short)(~i);
                continue;
            }
            Large[node] = (short)(~i);
        }
        return new short[][]{Table, Small, Large};
    }

    private static void mergeSort(int[] array, int first, int last, int[] weight, int[] work) {
        if (first < last) {
            int middle = (first + last) / 2 + (first + last) % 2;
            StaticHuffman.mergeSort(array, first, middle - 1, weight, work);
            StaticHuffman.mergeSort(array, middle, last, weight, work);
            System.arraycopy(array, first, work, 0, middle - first);
            int srcIndex = middle;
            int workIndex = 0;
            int dstIndex = first;
            while (srcIndex <= last && workIndex < middle - first) {
                array[dstIndex++] = weight[work[workIndex]] < weight[array[srcIndex]] ? work[workIndex++] : array[srcIndex++];
            }
            if (workIndex < middle - first) {
                System.arraycopy(work, workIndex, array, dstIndex, middle - first - workIndex);
            }
        }
    }

    private static void downHeap(int[] heap, int size, int[] weight, int num) {
        int i;
        int top = heap[num];
        while ((i = 2 * num) <= size) {
            if (i < size && weight[heap[i]] > weight[heap[i + 1]]) {
                ++i;
            }
            if (weight[top] <= weight[heap[i]]) break;
            heap[num] = heap[i];
            num = i;
        }
        heap[num] = top;
    }

    private static int[] huffmanTreeToLenFreq(int[] SmallNode, int[] LargeNode, int root) {
        int i;
        int[] LenFreq = new int[17];
        StaticHuffman.internalHuffmanTreeToLenFreq(SmallNode, LargeNode, root, 0, LenFreq);
        int weight = 0;
        for (i = 16; 0 < i; --i) {
            weight += LenFreq[i] << 16 - i;
        }
        while (65536 < weight) {
            LenFreq[16] = LenFreq[16] - 1;
            for (i = 15; 0 < i; --i) {
                if (0 >= LenFreq[i]) continue;
                int n = i;
                LenFreq[n] = LenFreq[n] - 1;
                int n2 = i + 1;
                LenFreq[n2] = LenFreq[n2] + 2;
                break;
            }
            --weight;
        }
        return LenFreq;
    }

    private static void internalHuffmanTreeToLenFreq(int[] SmallNode, int[] LargeNode, int node, int len, int[] LenFreq) {
        if (node < (SmallNode.length + 1) / 2) {
            int n = len < 16 ? len : 16;
            LenFreq[n] = LenFreq[n] + 1;
        } else {
            StaticHuffman.internalHuffmanTreeToLenFreq(SmallNode, LargeNode, SmallNode[node], len + 1, LenFreq);
            StaticHuffman.internalHuffmanTreeToLenFreq(SmallNode, LargeNode, LargeNode[node], len + 1, LenFreq);
        }
    }
}

