package com.orbitz.consul.option;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Booleans;
import java.math.BigInteger;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link QueryOptions}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ImmutableQueryOptions.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "QueryOptions"})
public final class ImmutableQueryOptions extends QueryOptions {
  private final Optional<String> wait;
  private final Optional<String> token;
  private final Optional<BigInteger> index;
  private final Optional<String> near;
  private final ConsistencyMode consistencyMode;
  private final boolean isBlocking;
  private final boolean hasToken;

  private ImmutableQueryOptions(ImmutableQueryOptions.Builder builder) {
    this.wait = builder.wait;
    this.token = builder.token;
    this.index = builder.index;
    this.near = builder.near;
    this.consistencyMode = builder.consistencyMode != null
        ? builder.consistencyMode
        : Preconditions.checkNotNull(super.getConsistencyMode());
    this.isBlocking = super.isBlocking();
    this.hasToken = super.hasToken();
  }

  private ImmutableQueryOptions(
      Optional<String> wait,
      Optional<String> token,
      Optional<BigInteger> index,
      Optional<String> near,
      ConsistencyMode consistencyMode) {
    this.wait = wait;
    this.token = token;
    this.index = index;
    this.near = near;
    this.consistencyMode = consistencyMode;
    this.isBlocking = super.isBlocking();
    this.hasToken = super.hasToken();
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code wait} attribute
   */
  @Override
  public Optional<String> getWait() {
    return wait;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code token} attribute
   */
  @Override
  public Optional<String> getToken() {
    return token;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code index} attribute
   */
  @Override
  public Optional<BigInteger> getIndex() {
    return index;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code near} attribute
   */
  @Override
  public Optional<String> getNear() {
    return near;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code consistencyMode} attribute
   */
  @Override
  public ConsistencyMode getConsistencyMode() {
    return consistencyMode;
  }
  
  /**
   * {@inheritDoc}
   * @return computed at construction value of {@code isBlocking} attribute
   */
  @Override
  public boolean isBlocking() {
    return isBlocking;
  }
  
  /**
   * {@inheritDoc}
   * @return computed at construction value of {@code hasToken} attribute
   */
  @Override
  public boolean hasToken() {
    return hasToken;
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link QueryOptions#getWait() wait}.
   * @param value value for wait
   * @return modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withWait(String value) {
    Optional<String> newValue = Optional.of(value);
    return validate(new ImmutableQueryOptions(newValue, this.token, this.index, this.near, this.consistencyMode));
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link QueryOptions#getWait() wait}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for wait
   * @return modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withWait(Optional<String> optional) {
    if (this.wait == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return validate(new ImmutableQueryOptions(newValue, this.token, this.index, this.near, this.consistencyMode));
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link QueryOptions#getToken() token}.
   * @param value value for token
   * @return modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withToken(String value) {
    Optional<String> newValue = Optional.of(value);
    return validate(new ImmutableQueryOptions(this.wait, newValue, this.index, this.near, this.consistencyMode));
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link QueryOptions#getToken() token}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for token
   * @return modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withToken(Optional<String> optional) {
    if (this.token == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return validate(new ImmutableQueryOptions(this.wait, newValue, this.index, this.near, this.consistencyMode));
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link QueryOptions#getIndex() index}.
   * @param value value for index
   * @return modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withIndex(BigInteger value) {
    Optional<BigInteger> newValue = Optional.of(value);
    return validate(new ImmutableQueryOptions(this.wait, this.token, newValue, this.near, this.consistencyMode));
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link QueryOptions#getIndex() index}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for index
   * @return modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withIndex(Optional<BigInteger> optional) {
    if (this.index == optional) {
      return this;
    }
    Optional<BigInteger> newValue = Preconditions.checkNotNull(optional);
    return validate(new ImmutableQueryOptions(this.wait, this.token, newValue, this.near, this.consistencyMode));
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link QueryOptions#getNear() near}.
   * @param value value for near
   * @return modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withNear(String value) {
    Optional<String> newValue = Optional.of(value);
    return validate(new ImmutableQueryOptions(this.wait, this.token, this.index, newValue, this.consistencyMode));
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link QueryOptions#getNear() near}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for near
   * @return modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withNear(Optional<String> optional) {
    if (this.near == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return validate(new ImmutableQueryOptions(this.wait, this.token, this.index, newValue, this.consistencyMode));
  }
  
  /**
   * Copy current immutable object by setting value for {@link QueryOptions#getConsistencyMode() consistencyMode}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for consistencyMode
   * @return modified copy of the {@code this} object
   */
  public final ImmutableQueryOptions withConsistencyMode(ConsistencyMode value) {
    if (this.consistencyMode == value) {
      return this;
    }
    ConsistencyMode newValue = Preconditions.checkNotNull(value);
    return validate(new ImmutableQueryOptions(this.wait, this.token, this.index, this.near, newValue));
  }
  
  /**
   * This instance is equal to instances of {@code ImmutableQueryOptions} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    return this == another
        || (another instanceof ImmutableQueryOptions && equalTo((ImmutableQueryOptions) another));
  }
  
  private boolean equalTo(ImmutableQueryOptions another) {
    return wait.equals(another.wait)
        && token.equals(another.token)
        && index.equals(another.index)
        && near.equals(another.near)
        && consistencyMode.equals(another.consistencyMode)
        && isBlocking == another.isBlocking
        && hasToken == another.hasToken;
  }
  
  /**
   * Computes hash code from attributes: {@code wait}, {@code token}, {@code index}, {@code near}, {@code consistencyMode}, {@code isBlocking}, {@code hasToken}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + wait.hashCode();
    h = h * 17 + token.hashCode();
    h = h * 17 + index.hashCode();
    h = h * 17 + near.hashCode();
    h = h * 17 + consistencyMode.hashCode();
    h = h * 17 + Booleans.hashCode(isBlocking);
    h = h * 17 + Booleans.hashCode(hasToken);
    return h;
  }
  
  /**
   * Prints immutable value {@code QueryOptions{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("QueryOptions")
        .add("wait", wait)
        .add("token", token)
        .add("index", index)
        .add("near", near)
        .add("consistencyMode", consistencyMode)
        .add("isBlocking", isBlocking)
        .add("hasToken", hasToken)
        .toString();
  }

  private static ImmutableQueryOptions validate(ImmutableQueryOptions instance) {
    instance.validate();
    return instance;
  }
  
  /**
   * Creates immutable copy of {@link QueryOptions}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable QueryOptions instance
   */
  public static ImmutableQueryOptions copyOf(QueryOptions instance) {
    if (instance instanceof ImmutableQueryOptions) {
      return (ImmutableQueryOptions) instance;
    }
    return ImmutableQueryOptions.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link com.orbitz.consul.option.ImmutableQueryOptions}.
   * @return new ImmutableQueryOptions builder
   */
  public static ImmutableQueryOptions.Builder builder() {
    return new ImmutableQueryOptions.Builder();
  }
  
  /**
   * Builds instances of {@link com.orbitz.consul.option.ImmutableQueryOptions}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  public static final class Builder {
  
    private Optional<String> wait = Optional.absent();
    private Optional<String> token = Optional.absent();
    private Optional<BigInteger> index = Optional.absent();
    private Optional<String> near = Optional.absent();
    private ConsistencyMode consistencyMode;
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link QueryOptions} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(QueryOptions instance) {
      Preconditions.checkNotNull(instance);
      Optional<String> waitOptional = instance.getWait();
      if (waitOptional.isPresent()) {
        wait(waitOptional);
      }
      Optional<String> tokenOptional = instance.getToken();
      if (tokenOptional.isPresent()) {
        token(tokenOptional);
      }
      Optional<BigInteger> indexOptional = instance.getIndex();
      if (indexOptional.isPresent()) {
        index(indexOptional);
      }
      Optional<String> nearOptional = instance.getNear();
      if (nearOptional.isPresent()) {
        near(nearOptional);
      }
      consistencyMode(instance.getConsistencyMode());
      return this;
    }
  
    /**
     * Initializes present value for optional {@link QueryOptions#getWait() wait}.
     * @param wait value for wait
     * @return {@code this} builder for chained invocation
     */
    public final Builder wait(String wait) {
      this.wait = Optional.of(wait);
      return this;
    }
  
    /**
     * Initializes optional value for {@link QueryOptions#getWait() wait}.
     * @param wait value for wait
     * @return {@code this} builder for chained invocation
     */
    public final Builder wait(Optional<String> wait) {
      this.wait = Preconditions.checkNotNull(wait);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link QueryOptions#getToken() token}.
     * @param token value for token
     * @return {@code this} builder for chained invocation
     */
    public final Builder token(String token) {
      this.token = Optional.of(token);
      return this;
    }
  
    /**
     * Initializes optional value for {@link QueryOptions#getToken() token}.
     * @param token value for token
     * @return {@code this} builder for chained invocation
     */
    public final Builder token(Optional<String> token) {
      this.token = Preconditions.checkNotNull(token);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link QueryOptions#getIndex() index}.
     * @param index value for index
     * @return {@code this} builder for chained invocation
     */
    public final Builder index(BigInteger index) {
      this.index = Optional.of(index);
      return this;
    }
  
    /**
     * Initializes optional value for {@link QueryOptions#getIndex() index}.
     * @param index value for index
     * @return {@code this} builder for chained invocation
     */
    public final Builder index(Optional<BigInteger> index) {
      this.index = Preconditions.checkNotNull(index);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link QueryOptions#getNear() near}.
     * @param near value for near
     * @return {@code this} builder for chained invocation
     */
    public final Builder near(String near) {
      this.near = Optional.of(near);
      return this;
    }
  
    /**
     * Initializes optional value for {@link QueryOptions#getNear() near}.
     * @param near value for near
     * @return {@code this} builder for chained invocation
     */
    public final Builder near(Optional<String> near) {
      this.near = Preconditions.checkNotNull(near);
      return this;
    }
  
    /**
     * Initializes value for {@link QueryOptions#getConsistencyMode() consistencyMode}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link QueryOptions#getConsistencyMode() consistencyMode}.</em>
     * @param consistencyMode value for consistencyMode
     * @return {@code this} builder for chained invocation
     */
    public final Builder consistencyMode(ConsistencyMode consistencyMode) {
      this.consistencyMode = Preconditions.checkNotNull(consistencyMode);
      return this;
    }
  
    /**
     * Builds new {@link com.orbitz.consul.option.ImmutableQueryOptions}.
     * @return immutable instance of QueryOptions
     */
    public ImmutableQueryOptions build() {
      return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this));
    }
  }
}
