package com.orbitz.consul.option;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link PutOptions}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePutOptions.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "PutOptions"})
public final class ImmutablePutOptions extends PutOptions {
  private final Optional<Long> cas;
  private final Optional<String> acquire;
  private final Optional<String> release;
  private final Optional<String> dc;

  private ImmutablePutOptions(
      Optional<Long> cas,
      Optional<String> acquire,
      Optional<String> release,
      Optional<String> dc) {
    this.cas = cas;
    this.acquire = acquire;
    this.release = release;
    this.dc = dc;
  }

  /**
   * @return The value of the {@code cas} attribute
   */
  @Override
  public Optional<Long> getCas() {
    return cas;
  }

  /**
   * @return The value of the {@code acquire} attribute
   */
  @Override
  public Optional<String> getAcquire() {
    return acquire;
  }

  /**
   * @return The value of the {@code release} attribute
   */
  @Override
  public Optional<String> getRelease() {
    return release;
  }

  /**
   * @return The value of the {@code dc} attribute
   */
  @Override
  public Optional<String> getDc() {
    return dc;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PutOptions#getCas() cas} attribute.
   * @param value The value for cas
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePutOptions withCas(long value) {
    Optional<Long> newValue = Optional.of(value);
    return new ImmutablePutOptions(newValue, this.acquire, this.release, this.dc);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PutOptions#getCas() cas} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for cas
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePutOptions withCas(Optional<Long> optional) {
    Optional<Long> value = Preconditions.checkNotNull(optional, "cas");
    if (this.cas == value) return this;
    return new ImmutablePutOptions(value, this.acquire, this.release, this.dc);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PutOptions#getAcquire() acquire} attribute.
   * @param value The value for acquire
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePutOptions withAcquire(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutablePutOptions(this.cas, newValue, this.release, this.dc);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PutOptions#getAcquire() acquire} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for acquire
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePutOptions withAcquire(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "acquire");
    if (this.acquire == value) return this;
    return new ImmutablePutOptions(this.cas, value, this.release, this.dc);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PutOptions#getRelease() release} attribute.
   * @param value The value for release
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePutOptions withRelease(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutablePutOptions(this.cas, this.acquire, newValue, this.dc);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PutOptions#getRelease() release} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for release
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePutOptions withRelease(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "release");
    if (this.release == value) return this;
    return new ImmutablePutOptions(this.cas, this.acquire, value, this.dc);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PutOptions#getDc() dc} attribute.
   * @param value The value for dc
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePutOptions withDc(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutablePutOptions(this.cas, this.acquire, this.release, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PutOptions#getDc() dc} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for dc
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePutOptions withDc(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "dc");
    if (this.dc == value) return this;
    return new ImmutablePutOptions(this.cas, this.acquire, this.release, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePutOptions} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePutOptions
        && equalTo((ImmutablePutOptions) another);
  }

  private boolean equalTo(ImmutablePutOptions another) {
    return cas.equals(another.cas)
        && acquire.equals(another.acquire)
        && release.equals(another.release)
        && dc.equals(another.dc);
  }

  /**
   * Computes a hash code from attributes: {@code cas}, {@code acquire}, {@code release}, {@code dc}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + cas.hashCode();
    h = h * 17 + acquire.hashCode();
    h = h * 17 + release.hashCode();
    h = h * 17 + dc.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PutOptions...} with all non-generated
   * and non-auxiliary attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PutOptions")
        .add("cas", cas)
        .add("acquire", acquire)
        .add("release", release)
        .add("dc", dc)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link PutOptions} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PutOptions instance
   */
  public static ImmutablePutOptions copyOf(PutOptions instance) {
    if (instance instanceof ImmutablePutOptions) {
      return (ImmutablePutOptions) instance;
    }
    return ImmutablePutOptions.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePutOptions ImmutablePutOptions}.
   * @return A new ImmutablePutOptions builder
   */
  public static ImmutablePutOptions.Builder builder() {
    return new ImmutablePutOptions.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePutOptions ImmutablePutOptions}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Optional<Long> cas = Optional.absent();
    private Optional<String> acquire = Optional.absent();
    private Optional<String> release = Optional.absent();
    private Optional<String> dc = Optional.absent();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PutOptions} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PutOptions instance) {
      Preconditions.checkNotNull(instance, "instance");
      Optional<Long> casOptional = instance.getCas();
      if (casOptional.isPresent()) {
        cas(casOptional);
      }
      Optional<String> acquireOptional = instance.getAcquire();
      if (acquireOptional.isPresent()) {
        acquire(acquireOptional);
      }
      Optional<String> releaseOptional = instance.getRelease();
      if (releaseOptional.isPresent()) {
        release(releaseOptional);
      }
      Optional<String> dcOptional = instance.getDc();
      if (dcOptional.isPresent()) {
        dc(dcOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link PutOptions#getCas() cas} to cas.
     * @param cas The value for cas
     * @return {@code this} builder for chained invocation
     */
    public final Builder cas(long cas) {
      this.cas = Optional.of(cas);
      return this;
    }

    /**
     * Initializes the optional value {@link PutOptions#getCas() cas} to cas.
     * @param cas The value for cas
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder cas(Optional<Long> cas) {
      this.cas = Preconditions.checkNotNull(cas, "cas");
      return this;
    }

    /**
     * Initializes the optional value {@link PutOptions#getAcquire() acquire} to acquire.
     * @param acquire The value for acquire
     * @return {@code this} builder for chained invocation
     */
    public final Builder acquire(String acquire) {
      this.acquire = Optional.of(acquire);
      return this;
    }

    /**
     * Initializes the optional value {@link PutOptions#getAcquire() acquire} to acquire.
     * @param acquire The value for acquire
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder acquire(Optional<String> acquire) {
      this.acquire = Preconditions.checkNotNull(acquire, "acquire");
      return this;
    }

    /**
     * Initializes the optional value {@link PutOptions#getRelease() release} to release.
     * @param release The value for release
     * @return {@code this} builder for chained invocation
     */
    public final Builder release(String release) {
      this.release = Optional.of(release);
      return this;
    }

    /**
     * Initializes the optional value {@link PutOptions#getRelease() release} to release.
     * @param release The value for release
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder release(Optional<String> release) {
      this.release = Preconditions.checkNotNull(release, "release");
      return this;
    }

    /**
     * Initializes the optional value {@link PutOptions#getDc() dc} to dc.
     * @param dc The value for dc
     * @return {@code this} builder for chained invocation
     */
    public final Builder dc(String dc) {
      this.dc = Optional.of(dc);
      return this;
    }

    /**
     * Initializes the optional value {@link PutOptions#getDc() dc} to dc.
     * @param dc The value for dc
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dc(Optional<String> dc) {
      this.dc = Preconditions.checkNotNull(dc, "dc");
      return this;
    }

    /**
     * Builds a new {@link ImmutablePutOptions ImmutablePutOptions}.
     * @return An immutable instance of PutOptions
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePutOptions build() throws IllegalStateException {
      return new ImmutablePutOptions(cas, acquire, release, dc);
    }
  }
}
