package com.orbitz.consul.model.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link QueryId}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableQueryId.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "QueryId"})
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableQueryId extends QueryId {
  private final String id;

  private ImmutableQueryId(String id) {
    this.id = id;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty(value = "ID")
  @Override
  public String getId() {
    return id;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QueryId#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQueryId withId(String value) {
    if (this.id.equals(value)) return this;
    return new ImmutableQueryId(Preconditions.checkNotNull(value, "id"));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableQueryId} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableQueryId
        && equalTo((ImmutableQueryId) another);
  }

  private boolean equalTo(ImmutableQueryId another) {
    return id.equals(another.id);
  }

  /**
   * Computes a hash code from attributes: {@code id}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + id.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code QueryId...} with all non-generated
   * and non-auxiliary attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("QueryId")
        .add("id", id)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends QueryId {
    String id;
    @JsonProperty(value = "ID")
    public void setId(String id) {
      this.id = id;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableQueryId fromJson(Json json) {
    ImmutableQueryId.Builder builder = ImmutableQueryId.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link QueryId} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable QueryId instance
   */
  public static ImmutableQueryId copyOf(QueryId instance) {
    if (instance instanceof ImmutableQueryId) {
      return (ImmutableQueryId) instance;
    }
    return ImmutableQueryId.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableQueryId ImmutableQueryId}.
   * @return A new ImmutableQueryId builder
   */
  public static ImmutableQueryId.Builder builder() {
    return new ImmutableQueryId.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableQueryId ImmutableQueryId}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private long initBits = 0x1;

    private String id;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code QueryId} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(QueryId instance) {
      Preconditions.checkNotNull(instance, "instance");
      id(instance.getId());
      return this;
    }

    /**
     * Initializes the value for the {@link QueryId#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Preconditions.checkNotNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableQueryId ImmutableQueryId}.
     * @return An immutable instance of QueryId
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableQueryId build() throws IllegalStateException {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableQueryId(id);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build QueryId, some of required attributes are not set " + attributes;
    }
  }
}
