package com.orbitz.consul.model.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.health.ServiceHealth;
import java.util.List;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link QueryResults}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableQueryResults.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "QueryResults"})
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableQueryResults extends QueryResults {
  private final String service;
  private final ImmutableList<ServiceHealth> nodes;

  private ImmutableQueryResults(
      String service,
      ImmutableList<ServiceHealth> nodes) {
    this.service = service;
    this.nodes = nodes;
  }

  /**
   * @return The value of the {@code service} attribute
   */
  @JsonProperty(value = "Service")
  @Override
  public String service() {
    return service;
  }

  /**
   * @return The value of the {@code nodes} attribute
   */
  @JsonProperty(value = "Nodes")
  @Override
  public ImmutableList<ServiceHealth> nodes() {
    return nodes;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QueryResults#service() service} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for service
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQueryResults withService(String value) {
    if (this.service.equals(value)) return this;
    return new ImmutableQueryResults(Preconditions.checkNotNull(value, "service"), this.nodes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link QueryResults#nodes() nodes}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryResults withNodes(ServiceHealth... elements) {
    ImmutableList<ServiceHealth> newValue = ImmutableList.copyOf(elements);
    return new ImmutableQueryResults(this.service, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link QueryResults#nodes() nodes}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of nodes elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryResults withNodes(Iterable<? extends ServiceHealth> elements) {
    if (this.nodes == elements) return this;
    ImmutableList<ServiceHealth> newValue = ImmutableList.copyOf(elements);
    return new ImmutableQueryResults(this.service, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableQueryResults} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableQueryResults
        && equalTo((ImmutableQueryResults) another);
  }

  private boolean equalTo(ImmutableQueryResults another) {
    return service.equals(another.service)
        && nodes.equals(another.nodes);
  }

  /**
   * Computes a hash code from attributes: {@code service}, {@code nodes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + service.hashCode();
    h = h * 17 + nodes.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code QueryResults...} with all non-generated
   * and non-auxiliary attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("QueryResults")
        .add("service", service)
        .add("nodes", nodes)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends QueryResults {
    String service;
    List<ServiceHealth> nodes = ImmutableList.of();
    @JsonProperty(value = "Service")
    public void setService(String service) {
      this.service = service;
    }
    @JsonProperty(value = "Nodes")
    public void setNodes(List<ServiceHealth> nodes) {
      this.nodes = nodes;
    }
    @Override
    public String service() { throw new UnsupportedOperationException(); }
    @Override
    public List<ServiceHealth> nodes() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableQueryResults fromJson(Json json) {
    ImmutableQueryResults.Builder builder = ImmutableQueryResults.builder();
    if (json.service != null) {
      builder.service(json.service);
    }
    if (json.nodes != null) {
      builder.addAllNodes(json.nodes);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link QueryResults} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable QueryResults instance
   */
  public static ImmutableQueryResults copyOf(QueryResults instance) {
    if (instance instanceof ImmutableQueryResults) {
      return (ImmutableQueryResults) instance;
    }
    return ImmutableQueryResults.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableQueryResults ImmutableQueryResults}.
   * @return A new ImmutableQueryResults builder
   */
  public static ImmutableQueryResults.Builder builder() {
    return new ImmutableQueryResults.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableQueryResults ImmutableQueryResults}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SERVICE = 0x1L;
    private long initBits = 0x1;

    private String service;
    private ImmutableList.Builder<ServiceHealth> nodesBuilder = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code QueryResults} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(QueryResults instance) {
      Preconditions.checkNotNull(instance, "instance");
      service(instance.service());
      addAllNodes(instance.nodes());
      return this;
    }

    /**
     * Initializes the value for the {@link QueryResults#service() service} attribute.
     * @param service The value for service 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder service(String service) {
      this.service = Preconditions.checkNotNull(service, "service");
      initBits &= ~INIT_BIT_SERVICE;
      return this;
    }

    /**
     * Adds one element to {@link QueryResults#nodes() nodes} list.
     * @param element A nodes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addNodes(ServiceHealth element) {
      nodesBuilder.add(element);
      return this;
    }

    /**
     * Adds elements to {@link QueryResults#nodes() nodes} list.
     * @param elements An array of nodes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addNodes(ServiceHealth... elements) {
      nodesBuilder.add(elements);
      return this;
    }

    /**
     * Sets or replaces all elements for {@link QueryResults#nodes() nodes} list.
     * @param elements An iterable of nodes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder nodes(Iterable<? extends ServiceHealth> elements) {
      nodesBuilder = ImmutableList.builder();
      return addAllNodes(elements);
    }

    /**
     * Adds elements to {@link QueryResults#nodes() nodes} list.
     * @param elements An iterable of nodes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllNodes(Iterable<? extends ServiceHealth> elements) {
      nodesBuilder.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableQueryResults ImmutableQueryResults}.
     * @return An immutable instance of QueryResults
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableQueryResults build() throws IllegalStateException {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableQueryResults(service, nodesBuilder.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_SERVICE) != 0) attributes.add("service");
      return "Cannot build QueryResults, some of required attributes are not set " + attributes;
    }
  }
}
