package com.orbitz.consul.model.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link StoredQuery}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStoredQuery.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "StoredQuery"})
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableStoredQuery extends StoredQuery {
  private final String id;
  private final String name;
  private final String session;
  private final String token;
  private final ServiceQuery service;
  private final DnsQuery dns;

  private ImmutableStoredQuery(
      String id,
      String name,
      String session,
      String token,
      ServiceQuery service,
      DnsQuery dns) {
    this.id = id;
    this.name = name;
    this.session = session;
    this.token = token;
    this.service = service;
    this.dns = dns;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty(value = "ID")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty(value = "Name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code session} attribute
   */
  @JsonProperty(value = "Session")
  @Override
  public String getSession() {
    return session;
  }

  /**
   * @return The value of the {@code token} attribute
   */
  @JsonProperty(value = "Token")
  @Override
  public String getToken() {
    return token;
  }

  /**
   * @return The value of the {@code service} attribute
   */
  @JsonProperty(value = "Service")
  @Override
  public ServiceQuery getService() {
    return service;
  }

  /**
   * @return The value of the {@code dns} attribute
   */
  @JsonProperty(value = "DNS")
  @Override
  public DnsQuery getDns() {
    return dns;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StoredQuery#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStoredQuery withId(String value) {
    if (this.id.equals(value)) return this;
    return new ImmutableStoredQuery(
        Preconditions.checkNotNull(value, "id"),
        this.name,
        this.session,
        this.token,
        this.service,
        this.dns);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StoredQuery#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStoredQuery withName(String value) {
    if (this.name.equals(value)) return this;
    return new ImmutableStoredQuery(
        this.id,
        Preconditions.checkNotNull(value, "name"),
        this.session,
        this.token,
        this.service,
        this.dns);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StoredQuery#getSession() session} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for session
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStoredQuery withSession(String value) {
    if (this.session.equals(value)) return this;
    return new ImmutableStoredQuery(
        this.id,
        this.name,
        Preconditions.checkNotNull(value, "session"),
        this.token,
        this.service,
        this.dns);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StoredQuery#getToken() token} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for token
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStoredQuery withToken(String value) {
    if (this.token.equals(value)) return this;
    return new ImmutableStoredQuery(
        this.id,
        this.name,
        this.session,
        Preconditions.checkNotNull(value, "token"),
        this.service,
        this.dns);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StoredQuery#getService() service} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for service
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStoredQuery withService(ServiceQuery value) {
    if (this.service == value) return this;
    return new ImmutableStoredQuery(
        this.id,
        this.name,
        this.session,
        this.token,
        Preconditions.checkNotNull(value, "service"),
        this.dns);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StoredQuery#getDns() dns} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dns
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStoredQuery withDns(DnsQuery value) {
    if (this.dns == value) return this;
    return new ImmutableStoredQuery(
        this.id,
        this.name,
        this.session,
        this.token,
        this.service,
        Preconditions.checkNotNull(value, "dns"));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStoredQuery} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStoredQuery
        && equalTo((ImmutableStoredQuery) another);
  }

  private boolean equalTo(ImmutableStoredQuery another) {
    return id.equals(another.id)
        && name.equals(another.name)
        && session.equals(another.session)
        && token.equals(another.token)
        && service.equals(another.service)
        && dns.equals(another.dns);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code session}, {@code token}, {@code service}, {@code dns}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + id.hashCode();
    h = h * 17 + name.hashCode();
    h = h * 17 + session.hashCode();
    h = h * 17 + token.hashCode();
    h = h * 17 + service.hashCode();
    h = h * 17 + dns.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code StoredQuery...} with all non-generated
   * and non-auxiliary attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("StoredQuery")
        .add("id", id)
        .add("name", name)
        .add("session", session)
        .add("token", token)
        .add("service", service)
        .add("dns", dns)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends StoredQuery {
    String id;
    String name;
    String session;
    String token;
    ServiceQuery service;
    DnsQuery dns;
    @JsonProperty(value = "ID")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty(value = "Name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty(value = "Session")
    public void setSession(String session) {
      this.session = session;
    }
    @JsonProperty(value = "Token")
    public void setToken(String token) {
      this.token = token;
    }
    @JsonProperty(value = "Service")
    public void setService(ServiceQuery service) {
      this.service = service;
    }
    @JsonProperty(value = "DNS")
    public void setDns(DnsQuery dns) {
      this.dns = dns;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getSession() { throw new UnsupportedOperationException(); }
    @Override
    public String getToken() { throw new UnsupportedOperationException(); }
    @Override
    public ServiceQuery getService() { throw new UnsupportedOperationException(); }
    @Override
    public DnsQuery getDns() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableStoredQuery fromJson(Json json) {
    ImmutableStoredQuery.Builder builder = ImmutableStoredQuery.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.session != null) {
      builder.session(json.session);
    }
    if (json.token != null) {
      builder.token(json.token);
    }
    if (json.service != null) {
      builder.service(json.service);
    }
    if (json.dns != null) {
      builder.dns(json.dns);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link StoredQuery} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StoredQuery instance
   */
  public static ImmutableStoredQuery copyOf(StoredQuery instance) {
    if (instance instanceof ImmutableStoredQuery) {
      return (ImmutableStoredQuery) instance;
    }
    return ImmutableStoredQuery.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStoredQuery ImmutableStoredQuery}.
   * @return A new ImmutableStoredQuery builder
   */
  public static ImmutableStoredQuery.Builder builder() {
    return new ImmutableStoredQuery.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableStoredQuery ImmutableStoredQuery}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_SESSION = 0x4L;
    private static final long INIT_BIT_TOKEN = 0x8L;
    private static final long INIT_BIT_SERVICE = 0x10L;
    private static final long INIT_BIT_DNS = 0x20L;
    private long initBits = 0x3f;

    private String id;
    private String name;
    private String session;
    private String token;
    private ServiceQuery service;
    private DnsQuery dns;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code StoredQuery} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(StoredQuery instance) {
      Preconditions.checkNotNull(instance, "instance");
      id(instance.getId());
      name(instance.getName());
      session(instance.getSession());
      token(instance.getToken());
      service(instance.getService());
      dns(instance.getDns());
      return this;
    }

    /**
     * Initializes the value for the {@link StoredQuery#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Preconditions.checkNotNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link StoredQuery#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Preconditions.checkNotNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link StoredQuery#getSession() session} attribute.
     * @param session The value for session 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder session(String session) {
      this.session = Preconditions.checkNotNull(session, "session");
      initBits &= ~INIT_BIT_SESSION;
      return this;
    }

    /**
     * Initializes the value for the {@link StoredQuery#getToken() token} attribute.
     * @param token The value for token 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder token(String token) {
      this.token = Preconditions.checkNotNull(token, "token");
      initBits &= ~INIT_BIT_TOKEN;
      return this;
    }

    /**
     * Initializes the value for the {@link StoredQuery#getService() service} attribute.
     * @param service The value for service 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder service(ServiceQuery service) {
      this.service = Preconditions.checkNotNull(service, "service");
      initBits &= ~INIT_BIT_SERVICE;
      return this;
    }

    /**
     * Initializes the value for the {@link StoredQuery#getDns() dns} attribute.
     * @param dns The value for dns 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dns(DnsQuery dns) {
      this.dns = Preconditions.checkNotNull(dns, "dns");
      initBits &= ~INIT_BIT_DNS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableStoredQuery ImmutableStoredQuery}.
     * @return An immutable instance of StoredQuery
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStoredQuery build() throws IllegalStateException {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableStoredQuery(id, name, session, token, service, dns);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_SESSION) != 0) attributes.add("session");
      if ((initBits & INIT_BIT_TOKEN) != 0) attributes.add("token");
      if ((initBits & INIT_BIT_SERVICE) != 0) attributes.add("service");
      if ((initBits & INIT_BIT_DNS) != 0) attributes.add("dns");
      return "Cannot build StoredQuery, some of required attributes are not set " + attributes;
    }
  }
}
