/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul;

import com.orbitz.apache.commons.lang3.StringUtils;
import com.orbitz.consul.ConsulException;
import com.orbitz.consul.async.EventResponseCallback;
import com.orbitz.consul.model.EventResponse;
import com.orbitz.consul.model.ImmutableEventResponse;
import com.orbitz.consul.model.event.Event;
import com.orbitz.consul.option.EventOptions;
import com.orbitz.consul.option.QueryOptions;
import com.orbitz.consul.util.Http;
import com.orbitz.google.common.collect.ImmutableMap;
import com.orbitz.retrofit.Call;
import com.orbitz.retrofit.Callback;
import com.orbitz.retrofit.Response;
import com.orbitz.retrofit.Retrofit;
import com.orbitz.retrofit.http.Body;
import com.orbitz.retrofit.http.GET;
import com.orbitz.retrofit.http.PUT;
import com.orbitz.retrofit.http.Path;
import com.orbitz.retrofit.http.QueryMap;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class EventClient {
    private final Api api;

    EventClient(Retrofit retrofit) {
        this.api = retrofit.create(Api.class);
    }

    public Event fireEvent(String name, EventOptions eventOptions, String payload) {
        return Http.extract(this.api.fireEvent(name, payload, eventOptions.toQuery()));
    }

    public Event fireEvent(String name) {
        return this.fireEvent(name, EventOptions.BLANK);
    }

    public Event fireEvent(String name, EventOptions eventOptions) {
        return Http.extract(this.api.fireEvent(name, eventOptions.toQuery()));
    }

    public Event fireEvent(String name, String payload) {
        return this.fireEvent(name, EventOptions.BLANK, payload);
    }

    public EventResponse listEvents(String name, QueryOptions queryOptions) {
        Map<String, String> query = Collections.emptyMap();
        if (StringUtils.isNotEmpty(name)) {
            query = ImmutableMap.of("name", name);
        }
        return EventClient.response(this.api.listEvents(query));
    }

    public EventResponse listEvents(String name) {
        return this.listEvents(name, QueryOptions.BLANK);
    }

    public EventResponse listEvents(QueryOptions queryOptions) {
        return this.listEvents(null, queryOptions);
    }

    public EventResponse listEvents() {
        return this.listEvents(null, QueryOptions.BLANK);
    }

    public void listEvents(String name, QueryOptions queryOptions, EventResponseCallback callback) {
        Map<String, String> query = Collections.emptyMap();
        if (StringUtils.isNotEmpty(name)) {
            query = ImmutableMap.of("name", name);
        }
        EventClient.response(this.api.listEvents(query), callback);
    }

    public void listEvents(QueryOptions queryOptions, EventResponseCallback callback) {
        this.listEvents(null, queryOptions, callback);
    }

    public void listEvents(EventResponseCallback callback) {
        this.listEvents(null, QueryOptions.BLANK, callback);
    }

    private static void response(Call<List<Event>> call, final EventResponseCallback callback) {
        call.enqueue(new Callback<List<Event>>(){

            @Override
            public void onResponse(Call<List<Event>> call, Response<List<Event>> response) {
                try {
                    callback.onComplete(EventClient.eventResponse(response));
                }
                catch (Exception ex) {
                    callback.onFailure(ex);
                }
            }

            @Override
            public void onFailure(Call<List<Event>> call, Throwable t) {
                callback.onFailure(t);
            }
        });
    }

    private static EventResponse response(Call<List<Event>> call) {
        Response<List<Event>> response;
        try {
            response = call.execute();
        }
        catch (IOException e) {
            throw new ConsulException(e);
        }
        if (!response.isSuccessful()) {
            throw new ConsulException(response.code(), response);
        }
        return EventClient.eventResponse(response);
    }

    private static EventResponse eventResponse(Response<List<Event>> response) {
        String indexHeaderValue = response.headers().get("X-Consul-Index");
        BigInteger index = new BigInteger(indexHeaderValue);
        return ImmutableEventResponse.of(response.body(), index);
    }

    static interface Api {
        @PUT(value="event/fire/{name}")
        public Call<Event> fireEvent(@Path(value="name") String var1, @Body String var2, @QueryMap Map<String, Object> var3);

        @PUT(value="event/fire/{name}")
        public Call<Event> fireEvent(@Path(value="name") String var1, @QueryMap Map<String, Object> var2);

        @GET(value="event/list")
        public Call<List<Event>> listEvents(@QueryMap Map<String, String> var1);
    }
}

