/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.cache;

import com.orbitz.consul.HealthClient;
import com.orbitz.consul.async.ConsulResponseCallback;
import com.orbitz.consul.cache.ConsulCache;
import com.orbitz.consul.cache.ServiceHealthKey;
import com.orbitz.consul.model.health.ServiceHealth;
import com.orbitz.consul.option.CatalogOptions;
import com.orbitz.google.common.base.Function;
import java.math.BigInteger;
import java.util.List;

public class ServiceHealthCache
extends ConsulCache<ServiceHealthKey, ServiceHealth> {
    private ServiceHealthCache(Function<ServiceHealth, ServiceHealthKey> keyConversion, ConsulCache.CallbackConsumer<ServiceHealth> callbackConsumer) {
        super(keyConversion, callbackConsumer);
    }

    public static ServiceHealthCache newCache(final HealthClient healthClient, final String serviceName, final boolean passing, final CatalogOptions catalogOptions, final int watchSeconds) {
        Function<ServiceHealth, ServiceHealthKey> keyExtractor = new Function<ServiceHealth, ServiceHealthKey>(){

            @Override
            public ServiceHealthKey apply(ServiceHealth input) {
                return ServiceHealthKey.fromServiceHealth(input);
            }
        };
        ConsulCache.CallbackConsumer<ServiceHealth> callbackConsumer = new ConsulCache.CallbackConsumer<ServiceHealth>(){

            @Override
            public void consume(BigInteger index, ConsulResponseCallback<List<ServiceHealth>> callback) {
                if (passing) {
                    healthClient.getHealthyServiceInstances(serviceName, catalogOptions, ConsulCache.watchParams(index, watchSeconds), callback);
                } else {
                    healthClient.getAllServiceInstances(serviceName, catalogOptions, ConsulCache.watchParams(index, watchSeconds), callback);
                }
            }
        };
        return new ServiceHealthCache(keyExtractor, callbackConsumer);
    }

    public static ServiceHealthCache newCache(HealthClient healthClient, String serviceName) {
        return ServiceHealthCache.newCache(healthClient, serviceName, true, CatalogOptions.BLANK, 10);
    }
}

