/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.health;

import com.orbitz.consul.model.health.HealthCheck;
import com.orbitz.fasterxml.jackson.annotation.JsonCreator;
import com.orbitz.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.orbitz.fasterxml.jackson.annotation.JsonProperty;
import com.orbitz.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.orbitz.google.common.base.MoreObjects;
import com.orbitz.google.common.base.Optional;
import com.orbitz.google.common.base.Preconditions;
import com.orbitz.google.common.collect.Lists;
import java.util.ArrayList;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class ImmutableHealthCheck
extends HealthCheck {
    private final String node;
    private final String checkId;
    private final String name;
    private final String status;
    private final Optional<String> notes;
    private final Optional<String> output;
    private final Optional<String> serviceId;
    private final Optional<String> serviceName;

    private ImmutableHealthCheck(String node, String checkId, String name, String status, Optional<String> notes, Optional<String> output, Optional<String> serviceId, Optional<String> serviceName) {
        this.node = node;
        this.checkId = checkId;
        this.name = name;
        this.status = status;
        this.notes = notes;
        this.output = output;
        this.serviceId = serviceId;
        this.serviceName = serviceName;
    }

    @Override
    @JsonProperty(value="Node")
    public String getNode() {
        return this.node;
    }

    @Override
    @JsonProperty(value="CheckID")
    public String getCheckId() {
        return this.checkId;
    }

    @Override
    @JsonProperty(value="Name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Status")
    public String getStatus() {
        return this.status;
    }

    @Override
    @JsonProperty(value="Notes")
    public Optional<String> getNotes() {
        return this.notes;
    }

    @Override
    @JsonProperty(value="Output")
    public Optional<String> getOutput() {
        return this.output;
    }

    @Override
    @JsonProperty(value="ServiceID")
    public Optional<String> getServiceId() {
        return this.serviceId;
    }

    @Override
    @JsonProperty(value="ServiceName")
    public Optional<String> getServiceName() {
        return this.serviceName;
    }

    public final ImmutableHealthCheck withNode(String value) {
        if (this.node.equals(value)) {
            return this;
        }
        return new ImmutableHealthCheck(Preconditions.checkNotNull(value, "node"), this.checkId, this.name, this.status, this.notes, this.output, this.serviceId, this.serviceName);
    }

    public final ImmutableHealthCheck withCheckId(String value) {
        if (this.checkId.equals(value)) {
            return this;
        }
        return new ImmutableHealthCheck(this.node, Preconditions.checkNotNull(value, "checkId"), this.name, this.status, this.notes, this.output, this.serviceId, this.serviceName);
    }

    public final ImmutableHealthCheck withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        return new ImmutableHealthCheck(this.node, this.checkId, Preconditions.checkNotNull(value, "name"), this.status, this.notes, this.output, this.serviceId, this.serviceName);
    }

    public final ImmutableHealthCheck withStatus(String value) {
        if (this.status.equals(value)) {
            return this;
        }
        return new ImmutableHealthCheck(this.node, this.checkId, this.name, Preconditions.checkNotNull(value, "status"), this.notes, this.output, this.serviceId, this.serviceName);
    }

    public final ImmutableHealthCheck withNotes(String value) {
        Optional<String> newValue = Optional.of(value);
        return new ImmutableHealthCheck(this.node, this.checkId, this.name, this.status, newValue, this.output, this.serviceId, this.serviceName);
    }

    public final ImmutableHealthCheck withNotes(Optional<String> optional) {
        Optional<String> value = Preconditions.checkNotNull(optional, "notes");
        if (this.notes == value) {
            return this;
        }
        return new ImmutableHealthCheck(this.node, this.checkId, this.name, this.status, value, this.output, this.serviceId, this.serviceName);
    }

    public final ImmutableHealthCheck withOutput(String value) {
        Optional<String> newValue = Optional.of(value);
        return new ImmutableHealthCheck(this.node, this.checkId, this.name, this.status, this.notes, newValue, this.serviceId, this.serviceName);
    }

    public final ImmutableHealthCheck withOutput(Optional<String> optional) {
        Optional<String> value = Preconditions.checkNotNull(optional, "output");
        if (this.output == value) {
            return this;
        }
        return new ImmutableHealthCheck(this.node, this.checkId, this.name, this.status, this.notes, value, this.serviceId, this.serviceName);
    }

    public final ImmutableHealthCheck withServiceId(String value) {
        Optional<String> newValue = Optional.of(value);
        return new ImmutableHealthCheck(this.node, this.checkId, this.name, this.status, this.notes, this.output, newValue, this.serviceName);
    }

    public final ImmutableHealthCheck withServiceId(Optional<String> optional) {
        Optional<String> value = Preconditions.checkNotNull(optional, "serviceId");
        if (this.serviceId == value) {
            return this;
        }
        return new ImmutableHealthCheck(this.node, this.checkId, this.name, this.status, this.notes, this.output, value, this.serviceName);
    }

    public final ImmutableHealthCheck withServiceName(String value) {
        Optional<String> newValue = Optional.of(value);
        return new ImmutableHealthCheck(this.node, this.checkId, this.name, this.status, this.notes, this.output, this.serviceId, newValue);
    }

    public final ImmutableHealthCheck withServiceName(Optional<String> optional) {
        Optional<String> value = Preconditions.checkNotNull(optional, "serviceName");
        if (this.serviceName == value) {
            return this;
        }
        return new ImmutableHealthCheck(this.node, this.checkId, this.name, this.status, this.notes, this.output, this.serviceId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHealthCheck && this.equalTo((ImmutableHealthCheck)another);
    }

    private boolean equalTo(ImmutableHealthCheck another) {
        return this.node.equals(another.node) && this.checkId.equals(another.checkId) && this.name.equals(another.name) && this.status.equals(another.status) && this.notes.equals(another.notes) && this.output.equals(another.output) && this.serviceId.equals(another.serviceId) && this.serviceName.equals(another.serviceName);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.node.hashCode();
        h = h * 17 + this.checkId.hashCode();
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.status.hashCode();
        h = h * 17 + this.notes.hashCode();
        h = h * 17 + this.output.hashCode();
        h = h * 17 + this.serviceId.hashCode();
        h = h * 17 + this.serviceName.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("HealthCheck").add("node", this.node).add("checkId", this.checkId).add("name", this.name).add("status", this.status).add("notes", this.notes).add("output", this.output).add("serviceId", this.serviceId).add("serviceName", this.serviceName).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableHealthCheck fromJson(Json json) {
        Builder builder = ImmutableHealthCheck.builder();
        if (json.node != null) {
            builder.node(json.node);
        }
        if (json.checkId != null) {
            builder.checkId(json.checkId);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.notes != null) {
            builder.notes(json.notes);
        }
        if (json.output != null) {
            builder.output(json.output);
        }
        if (json.serviceId != null) {
            builder.serviceId(json.serviceId);
        }
        if (json.serviceName != null) {
            builder.serviceName(json.serviceName);
        }
        return builder.build();
    }

    public static ImmutableHealthCheck copyOf(HealthCheck instance) {
        if (instance instanceof ImmutableHealthCheck) {
            return (ImmutableHealthCheck)instance;
        }
        return ImmutableHealthCheck.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NODE = 1L;
        private static final long INIT_BIT_CHECK_ID = 2L;
        private static final long INIT_BIT_NAME = 4L;
        private static final long INIT_BIT_STATUS = 8L;
        private long initBits = 15L;
        private String node;
        private String checkId;
        private String name;
        private String status;
        private Optional<String> notes = Optional.absent();
        private Optional<String> output = Optional.absent();
        private Optional<String> serviceId = Optional.absent();
        private Optional<String> serviceName = Optional.absent();

        private Builder() {
        }

        public final Builder from(HealthCheck instance) {
            Optional<String> serviceNameOptional;
            Optional<String> serviceIdOptional;
            Optional<String> outputOptional;
            Preconditions.checkNotNull(instance, "instance");
            this.node(instance.getNode());
            this.checkId(instance.getCheckId());
            this.name(instance.getName());
            this.status(instance.getStatus());
            Optional<String> notesOptional = instance.getNotes();
            if (notesOptional.isPresent()) {
                this.notes(notesOptional);
            }
            if ((outputOptional = instance.getOutput()).isPresent()) {
                this.output(outputOptional);
            }
            if ((serviceIdOptional = instance.getServiceId()).isPresent()) {
                this.serviceId(serviceIdOptional);
            }
            if ((serviceNameOptional = instance.getServiceName()).isPresent()) {
                this.serviceName(serviceNameOptional);
            }
            return this;
        }

        public final Builder node(String node) {
            this.node = Preconditions.checkNotNull(node, "node");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder checkId(String checkId) {
            this.checkId = Preconditions.checkNotNull(checkId, "checkId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Preconditions.checkNotNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder status(String status) {
            this.status = Preconditions.checkNotNull(status, "status");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder notes(String notes) {
            this.notes = Optional.of(notes);
            return this;
        }

        public final Builder notes(Optional<String> notes) {
            this.notes = Preconditions.checkNotNull(notes, "notes");
            return this;
        }

        public final Builder output(String output) {
            this.output = Optional.of(output);
            return this;
        }

        public final Builder output(Optional<String> output) {
            this.output = Preconditions.checkNotNull(output, "output");
            return this;
        }

        public final Builder serviceId(String serviceId) {
            this.serviceId = Optional.of(serviceId);
            return this;
        }

        public final Builder serviceId(Optional<String> serviceId) {
            this.serviceId = Preconditions.checkNotNull(serviceId, "serviceId");
            return this;
        }

        public final Builder serviceName(String serviceName) {
            this.serviceName = Optional.of(serviceName);
            return this;
        }

        public final Builder serviceName(Optional<String> serviceName) {
            this.serviceName = Preconditions.checkNotNull(serviceName, "serviceName");
            return this;
        }

        public ImmutableHealthCheck build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableHealthCheck(this.node, this.checkId, this.name, this.status, this.notes, this.output, this.serviceId, this.serviceName);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("node");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("checkId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("status");
            }
            return "Cannot build HealthCheck, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends HealthCheck {
        String node;
        String checkId;
        String name;
        String status;
        Optional<String> notes = Optional.absent();
        Optional<String> output = Optional.absent();
        Optional<String> serviceId = Optional.absent();
        Optional<String> serviceName = Optional.absent();

        Json() {
        }

        @JsonProperty(value="Node")
        public void setNode(String node) {
            this.node = node;
        }

        @JsonProperty(value="CheckID")
        public void setCheckId(String checkId) {
            this.checkId = checkId;
        }

        @JsonProperty(value="Name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="Status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="Notes")
        public void setNotes(Optional<String> notes) {
            this.notes = notes;
        }

        @JsonProperty(value="Output")
        public void setOutput(Optional<String> output) {
            this.output = output;
        }

        @JsonProperty(value="ServiceID")
        public void setServiceId(Optional<String> serviceId) {
            this.serviceId = serviceId;
        }

        @JsonProperty(value="ServiceName")
        public void setServiceName(Optional<String> serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public String getNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCheckId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getStatus() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getNotes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getOutput() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getServiceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getServiceName() {
            throw new UnsupportedOperationException();
        }
    }
}

