/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.health;

import com.orbitz.consul.model.health.HealthCheck;
import com.orbitz.consul.model.health.Node;
import com.orbitz.consul.model.health.Service;
import com.orbitz.consul.model.health.ServiceCheck;
import com.orbitz.fasterxml.jackson.annotation.JsonCreator;
import com.orbitz.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.orbitz.fasterxml.jackson.annotation.JsonProperty;
import com.orbitz.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.orbitz.google.common.base.MoreObjects;
import com.orbitz.google.common.base.Preconditions;
import com.orbitz.google.common.collect.ImmutableList;
import com.orbitz.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class ImmutableServiceCheck
extends ServiceCheck {
    private final Node node;
    private final Service service;
    private final ImmutableList<HealthCheck> checks;

    private ImmutableServiceCheck(Node node, Service service, ImmutableList<HealthCheck> checks) {
        this.node = node;
        this.service = service;
        this.checks = checks;
    }

    @Override
    @JsonProperty(value="Node")
    public Node getNode() {
        return this.node;
    }

    @Override
    @JsonProperty(value="Service")
    public Service getService() {
        return this.service;
    }

    @JsonProperty(value="Checks")
    @JsonDeserialize(as=ImmutableList.class, contentAs=HealthCheck.class)
    public ImmutableList<HealthCheck> getChecks() {
        return this.checks;
    }

    public final ImmutableServiceCheck withNode(Node value) {
        if (this.node == value) {
            return this;
        }
        return new ImmutableServiceCheck(Preconditions.checkNotNull(value, "node"), this.service, this.checks);
    }

    public final ImmutableServiceCheck withService(Service value) {
        if (this.service == value) {
            return this;
        }
        return new ImmutableServiceCheck(this.node, Preconditions.checkNotNull(value, "service"), this.checks);
    }

    public final ImmutableServiceCheck withChecks(HealthCheck ... elements) {
        ImmutableList<HealthCheck> newValue = ImmutableList.copyOf(elements);
        return new ImmutableServiceCheck(this.node, this.service, newValue);
    }

    public final ImmutableServiceCheck withChecks(Iterable<? extends HealthCheck> elements) {
        if (this.checks == elements) {
            return this;
        }
        ImmutableList<HealthCheck> newValue = ImmutableList.copyOf(elements);
        return new ImmutableServiceCheck(this.node, this.service, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableServiceCheck && this.equalTo((ImmutableServiceCheck)another);
    }

    private boolean equalTo(ImmutableServiceCheck another) {
        return this.node.equals(another.node) && this.service.equals(another.service) && this.checks.equals(another.checks);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.node.hashCode();
        h = h * 17 + this.service.hashCode();
        h = h * 17 + this.checks.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ServiceCheck").add("node", this.node).add("service", this.service).add("checks", this.checks).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableServiceCheck fromJson(Json json) {
        Builder builder = ImmutableServiceCheck.builder();
        if (json.node != null) {
            builder.node(json.node);
        }
        if (json.service != null) {
            builder.service(json.service);
        }
        if (json.checks != null) {
            builder.addAllChecks(json.checks);
        }
        return builder.build();
    }

    public static ImmutableServiceCheck copyOf(ServiceCheck instance) {
        if (instance instanceof ImmutableServiceCheck) {
            return (ImmutableServiceCheck)instance;
        }
        return ImmutableServiceCheck.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NODE = 1L;
        private static final long INIT_BIT_SERVICE = 2L;
        private long initBits = 3L;
        private Node node;
        private Service service;
        private ImmutableList.Builder<HealthCheck> checksBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(ServiceCheck instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.node(instance.getNode());
            this.service(instance.getService());
            this.addAllChecks(instance.getChecks());
            return this;
        }

        public final Builder node(Node node) {
            this.node = Preconditions.checkNotNull(node, "node");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder service(Service service) {
            this.service = Preconditions.checkNotNull(service, "service");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addChecks(HealthCheck element) {
            this.checksBuilder.add((Object)element);
            return this;
        }

        public final Builder addChecks(HealthCheck ... elements) {
            this.checksBuilder.add(elements);
            return this;
        }

        public final Builder checks(Iterable<? extends HealthCheck> elements) {
            this.checksBuilder = ImmutableList.builder();
            return this.addAllChecks(elements);
        }

        public final Builder addAllChecks(Iterable<? extends HealthCheck> elements) {
            this.checksBuilder.addAll(elements);
            return this;
        }

        public ImmutableServiceCheck build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableServiceCheck(this.node, this.service, (ImmutableList)this.checksBuilder.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("node");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("service");
            }
            return "Cannot build ServiceCheck, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends ServiceCheck {
        Node node;
        Service service;
        List<HealthCheck> checks = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="Node")
        public void setNode(Node node) {
            this.node = node;
        }

        @JsonProperty(value="Service")
        public void setService(Service service) {
            this.service = service;
        }

        @JsonProperty(value="Checks")
        @JsonDeserialize(as=ImmutableList.class, contentAs=HealthCheck.class)
        public void setChecks(List<HealthCheck> checks) {
            this.checks = checks;
        }

        @Override
        public Node getNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Service getService() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<HealthCheck> getChecks() {
            throw new UnsupportedOperationException();
        }
    }
}

