/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.option;

import com.orbitz.consul.option.CatalogOptions;
import com.orbitz.google.common.base.MoreObjects;
import com.orbitz.google.common.base.Optional;
import com.orbitz.google.common.base.Preconditions;

public final class ImmutableCatalogOptions
extends CatalogOptions {
    private final Optional<String> datacenter;
    private final Optional<String> tag;

    private ImmutableCatalogOptions(Optional<String> datacenter, Optional<String> tag) {
        this.datacenter = datacenter;
        this.tag = tag;
    }

    @Override
    public Optional<String> getDatacenter() {
        return this.datacenter;
    }

    @Override
    public Optional<String> getTag() {
        return this.tag;
    }

    public final ImmutableCatalogOptions withDatacenter(String value) {
        Optional<String> newValue = Optional.of(value);
        return new ImmutableCatalogOptions(newValue, this.tag);
    }

    public final ImmutableCatalogOptions withDatacenter(Optional<String> optional) {
        Optional<String> value = Preconditions.checkNotNull(optional, "datacenter");
        if (this.datacenter == value) {
            return this;
        }
        return new ImmutableCatalogOptions(value, this.tag);
    }

    public final ImmutableCatalogOptions withTag(String value) {
        Optional<String> newValue = Optional.of(value);
        return new ImmutableCatalogOptions(this.datacenter, newValue);
    }

    public final ImmutableCatalogOptions withTag(Optional<String> optional) {
        Optional<String> value = Preconditions.checkNotNull(optional, "tag");
        if (this.tag == value) {
            return this;
        }
        return new ImmutableCatalogOptions(this.datacenter, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCatalogOptions && this.equalTo((ImmutableCatalogOptions)another);
    }

    private boolean equalTo(ImmutableCatalogOptions another) {
        return this.datacenter.equals(another.datacenter) && this.tag.equals(another.tag);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.datacenter.hashCode();
        h = h * 17 + this.tag.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("CatalogOptions").add("datacenter", this.datacenter).add("tag", this.tag).toString();
    }

    public static ImmutableCatalogOptions copyOf(CatalogOptions instance) {
        if (instance instanceof ImmutableCatalogOptions) {
            return (ImmutableCatalogOptions)instance;
        }
        return ImmutableCatalogOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Optional<String> datacenter = Optional.absent();
        private Optional<String> tag = Optional.absent();

        private Builder() {
        }

        public final Builder from(CatalogOptions instance) {
            Optional<String> tagOptional;
            Preconditions.checkNotNull(instance, "instance");
            Optional<String> datacenterOptional = instance.getDatacenter();
            if (datacenterOptional.isPresent()) {
                this.datacenter(datacenterOptional);
            }
            if ((tagOptional = instance.getTag()).isPresent()) {
                this.tag(tagOptional);
            }
            return this;
        }

        public final Builder datacenter(String datacenter) {
            this.datacenter = Optional.of(datacenter);
            return this;
        }

        public final Builder datacenter(Optional<String> datacenter) {
            this.datacenter = Preconditions.checkNotNull(datacenter, "datacenter");
            return this;
        }

        public final Builder tag(String tag) {
            this.tag = Optional.of(tag);
            return this;
        }

        public final Builder tag(Optional<String> tag) {
            this.tag = Preconditions.checkNotNull(tag, "tag");
            return this;
        }

        public ImmutableCatalogOptions build() throws IllegalStateException {
            return new ImmutableCatalogOptions(this.datacenter, this.tag);
        }
    }
}

