/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.option;

import com.orbitz.consul.option.EventOptions;
import com.orbitz.google.common.base.MoreObjects;
import com.orbitz.google.common.base.Optional;
import com.orbitz.google.common.base.Preconditions;

public final class ImmutableEventOptions
extends EventOptions {
    private final Optional<String> datacenter;
    private final Optional<String> nodeFilter;
    private final Optional<String> serviceFilter;
    private final Optional<String> tagFilter;

    private ImmutableEventOptions(Optional<String> datacenter, Optional<String> nodeFilter, Optional<String> serviceFilter, Optional<String> tagFilter) {
        this.datacenter = datacenter;
        this.nodeFilter = nodeFilter;
        this.serviceFilter = serviceFilter;
        this.tagFilter = tagFilter;
    }

    @Override
    public Optional<String> getDatacenter() {
        return this.datacenter;
    }

    @Override
    public Optional<String> getNodeFilter() {
        return this.nodeFilter;
    }

    @Override
    public Optional<String> getServiceFilter() {
        return this.serviceFilter;
    }

    @Override
    public Optional<String> getTagFilter() {
        return this.tagFilter;
    }

    public final ImmutableEventOptions withDatacenter(String value) {
        Optional<String> newValue = Optional.of(value);
        return new ImmutableEventOptions(newValue, this.nodeFilter, this.serviceFilter, this.tagFilter);
    }

    public final ImmutableEventOptions withDatacenter(Optional<String> optional) {
        Optional<String> value = Preconditions.checkNotNull(optional, "datacenter");
        if (this.datacenter == value) {
            return this;
        }
        return new ImmutableEventOptions(value, this.nodeFilter, this.serviceFilter, this.tagFilter);
    }

    public final ImmutableEventOptions withNodeFilter(String value) {
        Optional<String> newValue = Optional.of(value);
        return new ImmutableEventOptions(this.datacenter, newValue, this.serviceFilter, this.tagFilter);
    }

    public final ImmutableEventOptions withNodeFilter(Optional<String> optional) {
        Optional<String> value = Preconditions.checkNotNull(optional, "nodeFilter");
        if (this.nodeFilter == value) {
            return this;
        }
        return new ImmutableEventOptions(this.datacenter, value, this.serviceFilter, this.tagFilter);
    }

    public final ImmutableEventOptions withServiceFilter(String value) {
        Optional<String> newValue = Optional.of(value);
        return new ImmutableEventOptions(this.datacenter, this.nodeFilter, newValue, this.tagFilter);
    }

    public final ImmutableEventOptions withServiceFilter(Optional<String> optional) {
        Optional<String> value = Preconditions.checkNotNull(optional, "serviceFilter");
        if (this.serviceFilter == value) {
            return this;
        }
        return new ImmutableEventOptions(this.datacenter, this.nodeFilter, value, this.tagFilter);
    }

    public final ImmutableEventOptions withTagFilter(String value) {
        Optional<String> newValue = Optional.of(value);
        return new ImmutableEventOptions(this.datacenter, this.nodeFilter, this.serviceFilter, newValue);
    }

    public final ImmutableEventOptions withTagFilter(Optional<String> optional) {
        Optional<String> value = Preconditions.checkNotNull(optional, "tagFilter");
        if (this.tagFilter == value) {
            return this;
        }
        return new ImmutableEventOptions(this.datacenter, this.nodeFilter, this.serviceFilter, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEventOptions && this.equalTo((ImmutableEventOptions)another);
    }

    private boolean equalTo(ImmutableEventOptions another) {
        return this.datacenter.equals(another.datacenter) && this.nodeFilter.equals(another.nodeFilter) && this.serviceFilter.equals(another.serviceFilter) && this.tagFilter.equals(another.tagFilter);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.datacenter.hashCode();
        h = h * 17 + this.nodeFilter.hashCode();
        h = h * 17 + this.serviceFilter.hashCode();
        h = h * 17 + this.tagFilter.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("EventOptions").add("datacenter", this.datacenter).add("nodeFilter", this.nodeFilter).add("serviceFilter", this.serviceFilter).add("tagFilter", this.tagFilter).toString();
    }

    public static ImmutableEventOptions copyOf(EventOptions instance) {
        if (instance instanceof ImmutableEventOptions) {
            return (ImmutableEventOptions)instance;
        }
        return ImmutableEventOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Optional<String> datacenter = Optional.absent();
        private Optional<String> nodeFilter = Optional.absent();
        private Optional<String> serviceFilter = Optional.absent();
        private Optional<String> tagFilter = Optional.absent();

        private Builder() {
        }

        public final Builder from(EventOptions instance) {
            Optional<String> tagFilterOptional;
            Optional<String> serviceFilterOptional;
            Optional<String> nodeFilterOptional;
            Preconditions.checkNotNull(instance, "instance");
            Optional<String> datacenterOptional = instance.getDatacenter();
            if (datacenterOptional.isPresent()) {
                this.datacenter(datacenterOptional);
            }
            if ((nodeFilterOptional = instance.getNodeFilter()).isPresent()) {
                this.nodeFilter(nodeFilterOptional);
            }
            if ((serviceFilterOptional = instance.getServiceFilter()).isPresent()) {
                this.serviceFilter(serviceFilterOptional);
            }
            if ((tagFilterOptional = instance.getTagFilter()).isPresent()) {
                this.tagFilter(tagFilterOptional);
            }
            return this;
        }

        public final Builder datacenter(String datacenter) {
            this.datacenter = Optional.of(datacenter);
            return this;
        }

        public final Builder datacenter(Optional<String> datacenter) {
            this.datacenter = Preconditions.checkNotNull(datacenter, "datacenter");
            return this;
        }

        public final Builder nodeFilter(String nodeFilter) {
            this.nodeFilter = Optional.of(nodeFilter);
            return this;
        }

        public final Builder nodeFilter(Optional<String> nodeFilter) {
            this.nodeFilter = Preconditions.checkNotNull(nodeFilter, "nodeFilter");
            return this;
        }

        public final Builder serviceFilter(String serviceFilter) {
            this.serviceFilter = Optional.of(serviceFilter);
            return this;
        }

        public final Builder serviceFilter(Optional<String> serviceFilter) {
            this.serviceFilter = Preconditions.checkNotNull(serviceFilter, "serviceFilter");
            return this;
        }

        public final Builder tagFilter(String tagFilter) {
            this.tagFilter = Optional.of(tagFilter);
            return this;
        }

        public final Builder tagFilter(Optional<String> tagFilter) {
            this.tagFilter = Preconditions.checkNotNull(tagFilter, "tagFilter");
            return this;
        }

        public ImmutableEventOptions build() throws IllegalStateException {
            return new ImmutableEventOptions(this.datacenter, this.nodeFilter, this.serviceFilter, this.tagFilter);
        }
    }
}

