/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.option;

import com.orbitz.consul.option.ConsistencyMode;
import com.orbitz.consul.option.QueryOptions;
import com.orbitz.google.common.base.MoreObjects;
import com.orbitz.google.common.base.Optional;
import com.orbitz.google.common.base.Preconditions;
import com.orbitz.google.common.collect.Lists;
import com.orbitz.google.common.primitives.Booleans;
import java.math.BigInteger;
import java.util.ArrayList;

public final class ImmutableQueryOptions
extends QueryOptions {
    private final Optional<String> wait;
    private final Optional<String> token;
    private final Optional<BigInteger> index;
    private final Optional<String> near;
    private final ConsistencyMode consistencyMode;
    private final boolean isBlocking;
    private final boolean hasToken;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile InitShim initShim = new InitShim();

    private ImmutableQueryOptions(Builder builder) {
        this.wait = builder.wait;
        this.token = builder.token;
        this.index = builder.index;
        this.near = builder.near;
        if (builder.consistencyMode != null) {
            this.initShim.consistencyMode(builder.consistencyMode);
        }
        this.consistencyMode = this.initShim.getConsistencyMode();
        this.isBlocking = this.initShim.isBlocking();
        this.hasToken = this.initShim.hasToken();
        this.initShim = null;
    }

    private ImmutableQueryOptions(Optional<String> wait, Optional<String> token, Optional<BigInteger> index, Optional<String> near, ConsistencyMode consistencyMode) {
        this.wait = wait;
        this.token = token;
        this.index = index;
        this.near = near;
        this.consistencyMode = consistencyMode;
        this.initShim.consistencyMode(consistencyMode);
        this.isBlocking = this.initShim.isBlocking();
        this.hasToken = this.initShim.hasToken();
        this.initShim = null;
    }

    @Override
    public Optional<String> getWait() {
        return this.wait;
    }

    @Override
    public Optional<String> getToken() {
        return this.token;
    }

    @Override
    public Optional<BigInteger> getIndex() {
        return this.index;
    }

    @Override
    public Optional<String> getNear() {
        return this.near;
    }

    @Override
    public ConsistencyMode getConsistencyMode() {
        return this.initShim != null ? this.initShim.getConsistencyMode() : this.consistencyMode;
    }

    @Override
    public boolean isBlocking() {
        return this.initShim != null ? this.initShim.isBlocking() : this.isBlocking;
    }

    @Override
    public boolean hasToken() {
        return this.initShim != null ? this.initShim.hasToken() : this.hasToken;
    }

    public final ImmutableQueryOptions withWait(String value) {
        Optional<String> newValue = Optional.of(value);
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(newValue, this.token, this.index, this.near, this.consistencyMode));
    }

    public final ImmutableQueryOptions withWait(Optional<String> optional) {
        Optional<String> value = Preconditions.checkNotNull(optional, "wait");
        if (this.wait == value) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(value, this.token, this.index, this.near, this.consistencyMode));
    }

    public final ImmutableQueryOptions withToken(String value) {
        Optional<String> newValue = Optional.of(value);
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, newValue, this.index, this.near, this.consistencyMode));
    }

    public final ImmutableQueryOptions withToken(Optional<String> optional) {
        Optional<String> value = Preconditions.checkNotNull(optional, "token");
        if (this.token == value) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, value, this.index, this.near, this.consistencyMode));
    }

    public final ImmutableQueryOptions withIndex(BigInteger value) {
        Optional<BigInteger> newValue = Optional.of(value);
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, this.token, newValue, this.near, this.consistencyMode));
    }

    public final ImmutableQueryOptions withIndex(Optional<BigInteger> optional) {
        Optional<BigInteger> value = Preconditions.checkNotNull(optional, "index");
        if (this.index == value) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, this.token, value, this.near, this.consistencyMode));
    }

    public final ImmutableQueryOptions withNear(String value) {
        Optional<String> newValue = Optional.of(value);
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, this.token, this.index, newValue, this.consistencyMode));
    }

    public final ImmutableQueryOptions withNear(Optional<String> optional) {
        Optional<String> value = Preconditions.checkNotNull(optional, "near");
        if (this.near == value) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, this.token, this.index, value, this.consistencyMode));
    }

    public final ImmutableQueryOptions withConsistencyMode(ConsistencyMode value) {
        if (this.consistencyMode == value) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, this.token, this.index, this.near, Preconditions.checkNotNull(value, "consistencyMode")));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableQueryOptions && this.equalTo((ImmutableQueryOptions)another);
    }

    private boolean equalTo(ImmutableQueryOptions another) {
        return this.wait.equals(another.wait) && this.token.equals(another.token) && this.index.equals(another.index) && this.near.equals(another.near) && this.consistencyMode.equals((Object)another.consistencyMode) && this.isBlocking == another.isBlocking && this.hasToken == another.hasToken;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.wait.hashCode();
        h = h * 17 + this.token.hashCode();
        h = h * 17 + this.index.hashCode();
        h = h * 17 + this.near.hashCode();
        h = h * 17 + this.consistencyMode.hashCode();
        h = h * 17 + Booleans.hashCode(this.isBlocking);
        h = h * 17 + Booleans.hashCode(this.hasToken);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("QueryOptions").add("wait", this.wait).add("token", this.token).add("index", this.index).add("near", this.near).add("consistencyMode", (Object)this.consistencyMode).add("isBlocking", this.isBlocking).add("hasToken", this.hasToken).toString();
    }

    private static ImmutableQueryOptions validate(ImmutableQueryOptions instance) {
        instance.validate();
        return instance;
    }

    public static ImmutableQueryOptions copyOf(QueryOptions instance) {
        if (instance instanceof ImmutableQueryOptions) {
            return (ImmutableQueryOptions)instance;
        }
        return ImmutableQueryOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Optional<String> wait = Optional.absent();
        private Optional<String> token = Optional.absent();
        private Optional<BigInteger> index = Optional.absent();
        private Optional<String> near = Optional.absent();
        private ConsistencyMode consistencyMode;

        private Builder() {
        }

        public final Builder from(QueryOptions instance) {
            Optional<String> nearOptional;
            Optional<BigInteger> indexOptional;
            Optional<String> tokenOptional;
            Preconditions.checkNotNull(instance, "instance");
            Optional<String> waitOptional = instance.getWait();
            if (waitOptional.isPresent()) {
                this.wait(waitOptional);
            }
            if ((tokenOptional = instance.getToken()).isPresent()) {
                this.token(tokenOptional);
            }
            if ((indexOptional = instance.getIndex()).isPresent()) {
                this.index(indexOptional);
            }
            if ((nearOptional = instance.getNear()).isPresent()) {
                this.near(nearOptional);
            }
            this.consistencyMode(instance.getConsistencyMode());
            return this;
        }

        public final Builder wait(String wait) {
            this.wait = Optional.of(wait);
            return this;
        }

        public final Builder wait(Optional<String> wait) {
            this.wait = Preconditions.checkNotNull(wait, "wait");
            return this;
        }

        public final Builder token(String token) {
            this.token = Optional.of(token);
            return this;
        }

        public final Builder token(Optional<String> token) {
            this.token = Preconditions.checkNotNull(token, "token");
            return this;
        }

        public final Builder index(BigInteger index) {
            this.index = Optional.of(index);
            return this;
        }

        public final Builder index(Optional<BigInteger> index) {
            this.index = Preconditions.checkNotNull(index, "index");
            return this;
        }

        public final Builder near(String near) {
            this.near = Optional.of(near);
            return this;
        }

        public final Builder near(Optional<String> near) {
            this.near = Preconditions.checkNotNull(near, "near");
            return this;
        }

        public final Builder consistencyMode(ConsistencyMode consistencyMode) {
            this.consistencyMode = Preconditions.checkNotNull(consistencyMode, "consistencyMode");
            return this;
        }

        public ImmutableQueryOptions build() throws IllegalStateException {
            return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this));
        }
    }

    private final class InitShim {
        private ConsistencyMode consistencyMode;
        private byte consistencyModeStage;
        private boolean isBlocking;
        private byte isBlockingStage;
        private boolean hasToken;
        private byte hasTokenStage;

        private InitShim() {
        }

        ConsistencyMode getConsistencyMode() {
            if (this.consistencyModeStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.consistencyModeStage == 0) {
                this.consistencyModeStage = (byte)-1;
                this.consistencyMode = Preconditions.checkNotNull(ImmutableQueryOptions.super.getConsistencyMode(), "consistencyMode");
                this.consistencyModeStage = 1;
            }
            return this.consistencyMode;
        }

        ConsistencyMode consistencyMode(ConsistencyMode value) {
            this.consistencyMode = value;
            this.consistencyModeStage = 1;
            return value;
        }

        boolean isBlocking() {
            if (this.isBlockingStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isBlockingStage == 0) {
                this.isBlockingStage = (byte)-1;
                this.isBlocking = ImmutableQueryOptions.super.isBlocking();
                this.isBlockingStage = 1;
            }
            return this.isBlocking;
        }

        boolean hasToken() {
            if (this.hasTokenStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasTokenStage == 0) {
                this.hasTokenStage = (byte)-1;
                this.hasToken = ImmutableQueryOptions.super.hasToken();
                this.hasTokenStage = 1;
            }
            return this.hasToken;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (this.consistencyModeStage == -1) {
                attributes.add("consistencyMode");
            }
            if (this.isBlockingStage == -1) {
                attributes.add("isBlocking");
            }
            if (this.hasTokenStage == -1) {
                attributes.add("hasToken");
            }
            return "Cannot build QueryOptions, attribute initializers form cycle" + attributes;
        }
    }
}

