package com.orbitz.consul.model.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.health.HealthCheck;
import com.orbitz.consul.model.health.Node;
import com.orbitz.consul.model.health.Service;
import java.util.List;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link QueryResult}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableQueryResult.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "QueryResult"})
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableQueryResult extends QueryResult {
  private final Node node;
  private final Service service;
  private final ImmutableList<HealthCheck> checks;
  private final Optional<DnsQuery> dns;
  private final Optional<String> datacenters;
  private final Optional<Integer> failovers;

  private ImmutableQueryResult(
      Node node,
      Service service,
      ImmutableList<HealthCheck> checks,
      Optional<DnsQuery> dns,
      Optional<String> datacenters,
      Optional<Integer> failovers) {
    this.node = node;
    this.service = service;
    this.checks = checks;
    this.dns = dns;
    this.datacenters = datacenters;
    this.failovers = failovers;
  }

  /**
   * @return The value of the {@code node} attribute
   */
  @JsonProperty(value = "Node")
  @Override
  public Node getNode() {
    return node;
  }

  /**
   * @return The value of the {@code service} attribute
   */
  @JsonProperty(value = "Service")
  @Override
  public Service getService() {
    return service;
  }

  /**
   * @return The value of the {@code checks} attribute
   */
  @JsonProperty(value = "Checks")
  @JsonDeserialize(as = ImmutableList.class, contentAs = HealthCheck.class)
  @Override
  public ImmutableList<HealthCheck> getChecks() {
    return checks;
  }

  /**
   * @return The value of the {@code dns} attribute
   */
  @JsonProperty(value = "DNS")
  @Override
  public Optional<DnsQuery> getDns() {
    return dns;
  }

  /**
   * @return The value of the {@code datacenters} attribute
   */
  @JsonProperty(value = "Datacenters")
  @Override
  public Optional<String> datacenters() {
    return datacenters;
  }

  /**
   * @return The value of the {@code failovers} attribute
   */
  @JsonProperty(value = "Failovers")
  @Override
  public Optional<Integer> failovers() {
    return failovers;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QueryResult#getNode() node} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for node
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQueryResult withNode(Node value) {
    if (this.node == value) return this;
    return new ImmutableQueryResult(
        Preconditions.checkNotNull(value, "node"),
        this.service,
        this.checks,
        this.dns,
        this.datacenters,
        this.failovers);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QueryResult#getService() service} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for service
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQueryResult withService(Service value) {
    if (this.service == value) return this;
    return new ImmutableQueryResult(
        this.node,
        Preconditions.checkNotNull(value, "service"),
        this.checks,
        this.dns,
        this.datacenters,
        this.failovers);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link QueryResult#getChecks() checks}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryResult withChecks(HealthCheck... elements) {
    ImmutableList<HealthCheck> newValue = ImmutableList.copyOf(elements);
    return new ImmutableQueryResult(this.node, this.service, newValue, this.dns, this.datacenters, this.failovers);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link QueryResult#getChecks() checks}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of checks elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryResult withChecks(Iterable<? extends HealthCheck> elements) {
    if (this.checks == elements) return this;
    ImmutableList<HealthCheck> newValue = ImmutableList.copyOf(elements);
    return new ImmutableQueryResult(this.node, this.service, newValue, this.dns, this.datacenters, this.failovers);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link QueryResult#getDns() dns} attribute.
   * @param value The value for dns
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryResult withDns(DnsQuery value) {
    Optional<DnsQuery> newValue = Optional.of(value);
    return new ImmutableQueryResult(this.node, this.service, this.checks, newValue, this.datacenters, this.failovers);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link QueryResult#getDns() dns} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for dns
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryResult withDns(Optional<DnsQuery> optional) {
    Optional<DnsQuery> value = Preconditions.checkNotNull(optional, "dns");
    if (this.dns == value) return this;
    return new ImmutableQueryResult(this.node, this.service, this.checks, value, this.datacenters, this.failovers);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link QueryResult#datacenters() datacenters} attribute.
   * @param value The value for datacenters
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryResult withDatacenters(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutableQueryResult(this.node, this.service, this.checks, this.dns, newValue, this.failovers);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link QueryResult#datacenters() datacenters} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for datacenters
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryResult withDatacenters(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "datacenters");
    if (this.datacenters == value) return this;
    return new ImmutableQueryResult(this.node, this.service, this.checks, this.dns, value, this.failovers);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link QueryResult#failovers() failovers} attribute.
   * @param value The value for failovers
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryResult withFailovers(int value) {
    Optional<Integer> newValue = Optional.of(value);
    return new ImmutableQueryResult(this.node, this.service, this.checks, this.dns, this.datacenters, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link QueryResult#failovers() failovers} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for failovers
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryResult withFailovers(Optional<Integer> optional) {
    Optional<Integer> value = Preconditions.checkNotNull(optional, "failovers");
    if (this.failovers == value) return this;
    return new ImmutableQueryResult(this.node, this.service, this.checks, this.dns, this.datacenters, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableQueryResult} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableQueryResult
        && equalTo((ImmutableQueryResult) another);
  }

  private boolean equalTo(ImmutableQueryResult another) {
    return node.equals(another.node)
        && service.equals(another.service)
        && checks.equals(another.checks)
        && dns.equals(another.dns)
        && datacenters.equals(another.datacenters)
        && failovers.equals(another.failovers);
  }

  /**
   * Computes a hash code from attributes: {@code node}, {@code service}, {@code checks}, {@code dns}, {@code datacenters}, {@code failovers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + node.hashCode();
    h = h * 17 + service.hashCode();
    h = h * 17 + checks.hashCode();
    h = h * 17 + dns.hashCode();
    h = h * 17 + datacenters.hashCode();
    h = h * 17 + failovers.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code QueryResult...} with all non-generated
   * and non-auxiliary attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("QueryResult")
        .add("node", node)
        .add("service", service)
        .add("checks", checks)
        .add("dns", dns)
        .add("datacenters", datacenters)
        .add("failovers", failovers)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends QueryResult {
    Node node;
    Service service;
    List<HealthCheck> checks = ImmutableList.of();
    Optional<DnsQuery> dns = Optional.absent();
    Optional<String> datacenters = Optional.absent();
    Optional<Integer> failovers = Optional.absent();
    @JsonProperty(value = "Node")
    public void setNode(Node node) {
      this.node = node;
    }
    @JsonProperty(value = "Service")
    public void setService(Service service) {
      this.service = service;
    }
    @JsonProperty(value = "Checks")
    @JsonDeserialize(as = ImmutableList.class, contentAs = HealthCheck.class)
    public void setChecks(List<HealthCheck> checks) {
      this.checks = checks;
    }
    @JsonProperty(value = "DNS")
    public void setDns(Optional<DnsQuery> dns) {
      this.dns = dns;
    }
    @JsonProperty(value = "Datacenters")
    public void setDatacenters(Optional<String> datacenters) {
      this.datacenters = datacenters;
    }
    @JsonProperty(value = "Failovers")
    public void setFailovers(Optional<Integer> failovers) {
      this.failovers = failovers;
    }
    @Override
    public Node getNode() { throw new UnsupportedOperationException(); }
    @Override
    public Service getService() { throw new UnsupportedOperationException(); }
    @Override
    public List<HealthCheck> getChecks() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<DnsQuery> getDns() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> datacenters() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> failovers() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableQueryResult fromJson(Json json) {
    ImmutableQueryResult.Builder builder = ImmutableQueryResult.builder();
    if (json.node != null) {
      builder.node(json.node);
    }
    if (json.service != null) {
      builder.service(json.service);
    }
    if (json.checks != null) {
      builder.addAllChecks(json.checks);
    }
    if (json.dns != null) {
      builder.dns(json.dns);
    }
    if (json.datacenters != null) {
      builder.datacenters(json.datacenters);
    }
    if (json.failovers != null) {
      builder.failovers(json.failovers);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link QueryResult} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable QueryResult instance
   */
  public static ImmutableQueryResult copyOf(QueryResult instance) {
    if (instance instanceof ImmutableQueryResult) {
      return (ImmutableQueryResult) instance;
    }
    return ImmutableQueryResult.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableQueryResult ImmutableQueryResult}.
   * @return A new ImmutableQueryResult builder
   */
  public static ImmutableQueryResult.Builder builder() {
    return new ImmutableQueryResult.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableQueryResult ImmutableQueryResult}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NODE = 0x1L;
    private static final long INIT_BIT_SERVICE = 0x2L;
    private long initBits = 0x3;

    private Node node;
    private Service service;
    private ImmutableList.Builder<HealthCheck> checksBuilder = ImmutableList.builder();
    private Optional<DnsQuery> dns = Optional.absent();
    private Optional<String> datacenters = Optional.absent();
    private Optional<Integer> failovers = Optional.absent();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code QueryResult} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(QueryResult instance) {
      Preconditions.checkNotNull(instance, "instance");
      node(instance.getNode());
      service(instance.getService());
      addAllChecks(instance.getChecks());
      Optional<DnsQuery> dnsOptional = instance.getDns();
      if (dnsOptional.isPresent()) {
        dns(dnsOptional);
      }
      Optional<String> datacentersOptional = instance.datacenters();
      if (datacentersOptional.isPresent()) {
        datacenters(datacentersOptional);
      }
      Optional<Integer> failoversOptional = instance.failovers();
      if (failoversOptional.isPresent()) {
        failovers(failoversOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link QueryResult#getNode() node} attribute.
     * @param node The value for node 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder node(Node node) {
      this.node = Preconditions.checkNotNull(node, "node");
      initBits &= ~INIT_BIT_NODE;
      return this;
    }

    /**
     * Initializes the value for the {@link QueryResult#getService() service} attribute.
     * @param service The value for service 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder service(Service service) {
      this.service = Preconditions.checkNotNull(service, "service");
      initBits &= ~INIT_BIT_SERVICE;
      return this;
    }

    /**
     * Adds one element to {@link QueryResult#getChecks() checks} list.
     * @param element A checks element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addChecks(HealthCheck element) {
      checksBuilder.add(element);
      return this;
    }

    /**
     * Adds elements to {@link QueryResult#getChecks() checks} list.
     * @param elements An array of checks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addChecks(HealthCheck... elements) {
      checksBuilder.add(elements);
      return this;
    }

    /**
     * Sets or replaces all elements for {@link QueryResult#getChecks() checks} list.
     * @param elements An iterable of checks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder checks(Iterable<? extends HealthCheck> elements) {
      checksBuilder = ImmutableList.builder();
      return addAllChecks(elements);
    }

    /**
     * Adds elements to {@link QueryResult#getChecks() checks} list.
     * @param elements An iterable of checks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllChecks(Iterable<? extends HealthCheck> elements) {
      checksBuilder.addAll(elements);
      return this;
    }

    /**
     * Initializes the optional value {@link QueryResult#getDns() dns} to dns.
     * @param dns The value for dns
     * @return {@code this} builder for chained invocation
     */
    public final Builder dns(DnsQuery dns) {
      this.dns = Optional.of(dns);
      return this;
    }

    /**
     * Initializes the optional value {@link QueryResult#getDns() dns} to dns.
     * @param dns The value for dns
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dns(Optional<DnsQuery> dns) {
      this.dns = Preconditions.checkNotNull(dns, "dns");
      return this;
    }

    /**
     * Initializes the optional value {@link QueryResult#datacenters() datacenters} to datacenters.
     * @param datacenters The value for datacenters
     * @return {@code this} builder for chained invocation
     */
    public final Builder datacenters(String datacenters) {
      this.datacenters = Optional.of(datacenters);
      return this;
    }

    /**
     * Initializes the optional value {@link QueryResult#datacenters() datacenters} to datacenters.
     * @param datacenters The value for datacenters
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder datacenters(Optional<String> datacenters) {
      this.datacenters = Preconditions.checkNotNull(datacenters, "datacenters");
      return this;
    }

    /**
     * Initializes the optional value {@link QueryResult#failovers() failovers} to failovers.
     * @param failovers The value for failovers
     * @return {@code this} builder for chained invocation
     */
    public final Builder failovers(int failovers) {
      this.failovers = Optional.of(failovers);
      return this;
    }

    /**
     * Initializes the optional value {@link QueryResult#failovers() failovers} to failovers.
     * @param failovers The value for failovers
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder failovers(Optional<Integer> failovers) {
      this.failovers = Preconditions.checkNotNull(failovers, "failovers");
      return this;
    }

    /**
     * Builds a new {@link ImmutableQueryResult ImmutableQueryResult}.
     * @return An immutable instance of QueryResult
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableQueryResult build() throws IllegalStateException {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableQueryResult(node, service, checksBuilder.build(), dns, datacenters, failovers);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_NODE) != 0) attributes.add("node");
      if ((initBits & INIT_BIT_SERVICE) != 0) attributes.add("service");
      return "Cannot build QueryResult, some of required attributes are not set " + attributes;
    }
  }
}
