package com.orbitz.consul.model.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link RaftIndex}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRaftIndex.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "RaftIndex"})
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableRaftIndex extends RaftIndex {

  private ImmutableRaftIndex(ImmutableRaftIndex.Builder builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRaftIndex} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRaftIndex
        && equalTo((ImmutableRaftIndex) another);
  }

  private boolean equalTo(ImmutableRaftIndex another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return -1223106796;
  }

  /**
   * Prints the immutable value {@code RaftIndex...} with all non-generated
   * and non-auxiliary attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RaftIndex{}";
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableRaftIndex fromJson(Map<String, Object> json) {
    ImmutableRaftIndex.Builder builder = ImmutableRaftIndex.builder();
    return builder.build();
  }

  /**
   * Creates a builder for {@link ImmutableRaftIndex ImmutableRaftIndex}.
   * @return A new ImmutableRaftIndex builder
   */
  public static ImmutableRaftIndex.Builder builder() {
    return new ImmutableRaftIndex.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRaftIndex ImmutableRaftIndex}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RaftIndex} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RaftIndex instance) {
      Preconditions.checkNotNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableRaftIndex ImmutableRaftIndex}.
     * @return An immutable instance of RaftIndex
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRaftIndex build() throws IllegalStateException {
      return new ImmutableRaftIndex(this);
    }
  }
}
