/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.orbitz.consul.model.agent.Registration;

public final class ImmutableRegCheck
extends Registration.RegCheck {
    private final Optional<String> script;
    private final Optional<String> interval;
    private final Optional<String> ttl;
    private final Optional<String> http;
    private final Optional<String> tcp;

    private ImmutableRegCheck(Optional<String> script, Optional<String> interval, Optional<String> ttl, Optional<String> http, Optional<String> tcp) {
        this.script = script;
        this.interval = interval;
        this.ttl = ttl;
        this.http = http;
        this.tcp = tcp;
    }

    @Override
    @JsonProperty(value="Script")
    public Optional<String> getScript() {
        return this.script;
    }

    @Override
    @JsonProperty(value="Interval")
    public Optional<String> getInterval() {
        return this.interval;
    }

    @Override
    @JsonProperty(value="TTL")
    public Optional<String> getTtl() {
        return this.ttl;
    }

    @Override
    @JsonProperty(value="HTTP")
    public Optional<String> getHttp() {
        return this.http;
    }

    @Override
    @JsonProperty(value="TCP")
    public Optional<String> getTcp() {
        return this.tcp;
    }

    public final ImmutableRegCheck withScript(String value) {
        Optional newValue = Optional.of((Object)value);
        return ImmutableRegCheck.validate(new ImmutableRegCheck((Optional<String>)newValue, this.interval, this.ttl, this.http, this.tcp));
    }

    public final ImmutableRegCheck withScript(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"script");
        if (this.script == value) {
            return this;
        }
        return ImmutableRegCheck.validate(new ImmutableRegCheck((Optional<String>)value, this.interval, this.ttl, this.http, this.tcp));
    }

    public final ImmutableRegCheck withInterval(String value) {
        Optional newValue = Optional.of((Object)value);
        return ImmutableRegCheck.validate(new ImmutableRegCheck(this.script, (Optional<String>)newValue, this.ttl, this.http, this.tcp));
    }

    public final ImmutableRegCheck withInterval(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"interval");
        if (this.interval == value) {
            return this;
        }
        return ImmutableRegCheck.validate(new ImmutableRegCheck(this.script, (Optional<String>)value, this.ttl, this.http, this.tcp));
    }

    public final ImmutableRegCheck withTtl(String value) {
        Optional newValue = Optional.of((Object)value);
        return ImmutableRegCheck.validate(new ImmutableRegCheck(this.script, this.interval, (Optional<String>)newValue, this.http, this.tcp));
    }

    public final ImmutableRegCheck withTtl(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"ttl");
        if (this.ttl == value) {
            return this;
        }
        return ImmutableRegCheck.validate(new ImmutableRegCheck(this.script, this.interval, (Optional<String>)value, this.http, this.tcp));
    }

    public final ImmutableRegCheck withHttp(String value) {
        Optional newValue = Optional.of((Object)value);
        return ImmutableRegCheck.validate(new ImmutableRegCheck(this.script, this.interval, this.ttl, (Optional<String>)newValue, this.tcp));
    }

    public final ImmutableRegCheck withHttp(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"http");
        if (this.http == value) {
            return this;
        }
        return ImmutableRegCheck.validate(new ImmutableRegCheck(this.script, this.interval, this.ttl, (Optional<String>)value, this.tcp));
    }

    public final ImmutableRegCheck withTcp(String value) {
        Optional newValue = Optional.of((Object)value);
        return ImmutableRegCheck.validate(new ImmutableRegCheck(this.script, this.interval, this.ttl, this.http, (Optional<String>)newValue));
    }

    public final ImmutableRegCheck withTcp(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"tcp");
        if (this.tcp == value) {
            return this;
        }
        return ImmutableRegCheck.validate(new ImmutableRegCheck(this.script, this.interval, this.ttl, this.http, (Optional<String>)value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRegCheck && this.equalTo((ImmutableRegCheck)another);
    }

    private boolean equalTo(ImmutableRegCheck another) {
        return this.script.equals(another.script) && this.interval.equals(another.interval) && this.ttl.equals(another.ttl) && this.http.equals(another.http) && this.tcp.equals(another.tcp);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.script.hashCode();
        h = h * 17 + this.interval.hashCode();
        h = h * 17 + this.ttl.hashCode();
        h = h * 17 + this.http.hashCode();
        h = h * 17 + this.tcp.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RegCheck").add("script", this.script).add("interval", this.interval).add("ttl", this.ttl).add("http", this.http).add("tcp", this.tcp).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableRegCheck fromJson(Json json) {
        Builder builder = ImmutableRegCheck.builder();
        if (json.script != null) {
            builder.script(json.script);
        }
        if (json.interval != null) {
            builder.interval(json.interval);
        }
        if (json.ttl != null) {
            builder.ttl(json.ttl);
        }
        if (json.http != null) {
            builder.http(json.http);
        }
        if (json.tcp != null) {
            builder.tcp(json.tcp);
        }
        return builder.build();
    }

    private static ImmutableRegCheck validate(ImmutableRegCheck instance) {
        instance.validate();
        return instance;
    }

    public static ImmutableRegCheck copyOf(Registration.RegCheck instance) {
        if (instance instanceof ImmutableRegCheck) {
            return (ImmutableRegCheck)instance;
        }
        return ImmutableRegCheck.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Optional<String> script = Optional.absent();
        private Optional<String> interval = Optional.absent();
        private Optional<String> ttl = Optional.absent();
        private Optional<String> http = Optional.absent();
        private Optional<String> tcp = Optional.absent();

        private Builder() {
        }

        public final Builder from(Registration.RegCheck instance) {
            Optional<String> tcpOptional;
            Optional<String> httpOptional;
            Optional<String> ttlOptional;
            Optional<String> intervalOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Optional<String> scriptOptional = instance.getScript();
            if (scriptOptional.isPresent()) {
                this.script(scriptOptional);
            }
            if ((intervalOptional = instance.getInterval()).isPresent()) {
                this.interval(intervalOptional);
            }
            if ((ttlOptional = instance.getTtl()).isPresent()) {
                this.ttl(ttlOptional);
            }
            if ((httpOptional = instance.getHttp()).isPresent()) {
                this.http(httpOptional);
            }
            if ((tcpOptional = instance.getTcp()).isPresent()) {
                this.tcp(tcpOptional);
            }
            return this;
        }

        public final Builder script(String script) {
            this.script = Optional.of((Object)script);
            return this;
        }

        public final Builder script(Optional<String> script) {
            this.script = (Optional)Preconditions.checkNotNull(script, (Object)"script");
            return this;
        }

        public final Builder interval(String interval) {
            this.interval = Optional.of((Object)interval);
            return this;
        }

        public final Builder interval(Optional<String> interval) {
            this.interval = (Optional)Preconditions.checkNotNull(interval, (Object)"interval");
            return this;
        }

        public final Builder ttl(String ttl) {
            this.ttl = Optional.of((Object)ttl);
            return this;
        }

        public final Builder ttl(Optional<String> ttl) {
            this.ttl = (Optional)Preconditions.checkNotNull(ttl, (Object)"ttl");
            return this;
        }

        public final Builder http(String http) {
            this.http = Optional.of((Object)http);
            return this;
        }

        public final Builder http(Optional<String> http) {
            this.http = (Optional)Preconditions.checkNotNull(http, (Object)"http");
            return this;
        }

        public final Builder tcp(String tcp) {
            this.tcp = Optional.of((Object)tcp);
            return this;
        }

        public final Builder tcp(Optional<String> tcp) {
            this.tcp = (Optional)Preconditions.checkNotNull(tcp, (Object)"tcp");
            return this;
        }

        public ImmutableRegCheck build() throws IllegalStateException {
            return ImmutableRegCheck.validate(new ImmutableRegCheck(this.script, this.interval, this.ttl, this.http, this.tcp));
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends Registration.RegCheck {
        Optional<String> script = Optional.absent();
        Optional<String> interval = Optional.absent();
        Optional<String> ttl = Optional.absent();
        Optional<String> http = Optional.absent();
        Optional<String> tcp = Optional.absent();

        Json() {
        }

        @JsonProperty(value="Script")
        public void setScript(Optional<String> script) {
            this.script = script;
        }

        @JsonProperty(value="Interval")
        public void setInterval(Optional<String> interval) {
            this.interval = interval;
        }

        @JsonProperty(value="TTL")
        public void setTtl(Optional<String> ttl) {
            this.ttl = ttl;
        }

        @JsonProperty(value="HTTP")
        public void setHttp(Optional<String> http) {
            this.http = http;
        }

        @JsonProperty(value="TCP")
        public void setTcp(Optional<String> tcp) {
            this.tcp = tcp;
        }

        @Override
        public Optional<String> getScript() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getInterval() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTtl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getHttp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTcp() {
            throw new UnsupportedOperationException();
        }
    }
}

