/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.agent.Registration;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class ImmutableRegistration
extends Registration {
    private final String name;
    private final String id;
    private final Optional<String> address;
    private final Optional<Integer> port;
    private final Optional<Registration.RegCheck> check;
    private final ImmutableList<Registration.RegCheck> checks;
    private final ImmutableList<String> tags;

    private ImmutableRegistration(String name, String id, Optional<String> address, Optional<Integer> port, Optional<Registration.RegCheck> check, ImmutableList<Registration.RegCheck> checks, ImmutableList<String> tags) {
        this.name = name;
        this.id = id;
        this.address = address;
        this.port = port;
        this.check = check;
        this.checks = checks;
        this.tags = tags;
    }

    @Override
    @JsonProperty(value="Name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Address")
    public Optional<String> getAddress() {
        return this.address;
    }

    @Override
    @JsonProperty(value="Port")
    public Optional<Integer> getPort() {
        return this.port;
    }

    @Override
    @JsonProperty(value="Check")
    public Optional<Registration.RegCheck> getCheck() {
        return this.check;
    }

    @JsonProperty(value="Checks")
    public ImmutableList<Registration.RegCheck> getChecks() {
        return this.checks;
    }

    @JsonProperty(value="Tags")
    public ImmutableList<String> getTags() {
        return this.tags;
    }

    public final ImmutableRegistration withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        return new ImmutableRegistration((String)Preconditions.checkNotNull((Object)value, (Object)"name"), this.id, this.address, this.port, this.check, this.checks, this.tags);
    }

    public final ImmutableRegistration withId(String value) {
        if (this.id.equals(value)) {
            return this;
        }
        return new ImmutableRegistration(this.name, (String)Preconditions.checkNotNull((Object)value, (Object)"id"), this.address, this.port, this.check, this.checks, this.tags);
    }

    public final ImmutableRegistration withAddress(String value) {
        Optional newValue = Optional.of((Object)value);
        return new ImmutableRegistration(this.name, this.id, (Optional<String>)newValue, this.port, this.check, this.checks, this.tags);
    }

    public final ImmutableRegistration withAddress(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"address");
        if (this.address == value) {
            return this;
        }
        return new ImmutableRegistration(this.name, this.id, (Optional<String>)value, this.port, this.check, this.checks, this.tags);
    }

    public final ImmutableRegistration withPort(int value) {
        Optional newValue = Optional.of((Object)value);
        return new ImmutableRegistration(this.name, this.id, this.address, (Optional<Integer>)newValue, this.check, this.checks, this.tags);
    }

    public final ImmutableRegistration withPort(Optional<Integer> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"port");
        if (this.port == value) {
            return this;
        }
        return new ImmutableRegistration(this.name, this.id, this.address, (Optional<Integer>)value, this.check, this.checks, this.tags);
    }

    public final ImmutableRegistration withCheck(Registration.RegCheck value) {
        Optional newValue = Optional.of((Object)value);
        return new ImmutableRegistration(this.name, this.id, this.address, this.port, (Optional<Registration.RegCheck>)newValue, this.checks, this.tags);
    }

    public final ImmutableRegistration withCheck(Optional<Registration.RegCheck> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"check");
        if (this.check == value) {
            return this;
        }
        return new ImmutableRegistration(this.name, this.id, this.address, this.port, (Optional<Registration.RegCheck>)value, this.checks, this.tags);
    }

    public final ImmutableRegistration withChecks(Registration.RegCheck ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRegistration(this.name, this.id, this.address, this.port, this.check, (ImmutableList<Registration.RegCheck>)newValue, this.tags);
    }

    public final ImmutableRegistration withChecks(Iterable<? extends Registration.RegCheck> elements) {
        if (this.checks == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRegistration(this.name, this.id, this.address, this.port, this.check, (ImmutableList<Registration.RegCheck>)newValue, this.tags);
    }

    public final ImmutableRegistration withTags(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRegistration(this.name, this.id, this.address, this.port, this.check, this.checks, (ImmutableList<String>)newValue);
    }

    public final ImmutableRegistration withTags(Iterable<String> elements) {
        if (this.tags == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRegistration(this.name, this.id, this.address, this.port, this.check, this.checks, (ImmutableList<String>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRegistration && this.equalTo((ImmutableRegistration)another);
    }

    private boolean equalTo(ImmutableRegistration another) {
        return this.name.equals(another.name) && this.id.equals(another.id) && this.address.equals(another.address) && this.port.equals(another.port) && this.check.equals(another.check) && this.checks.equals(another.checks) && this.tags.equals(another.tags);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.id.hashCode();
        h = h * 17 + this.address.hashCode();
        h = h * 17 + this.port.hashCode();
        h = h * 17 + this.check.hashCode();
        h = h * 17 + this.checks.hashCode();
        h = h * 17 + this.tags.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Registration").add("name", (Object)this.name).add("id", (Object)this.id).add("address", this.address).add("port", this.port).add("check", this.check).add("checks", this.checks).add("tags", this.tags).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableRegistration fromJson(Json json) {
        Builder builder = ImmutableRegistration.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.address != null) {
            builder.address(json.address);
        }
        if (json.port != null) {
            builder.port(json.port);
        }
        if (json.check != null) {
            builder.check(json.check);
        }
        if (json.checks != null) {
            builder.addAllChecks(json.checks);
        }
        if (json.tags != null) {
            builder.addAllTags(json.tags);
        }
        return builder.build();
    }

    public static ImmutableRegistration copyOf(Registration instance) {
        if (instance instanceof ImmutableRegistration) {
            return (ImmutableRegistration)instance;
        }
        return ImmutableRegistration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_ID = 2L;
        private long initBits = 3L;
        private String name;
        private String id;
        private Optional<String> address = Optional.absent();
        private Optional<Integer> port = Optional.absent();
        private Optional<Registration.RegCheck> check = Optional.absent();
        private ImmutableList.Builder<Registration.RegCheck> checksBuilder = ImmutableList.builder();
        private ImmutableList.Builder<String> tagsBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(Registration instance) {
            Optional<Registration.RegCheck> checkOptional;
            Optional<Integer> portOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.name(instance.getName());
            this.id(instance.getId());
            Optional<String> addressOptional = instance.getAddress();
            if (addressOptional.isPresent()) {
                this.address(addressOptional);
            }
            if ((portOptional = instance.getPort()).isPresent()) {
                this.port(portOptional);
            }
            if ((checkOptional = instance.getCheck()).isPresent()) {
                this.check(checkOptional);
            }
            this.addAllChecks(instance.getChecks());
            this.addAllTags(instance.getTags());
            return this;
        }

        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder id(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder address(String address) {
            this.address = Optional.of((Object)address);
            return this;
        }

        public final Builder address(Optional<String> address) {
            this.address = (Optional)Preconditions.checkNotNull(address, (Object)"address");
            return this;
        }

        public final Builder port(int port) {
            this.port = Optional.of((Object)port);
            return this;
        }

        public final Builder port(Optional<Integer> port) {
            this.port = (Optional)Preconditions.checkNotNull(port, (Object)"port");
            return this;
        }

        public final Builder check(Registration.RegCheck check) {
            this.check = Optional.of((Object)check);
            return this;
        }

        public final Builder check(Optional<Registration.RegCheck> check) {
            this.check = (Optional)Preconditions.checkNotNull(check, (Object)"check");
            return this;
        }

        public final Builder addChecks(Registration.RegCheck element) {
            this.checksBuilder.add((Object)element);
            return this;
        }

        public final Builder addChecks(Registration.RegCheck ... elements) {
            this.checksBuilder.add((Object[])elements);
            return this;
        }

        public final Builder checks(Iterable<? extends Registration.RegCheck> elements) {
            this.checksBuilder = ImmutableList.builder();
            return this.addAllChecks(elements);
        }

        public final Builder addAllChecks(Iterable<? extends Registration.RegCheck> elements) {
            this.checksBuilder.addAll(elements);
            return this;
        }

        public final Builder addTags(String element) {
            this.tagsBuilder.add((Object)element);
            return this;
        }

        public final Builder addTags(String ... elements) {
            this.tagsBuilder.add((Object[])elements);
            return this;
        }

        public final Builder tags(Iterable<String> elements) {
            this.tagsBuilder = ImmutableList.builder();
            return this.addAllTags(elements);
        }

        public final Builder addAllTags(Iterable<String> elements) {
            this.tagsBuilder.addAll(elements);
            return this;
        }

        public ImmutableRegistration build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRegistration(this.name, this.id, this.address, this.port, this.check, this.checksBuilder.build(), this.tagsBuilder.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build Registration, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends Registration {
        String name;
        String id;
        Optional<String> address = Optional.absent();
        Optional<Integer> port = Optional.absent();
        Optional<Registration.RegCheck> check = Optional.absent();
        List<Registration.RegCheck> checks = ImmutableList.of();
        List<String> tags = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="Name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="Id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="Address")
        public void setAddress(Optional<String> address) {
            this.address = address;
        }

        @JsonProperty(value="Port")
        public void setPort(Optional<Integer> port) {
            this.port = port;
        }

        @JsonProperty(value="Check")
        public void setCheck(Optional<Registration.RegCheck> check) {
            this.check = check;
        }

        @JsonProperty(value="Checks")
        public void setChecks(List<Registration.RegCheck> checks) {
            this.checks = checks;
        }

        @JsonProperty(value="Tags")
        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getAddress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getPort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Registration.RegCheck> getCheck() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Registration.RegCheck> getChecks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getTags() {
            throw new UnsupportedOperationException();
        }
    }
}

