/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.retrofit.converter.jackson;

import com.fasterxml.jackson.databind.ObjectWriter;
import com.orbitz.okhttp3.MediaType;
import com.orbitz.okhttp3.RequestBody;
import com.orbitz.retrofit.Converter;
import java.io.IOException;

final class JacksonRequestBodyConverter<T>
implements Converter<T, RequestBody> {
    private static final MediaType MEDIA_TYPE = MediaType.parse("application/json; charset=UTF-8");
    private final ObjectWriter adapter;

    JacksonRequestBodyConverter(ObjectWriter adapter) {
        this.adapter = adapter;
    }

    @Override
    public RequestBody convert(T value) throws IOException {
        byte[] bytes = this.adapter.writeValueAsBytes(value);
        return RequestBody.create(MEDIA_TYPE, bytes);
    }
}

