package com.orbitz.consul.model.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link ServiceQuery}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableServiceQuery.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "ServiceQuery"})
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableServiceQuery extends ServiceQuery {
  private final String service;
  private final Optional<Boolean> onlyPassing;
  private final Optional<List<String>> tags;
  private final Optional<Failover> failover;

  private ImmutableServiceQuery(
      String service,
      Optional<Boolean> onlyPassing,
      Optional<List<String>> tags,
      Optional<Failover> failover) {
    this.service = service;
    this.onlyPassing = onlyPassing;
    this.tags = tags;
    this.failover = failover;
  }

  /**
   * @return The value of the {@code service} attribute
   */
  @JsonProperty(value = "Service")
  @Override
  public String getService() {
    return service;
  }

  /**
   * @return The value of the {@code onlyPassing} attribute
   */
  @JsonProperty(value = "OnlyPassing")
  @Override
  public Optional<Boolean> getOnlyPassing() {
    return onlyPassing;
  }

  /**
   * @return The value of the {@code tags} attribute
   */
  @JsonProperty(value = "Tags")
  @Override
  public Optional<List<String>> getTags() {
    return tags;
  }

  /**
   * @return The value of the {@code failover} attribute
   */
  @JsonProperty(value = "Failover")
  @Override
  public Optional<Failover> getFailover() {
    return failover;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ServiceQuery#getService() service} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for service
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableServiceQuery withService(String value) {
    if (this.service.equals(value)) return this;
    return new ImmutableServiceQuery(
        Preconditions.checkNotNull(value, "service"),
        this.onlyPassing,
        this.tags,
        this.failover);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ServiceQuery#getOnlyPassing() onlyPassing} attribute.
   * @param value The value for onlyPassing
   * @return A modified copy of {@code this} object
   */
  public final ImmutableServiceQuery withOnlyPassing(boolean value) {
    Optional<Boolean> newValue = Optional.of(value);
    if (this.onlyPassing.equals(newValue)) return this;
    return new ImmutableServiceQuery(this.service, newValue, this.tags, this.failover);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ServiceQuery#getOnlyPassing() onlyPassing} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for onlyPassing
   * @return A modified copy of {@code this} object
   */
  public final ImmutableServiceQuery withOnlyPassing(Optional<Boolean> optional) {
    Optional<Boolean> value = Preconditions.checkNotNull(optional, "onlyPassing");
    if (this.onlyPassing.equals(value)) return this;
    return new ImmutableServiceQuery(this.service, value, this.tags, this.failover);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ServiceQuery#getTags() tags} attribute.
   * @param value The value for tags
   * @return A modified copy of {@code this} object
   */
  public final ImmutableServiceQuery withTags(List<String> value) {
    Optional<List<String>> newValue = Optional.of(value);
    if (this.tags.isPresent() && this.tags.get() == value) return this;
    return new ImmutableServiceQuery(this.service, this.onlyPassing, newValue, this.failover);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ServiceQuery#getTags() tags} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for tags
   * @return A modified copy of {@code this} object
   */
  public final ImmutableServiceQuery withTags(Optional<List<String>> optional) {
    Optional<List<String>> value = Preconditions.checkNotNull(optional, "tags");
    if (!this.tags.isPresent() && !value.isPresent()) return this;
    if (this.tags.isPresent() && value.isPresent() && this.tags.get() == value.get()) return this;
    return new ImmutableServiceQuery(this.service, this.onlyPassing, value, this.failover);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ServiceQuery#getFailover() failover} attribute.
   * @param value The value for failover
   * @return A modified copy of {@code this} object
   */
  public final ImmutableServiceQuery withFailover(Failover value) {
    Optional<Failover> newValue = Optional.of(value);
    if (this.failover.isPresent() && this.failover.get() == value) return this;
    return new ImmutableServiceQuery(this.service, this.onlyPassing, this.tags, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ServiceQuery#getFailover() failover} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for failover
   * @return A modified copy of {@code this} object
   */
  public final ImmutableServiceQuery withFailover(Optional<Failover> optional) {
    Optional<Failover> value = Preconditions.checkNotNull(optional, "failover");
    if (!this.failover.isPresent() && !value.isPresent()) return this;
    if (this.failover.isPresent() && value.isPresent() && this.failover.get() == value.get()) return this;
    return new ImmutableServiceQuery(this.service, this.onlyPassing, this.tags, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableServiceQuery} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableServiceQuery
        && equalTo((ImmutableServiceQuery) another);
  }

  private boolean equalTo(ImmutableServiceQuery another) {
    return service.equals(another.service)
        && onlyPassing.equals(another.onlyPassing)
        && tags.equals(another.tags)
        && failover.equals(another.failover);
  }

  /**
   * Computes a hash code from attributes: {@code service}, {@code onlyPassing}, {@code tags}, {@code failover}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + service.hashCode();
    h = h * 17 + onlyPassing.hashCode();
    h = h * 17 + tags.hashCode();
    h = h * 17 + failover.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ServiceQuery} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ServiceQuery")
        .omitNullValues()
        .add("service", service)
        .add("onlyPassing", onlyPassing.orNull())
        .add("tags", tags.orNull())
        .add("failover", failover.orNull())
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends ServiceQuery {
    String service;
    Optional<Boolean> onlyPassing = Optional.absent();
    Optional<List<String>> tags = Optional.absent();
    Optional<Failover> failover = Optional.absent();
    @JsonProperty(value = "Service")
    public void setService(String service) {
      this.service = service;
    }
    @JsonProperty(value = "OnlyPassing")
    public void setOnlyPassing(Optional<Boolean> onlyPassing) {
      this.onlyPassing = onlyPassing;
    }
    @JsonProperty(value = "Tags")
    public void setTags(Optional<List<String>> tags) {
      this.tags = tags;
    }
    @JsonProperty(value = "Failover")
    public void setFailover(Optional<Failover> failover) {
      this.failover = failover;
    }
    @Override
    public String getService() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> getOnlyPassing() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<List<String>> getTags() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Failover> getFailover() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableServiceQuery fromJson(Json json) {
    ImmutableServiceQuery.Builder builder = ImmutableServiceQuery.builder();
    if (json.service != null) {
      builder.service(json.service);
    }
    if (json.onlyPassing != null) {
      builder.onlyPassing(json.onlyPassing);
    }
    if (json.tags != null) {
      builder.tags(json.tags);
    }
    if (json.failover != null) {
      builder.failover(json.failover);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ServiceQuery} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ServiceQuery instance
   */
  public static ImmutableServiceQuery copyOf(ServiceQuery instance) {
    if (instance instanceof ImmutableServiceQuery) {
      return (ImmutableServiceQuery) instance;
    }
    return ImmutableServiceQuery.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableServiceQuery ImmutableServiceQuery}.
   * @return A new ImmutableServiceQuery builder
   */
  public static ImmutableServiceQuery.Builder builder() {
    return new ImmutableServiceQuery.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableServiceQuery ImmutableServiceQuery}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SERVICE = 0x1L;
    private long initBits = 0x1;

    private String service;
    private Optional<Boolean> onlyPassing = Optional.absent();
    private Optional<List<String>> tags = Optional.absent();
    private Optional<Failover> failover = Optional.absent();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServiceQuery} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServiceQuery instance) {
      Preconditions.checkNotNull(instance, "instance");
      service(instance.getService());
      Optional<Boolean> onlyPassingOptional = instance.getOnlyPassing();
      if (onlyPassingOptional.isPresent()) {
        onlyPassing(onlyPassingOptional);
      }
      Optional<List<String>> tagsOptional = instance.getTags();
      if (tagsOptional.isPresent()) {
        tags(tagsOptional);
      }
      Optional<Failover> failoverOptional = instance.getFailover();
      if (failoverOptional.isPresent()) {
        failover(failoverOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceQuery#getService() service} attribute.
     * @param service The value for service 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder service(String service) {
      this.service = Preconditions.checkNotNull(service, "service");
      initBits &= ~INIT_BIT_SERVICE;
      return this;
    }

    /**
     * Initializes the optional value {@link ServiceQuery#getOnlyPassing() onlyPassing} to onlyPassing.
     * @param onlyPassing The value for onlyPassing
     * @return {@code this} builder for chained invocation
     */
    public final Builder onlyPassing(boolean onlyPassing) {
      this.onlyPassing = Optional.of(onlyPassing);
      return this;
    }

    /**
     * Initializes the optional value {@link ServiceQuery#getOnlyPassing() onlyPassing} to onlyPassing.
     * @param onlyPassing The value for onlyPassing
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder onlyPassing(Optional<Boolean> onlyPassing) {
      this.onlyPassing = Preconditions.checkNotNull(onlyPassing, "onlyPassing");
      return this;
    }

    /**
     * Initializes the optional value {@link ServiceQuery#getTags() tags} to tags.
     * @param tags The value for tags
     * @return {@code this} builder for chained invocation
     */
    public final Builder tags(List<String> tags) {
      this.tags = Optional.of(tags);
      return this;
    }

    /**
     * Initializes the optional value {@link ServiceQuery#getTags() tags} to tags.
     * @param tags The value for tags
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tags(Optional<List<String>> tags) {
      this.tags = Preconditions.checkNotNull(tags, "tags");
      return this;
    }

    /**
     * Initializes the optional value {@link ServiceQuery#getFailover() failover} to failover.
     * @param failover The value for failover
     * @return {@code this} builder for chained invocation
     */
    public final Builder failover(Failover failover) {
      this.failover = Optional.of(failover);
      return this;
    }

    /**
     * Initializes the optional value {@link ServiceQuery#getFailover() failover} to failover.
     * @param failover The value for failover
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder failover(Optional<Failover> failover) {
      this.failover = Preconditions.checkNotNull(failover, "failover");
      return this;
    }

    /**
     * Builds a new {@link ImmutableServiceQuery ImmutableServiceQuery}.
     * @return An immutable instance of ServiceQuery
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableServiceQuery build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableServiceQuery(service, onlyPassing, tags, failover);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_SERVICE) != 0) attributes.add("service");
      return "Cannot build ServiceQuery, some of required attributes are not set " + attributes;
    }
  }
}
