package com.orbitz.consul.option;

import com.google.common.base.Optional;
import org.immutables.value.Value;

import java.util.HashMap;
import java.util.Map;

import static com.orbitz.consul.option.Options.optionallyAdd;

@Value.Immutable
public abstract class PutOptions implements ParamAdder {
    
    public static final PutOptions BLANK = ImmutablePutOptions.builder().build();
    
    public abstract Optional<Long> getCas();
    public abstract Optional<String> getAcquire();
    public abstract Optional<String> getRelease();
    public abstract Optional<String> getDc();

    @Override
    public final Map<String, Object> toQuery() {
        Map<String, Object> result = new HashMap<>();

        optionallyAdd(result, "dc", getDc());
        optionallyAdd(result, "case", getCas());
        optionallyAdd(result, "acquire", getAcquire());
        optionallyAdd(result, "release", getRelease());

        return result;
    }
}
