package com.orbitz.consul.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.event.Event;
import java.math.BigInteger;
import java.util.List;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link EventResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEventResponse.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableEventResponse.of()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "EventResponse"})
public final class ImmutableEventResponse extends EventResponse {
  private final ImmutableList<Event> events;
  private final BigInteger index;

  private ImmutableEventResponse(Iterable<? extends Event> events, BigInteger index) {
    this.events = ImmutableList.copyOf(events);
    this.index = Preconditions.checkNotNull(index, "index");
  }

  private ImmutableEventResponse(
      ImmutableEventResponse original,
      ImmutableList<Event> events,
      BigInteger index) {
    this.events = events;
    this.index = index;
  }

  /**
   * @return The value of the {@code events} attribute
   */
  @JsonProperty
  @Override
  public ImmutableList<Event> getEvents() {
    return events;
  }

  /**
   * @return The value of the {@code index} attribute
   */
  @JsonProperty
  @Override
  public BigInteger getIndex() {
    return index;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EventResponse#getEvents() events}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEventResponse withEvents(Event... elements) {
    ImmutableList<Event> newValue = ImmutableList.copyOf(elements);
    return new ImmutableEventResponse(this, newValue, this.index);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EventResponse#getEvents() events}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of events elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEventResponse withEvents(Iterable<? extends Event> elements) {
    if (this.events == elements) return this;
    ImmutableList<Event> newValue = ImmutableList.copyOf(elements);
    return new ImmutableEventResponse(this, newValue, this.index);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EventResponse#getIndex() index} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for index
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEventResponse withIndex(BigInteger value) {
    if (this.index == value) return this;
    return new ImmutableEventResponse(this, this.events, Preconditions.checkNotNull(value, "index"));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEventResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEventResponse
        && equalTo((ImmutableEventResponse) another);
  }

  private boolean equalTo(ImmutableEventResponse another) {
    return events.equals(another.events)
        && index.equals(another.index);
  }

  /**
   * Computes a hash code from attributes: {@code events}, {@code index}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + events.hashCode();
    h = h * 17 + index.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code EventResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("EventResponse")
        .omitNullValues()
        .add("events", events)
        .add("index", index)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends EventResponse {
    List<Event> events = ImmutableList.of();
    BigInteger index;
    @JsonProperty
    public void setEvents(List<Event> events) {
      this.events = events;
    }
    @JsonProperty
    public void setIndex(BigInteger index) {
      this.index = index;
    }
    @Override
    public List<Event> getEvents() { throw new UnsupportedOperationException(); }
    @Override
    public BigInteger getIndex() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableEventResponse fromJson(Json json) {
    ImmutableEventResponse.Builder builder = ImmutableEventResponse.builder();
    if (json.events != null) {
      builder.addAllEvents(json.events);
    }
    if (json.index != null) {
      builder.index(json.index);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code EventResponse} instance.
   * @param events The value for the {@code events} attribute
   * @param index The value for the {@code index} attribute
   * @return An immutable EventResponse instance
   */
  public static ImmutableEventResponse of(List<Event> events, BigInteger index) {
    return of((Iterable<? extends Event>) events, index);
  }

  /**
   * Construct a new immutable {@code EventResponse} instance.
   * @param events The value for the {@code events} attribute
   * @param index The value for the {@code index} attribute
   * @return An immutable EventResponse instance
   */
  public static ImmutableEventResponse of(Iterable<? extends Event> events, BigInteger index) {
    return new ImmutableEventResponse(events, index);
  }

  /**
   * Creates an immutable copy of a {@link EventResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable EventResponse instance
   */
  public static ImmutableEventResponse copyOf(EventResponse instance) {
    if (instance instanceof ImmutableEventResponse) {
      return (ImmutableEventResponse) instance;
    }
    return ImmutableEventResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEventResponse ImmutableEventResponse}.
   * @return A new ImmutableEventResponse builder
   */
  public static ImmutableEventResponse.Builder builder() {
    return new ImmutableEventResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEventResponse ImmutableEventResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_INDEX = 0x1L;
    private long initBits = 0x1;

    private ImmutableList.Builder<Event> eventsBuilder = ImmutableList.builder();
    private BigInteger index;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code EventResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(EventResponse instance) {
      Preconditions.checkNotNull(instance, "instance");
      addAllEvents(instance.getEvents());
      index(instance.getIndex());
      return this;
    }

    /**
     * Adds one element to {@link EventResponse#getEvents() events} list.
     * @param element A events element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addEvents(Event element) {
      eventsBuilder.add(element);
      return this;
    }

    /**
     * Adds elements to {@link EventResponse#getEvents() events} list.
     * @param elements An array of events elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addEvents(Event... elements) {
      eventsBuilder.add(elements);
      return this;
    }

    /**
     * Sets or replaces all elements for {@link EventResponse#getEvents() events} list.
     * @param elements An iterable of events elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder events(Iterable<? extends Event> elements) {
      eventsBuilder = ImmutableList.builder();
      return addAllEvents(elements);
    }

    /**
     * Adds elements to {@link EventResponse#getEvents() events} list.
     * @param elements An iterable of events elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEvents(Iterable<? extends Event> elements) {
      eventsBuilder.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link EventResponse#getIndex() index} attribute.
     * @param index The value for index 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder index(BigInteger index) {
      this.index = Preconditions.checkNotNull(index, "index");
      initBits &= ~INIT_BIT_INDEX;
      return this;
    }

    /**
     * Builds a new {@link ImmutableEventResponse ImmutableEventResponse}.
     * @return An immutable instance of EventResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEventResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableEventResponse(null, eventsBuilder.build(), index);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_INDEX) != 0) attributes.add("index");
      return "Cannot build EventResponse, some of required attributes are not set " + attributes;
    }
  }
}
