/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.fasterxml.jackson.databind.ser.std;

import com.orbitz.fasterxml.jackson.core.JsonGenerator;
import com.orbitz.fasterxml.jackson.databind.JavaType;
import com.orbitz.fasterxml.jackson.databind.JsonMappingException;
import com.orbitz.fasterxml.jackson.databind.JsonNode;
import com.orbitz.fasterxml.jackson.databind.SerializerProvider;
import com.orbitz.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.orbitz.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.orbitz.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.orbitz.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

@JacksonStdImpl
public class NullSerializer
extends StdSerializer<Object> {
    public static final NullSerializer instance = new NullSerializer();

    private NullSerializer() {
        super(Object.class);
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeNull();
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        gen.writeNull();
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("null");
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        visitor.expectNullFormat(typeHint);
    }
}

