package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link Check}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCheck.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "Check"})
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableCheck extends Check {
  private final String id;
  private final String name;
  private final Optional<String> notes;
  private final Optional<String> output;
  private final Optional<String> script;
  private final Optional<String> interval;
  private final Optional<String> ttl;
  private final Optional<String> http;
  private final Optional<String> tcp;
  private final Optional<String> serviceId;

  private ImmutableCheck(
      String id,
      String name,
      Optional<String> notes,
      Optional<String> output,
      Optional<String> script,
      Optional<String> interval,
      Optional<String> ttl,
      Optional<String> http,
      Optional<String> tcp,
      Optional<String> serviceId) {
    this.id = id;
    this.name = name;
    this.notes = notes;
    this.output = output;
    this.script = script;
    this.interval = interval;
    this.ttl = ttl;
    this.http = http;
    this.tcp = tcp;
    this.serviceId = serviceId;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty(value = "ID")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty(value = "Name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code notes} attribute
   */
  @JsonProperty(value = "Notes")
  @Override
  public Optional<String> getNotes() {
    return notes;
  }

  /**
   * @return The value of the {@code output} attribute
   */
  @JsonProperty(value = "Output")
  @Override
  public Optional<String> getOutput() {
    return output;
  }

  /**
   * @return The value of the {@code script} attribute
   */
  @JsonProperty(value = "Script")
  @Override
  public Optional<String> getScript() {
    return script;
  }

  /**
   * @return The value of the {@code interval} attribute
   */
  @JsonProperty(value = "Interval")
  @Override
  public Optional<String> getInterval() {
    return interval;
  }

  /**
   * @return The value of the {@code ttl} attribute
   */
  @JsonProperty(value = "TTL")
  @Override
  public Optional<String> getTtl() {
    return ttl;
  }

  /**
   * @return The value of the {@code http} attribute
   */
  @JsonProperty(value = "HTTP")
  @Override
  public Optional<String> getHttp() {
    return http;
  }

  /**
   * @return The value of the {@code tcp} attribute
   */
  @JsonProperty(value = "TCP")
  @Override
  public Optional<String> getTcp() {
    return tcp;
  }

  /**
   * @return The value of the {@code serviceId} attribute
   */
  @JsonProperty(value = "ServiceID")
  @Override
  public Optional<String> getServiceId() {
    return serviceId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Check#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheck withId(String value) {
    if (this.id.equals(value)) return this;
    return validate(new ImmutableCheck(
        Preconditions.checkNotNull(value, "id"),
        this.name,
        this.notes,
        this.output,
        this.script,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.serviceId));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Check#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheck withName(String value) {
    if (this.name.equals(value)) return this;
    return validate(new ImmutableCheck(
        this.id,
        Preconditions.checkNotNull(value, "name"),
        this.notes,
        this.output,
        this.script,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.serviceId));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Check#getNotes() notes} attribute.
   * @param value The value for notes
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withNotes(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.notes.equals(newValue)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        newValue,
        this.output,
        this.script,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.serviceId));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Check#getNotes() notes} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for notes
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withNotes(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "notes");
    if (this.notes.equals(value)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        value,
        this.output,
        this.script,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.serviceId));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Check#getOutput() output} attribute.
   * @param value The value for output
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withOutput(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.output.equals(newValue)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        newValue,
        this.script,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.serviceId));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Check#getOutput() output} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for output
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withOutput(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "output");
    if (this.output.equals(value)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        value,
        this.script,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.serviceId));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Check#getScript() script} attribute.
   * @param value The value for script
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withScript(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.script.equals(newValue)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        newValue,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.serviceId));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Check#getScript() script} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for script
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withScript(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "script");
    if (this.script.equals(value)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        value,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.serviceId));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Check#getInterval() interval} attribute.
   * @param value The value for interval
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withInterval(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.interval.equals(newValue)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.script,
        newValue,
        this.ttl,
        this.http,
        this.tcp,
        this.serviceId));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Check#getInterval() interval} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for interval
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withInterval(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "interval");
    if (this.interval.equals(value)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.script,
        value,
        this.ttl,
        this.http,
        this.tcp,
        this.serviceId));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Check#getTtl() ttl} attribute.
   * @param value The value for ttl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withTtl(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.ttl.equals(newValue)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.script,
        this.interval,
        newValue,
        this.http,
        this.tcp,
        this.serviceId));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Check#getTtl() ttl} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for ttl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withTtl(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "ttl");
    if (this.ttl.equals(value)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.script,
        this.interval,
        value,
        this.http,
        this.tcp,
        this.serviceId));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Check#getHttp() http} attribute.
   * @param value The value for http
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withHttp(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.http.equals(newValue)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.script,
        this.interval,
        this.ttl,
        newValue,
        this.tcp,
        this.serviceId));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Check#getHttp() http} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for http
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withHttp(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "http");
    if (this.http.equals(value)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.script,
        this.interval,
        this.ttl,
        value,
        this.tcp,
        this.serviceId));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Check#getTcp() tcp} attribute.
   * @param value The value for tcp
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withTcp(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.tcp.equals(newValue)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.script,
        this.interval,
        this.ttl,
        this.http,
        newValue,
        this.serviceId));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Check#getTcp() tcp} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for tcp
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withTcp(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "tcp");
    if (this.tcp.equals(value)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.script,
        this.interval,
        this.ttl,
        this.http,
        value,
        this.serviceId));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Check#getServiceId() serviceId} attribute.
   * @param value The value for serviceId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withServiceId(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.serviceId.equals(newValue)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.script,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        newValue));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Check#getServiceId() serviceId} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for serviceId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withServiceId(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "serviceId");
    if (this.serviceId.equals(value)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.script,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCheck} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCheck
        && equalTo((ImmutableCheck) another);
  }

  private boolean equalTo(ImmutableCheck another) {
    return id.equals(another.id)
        && name.equals(another.name)
        && notes.equals(another.notes)
        && output.equals(another.output)
        && script.equals(another.script)
        && interval.equals(another.interval)
        && ttl.equals(another.ttl)
        && http.equals(another.http)
        && tcp.equals(another.tcp)
        && serviceId.equals(another.serviceId);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code notes}, {@code output}, {@code script}, {@code interval}, {@code ttl}, {@code http}, {@code tcp}, {@code serviceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + id.hashCode();
    h = h * 17 + name.hashCode();
    h = h * 17 + notes.hashCode();
    h = h * 17 + output.hashCode();
    h = h * 17 + script.hashCode();
    h = h * 17 + interval.hashCode();
    h = h * 17 + ttl.hashCode();
    h = h * 17 + http.hashCode();
    h = h * 17 + tcp.hashCode();
    h = h * 17 + serviceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Check} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Check")
        .omitNullValues()
        .add("id", id)
        .add("name", name)
        .add("notes", notes.orNull())
        .add("output", output.orNull())
        .add("script", script.orNull())
        .add("interval", interval.orNull())
        .add("ttl", ttl.orNull())
        .add("http", http.orNull())
        .add("tcp", tcp.orNull())
        .add("serviceId", serviceId.orNull())
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends Check {
    String id;
    String name;
    Optional<String> notes = Optional.absent();
    Optional<String> output = Optional.absent();
    Optional<String> script = Optional.absent();
    Optional<String> interval = Optional.absent();
    Optional<String> ttl = Optional.absent();
    Optional<String> http = Optional.absent();
    Optional<String> tcp = Optional.absent();
    Optional<String> serviceId = Optional.absent();
    @JsonProperty(value = "ID")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty(value = "Name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty(value = "Notes")
    public void setNotes(Optional<String> notes) {
      this.notes = notes;
    }
    @JsonProperty(value = "Output")
    public void setOutput(Optional<String> output) {
      this.output = output;
    }
    @JsonProperty(value = "Script")
    public void setScript(Optional<String> script) {
      this.script = script;
    }
    @JsonProperty(value = "Interval")
    public void setInterval(Optional<String> interval) {
      this.interval = interval;
    }
    @JsonProperty(value = "TTL")
    public void setTtl(Optional<String> ttl) {
      this.ttl = ttl;
    }
    @JsonProperty(value = "HTTP")
    public void setHttp(Optional<String> http) {
      this.http = http;
    }
    @JsonProperty(value = "TCP")
    public void setTcp(Optional<String> tcp) {
      this.tcp = tcp;
    }
    @JsonProperty(value = "ServiceID")
    public void setServiceId(Optional<String> serviceId) {
      this.serviceId = serviceId;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getNotes() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getOutput() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getScript() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getInterval() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getTtl() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getHttp() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getTcp() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getServiceId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableCheck fromJson(Json json) {
    ImmutableCheck.Builder builder = ImmutableCheck.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.notes != null) {
      builder.notes(json.notes);
    }
    if (json.output != null) {
      builder.output(json.output);
    }
    if (json.script != null) {
      builder.script(json.script);
    }
    if (json.interval != null) {
      builder.interval(json.interval);
    }
    if (json.ttl != null) {
      builder.ttl(json.ttl);
    }
    if (json.http != null) {
      builder.http(json.http);
    }
    if (json.tcp != null) {
      builder.tcp(json.tcp);
    }
    if (json.serviceId != null) {
      builder.serviceId(json.serviceId);
    }
    return builder.build();
  }

  private static ImmutableCheck validate(ImmutableCheck instance) {
    instance.validate();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link Check} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Check instance
   */
  public static ImmutableCheck copyOf(Check instance) {
    if (instance instanceof ImmutableCheck) {
      return (ImmutableCheck) instance;
    }
    return ImmutableCheck.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCheck ImmutableCheck}.
   * @return A new ImmutableCheck builder
   */
  public static ImmutableCheck.Builder builder() {
    return new ImmutableCheck.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCheck ImmutableCheck}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private long initBits = 0x3;

    private String id;
    private String name;
    private Optional<String> notes = Optional.absent();
    private Optional<String> output = Optional.absent();
    private Optional<String> script = Optional.absent();
    private Optional<String> interval = Optional.absent();
    private Optional<String> ttl = Optional.absent();
    private Optional<String> http = Optional.absent();
    private Optional<String> tcp = Optional.absent();
    private Optional<String> serviceId = Optional.absent();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Check} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Check instance) {
      Preconditions.checkNotNull(instance, "instance");
      id(instance.getId());
      name(instance.getName());
      Optional<String> notesOptional = instance.getNotes();
      if (notesOptional.isPresent()) {
        notes(notesOptional);
      }
      Optional<String> outputOptional = instance.getOutput();
      if (outputOptional.isPresent()) {
        output(outputOptional);
      }
      Optional<String> scriptOptional = instance.getScript();
      if (scriptOptional.isPresent()) {
        script(scriptOptional);
      }
      Optional<String> intervalOptional = instance.getInterval();
      if (intervalOptional.isPresent()) {
        interval(intervalOptional);
      }
      Optional<String> ttlOptional = instance.getTtl();
      if (ttlOptional.isPresent()) {
        ttl(ttlOptional);
      }
      Optional<String> httpOptional = instance.getHttp();
      if (httpOptional.isPresent()) {
        http(httpOptional);
      }
      Optional<String> tcpOptional = instance.getTcp();
      if (tcpOptional.isPresent()) {
        tcp(tcpOptional);
      }
      Optional<String> serviceIdOptional = instance.getServiceId();
      if (serviceIdOptional.isPresent()) {
        serviceId(serviceIdOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Check#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Preconditions.checkNotNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Check#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Preconditions.checkNotNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getNotes() notes} to notes.
     * @param notes The value for notes
     * @return {@code this} builder for chained invocation
     */
    public final Builder notes(String notes) {
      this.notes = Optional.of(notes);
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getNotes() notes} to notes.
     * @param notes The value for notes
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder notes(Optional<String> notes) {
      this.notes = Preconditions.checkNotNull(notes, "notes");
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getOutput() output} to output.
     * @param output The value for output
     * @return {@code this} builder for chained invocation
     */
    public final Builder output(String output) {
      this.output = Optional.of(output);
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getOutput() output} to output.
     * @param output The value for output
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder output(Optional<String> output) {
      this.output = Preconditions.checkNotNull(output, "output");
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getScript() script} to script.
     * @param script The value for script
     * @return {@code this} builder for chained invocation
     */
    public final Builder script(String script) {
      this.script = Optional.of(script);
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getScript() script} to script.
     * @param script The value for script
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder script(Optional<String> script) {
      this.script = Preconditions.checkNotNull(script, "script");
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getInterval() interval} to interval.
     * @param interval The value for interval
     * @return {@code this} builder for chained invocation
     */
    public final Builder interval(String interval) {
      this.interval = Optional.of(interval);
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getInterval() interval} to interval.
     * @param interval The value for interval
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder interval(Optional<String> interval) {
      this.interval = Preconditions.checkNotNull(interval, "interval");
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getTtl() ttl} to ttl.
     * @param ttl The value for ttl
     * @return {@code this} builder for chained invocation
     */
    public final Builder ttl(String ttl) {
      this.ttl = Optional.of(ttl);
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getTtl() ttl} to ttl.
     * @param ttl The value for ttl
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ttl(Optional<String> ttl) {
      this.ttl = Preconditions.checkNotNull(ttl, "ttl");
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getHttp() http} to http.
     * @param http The value for http
     * @return {@code this} builder for chained invocation
     */
    public final Builder http(String http) {
      this.http = Optional.of(http);
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getHttp() http} to http.
     * @param http The value for http
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder http(Optional<String> http) {
      this.http = Preconditions.checkNotNull(http, "http");
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getTcp() tcp} to tcp.
     * @param tcp The value for tcp
     * @return {@code this} builder for chained invocation
     */
    public final Builder tcp(String tcp) {
      this.tcp = Optional.of(tcp);
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getTcp() tcp} to tcp.
     * @param tcp The value for tcp
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tcp(Optional<String> tcp) {
      this.tcp = Preconditions.checkNotNull(tcp, "tcp");
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getServiceId() serviceId} to serviceId.
     * @param serviceId The value for serviceId
     * @return {@code this} builder for chained invocation
     */
    public final Builder serviceId(String serviceId) {
      this.serviceId = Optional.of(serviceId);
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getServiceId() serviceId} to serviceId.
     * @param serviceId The value for serviceId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceId(Optional<String> serviceId) {
      this.serviceId = Preconditions.checkNotNull(serviceId, "serviceId");
      return this;
    }

    /**
     * Builds a new {@link ImmutableCheck ImmutableCheck}.
     * @return An immutable instance of Check
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCheck build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return ImmutableCheck.validate(new ImmutableCheck(id, name, notes, output, script, interval, ttl, http, tcp, serviceId));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build Check, some of required attributes are not set " + attributes;
    }
  }
}
