package com.orbitz.consul.model.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link Template}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTemplate.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "Template"})
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableTemplate extends Template {
  private final String type;
  private final Optional<String> regExp;

  private ImmutableTemplate(String type, Optional<String> regExp) {
    this.type = type;
    this.regExp = regExp;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty(value = "Type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code regExp} attribute
   */
  @JsonProperty(value = "RegExp")
  @Override
  public Optional<String> getRegExp() {
    return regExp;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Template#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTemplate withType(String value) {
    if (this.type.equals(value)) return this;
    return new ImmutableTemplate(Preconditions.checkNotNull(value, "type"), this.regExp);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Template#getRegExp() regExp} attribute.
   * @param value The value for regExp
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTemplate withRegExp(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.regExp.equals(newValue)) return this;
    return new ImmutableTemplate(this.type, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Template#getRegExp() regExp} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for regExp
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTemplate withRegExp(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "regExp");
    if (this.regExp.equals(value)) return this;
    return new ImmutableTemplate(this.type, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTemplate} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTemplate
        && equalTo((ImmutableTemplate) another);
  }

  private boolean equalTo(ImmutableTemplate another) {
    return type.equals(another.type)
        && regExp.equals(another.regExp);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code regExp}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + type.hashCode();
    h = h * 17 + regExp.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Template} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Template")
        .omitNullValues()
        .add("type", type)
        .add("regExp", regExp.orNull())
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends Template {
    String type;
    Optional<String> regExp = Optional.absent();
    @JsonProperty(value = "Type")
    public void setType(String type) {
      this.type = type;
    }
    @JsonProperty(value = "RegExp")
    public void setRegExp(Optional<String> regExp) {
      this.regExp = regExp;
    }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getRegExp() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableTemplate fromJson(Json json) {
    ImmutableTemplate.Builder builder = ImmutableTemplate.builder();
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.regExp != null) {
      builder.regExp(json.regExp);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Template} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Template instance
   */
  public static ImmutableTemplate copyOf(Template instance) {
    if (instance instanceof ImmutableTemplate) {
      return (ImmutableTemplate) instance;
    }
    return ImmutableTemplate.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTemplate ImmutableTemplate}.
   * @return A new ImmutableTemplate builder
   */
  public static ImmutableTemplate.Builder builder() {
    return new ImmutableTemplate.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTemplate ImmutableTemplate}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private long initBits = 0x1;

    private String type;
    private Optional<String> regExp = Optional.absent();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Template} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Template instance) {
      Preconditions.checkNotNull(instance, "instance");
      type(instance.getType());
      Optional<String> regExpOptional = instance.getRegExp();
      if (regExpOptional.isPresent()) {
        regExp(regExpOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Template#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(String type) {
      this.type = Preconditions.checkNotNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the optional value {@link Template#getRegExp() regExp} to regExp.
     * @param regExp The value for regExp
     * @return {@code this} builder for chained invocation
     */
    public final Builder regExp(String regExp) {
      this.regExp = Optional.of(regExp);
      return this;
    }

    /**
     * Initializes the optional value {@link Template#getRegExp() regExp} to regExp.
     * @param regExp The value for regExp
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder regExp(Optional<String> regExp) {
      this.regExp = Preconditions.checkNotNull(regExp, "regExp");
      return this;
    }

    /**
     * Builds a new {@link ImmutableTemplate ImmutableTemplate}.
     * @return An immutable instance of Template
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTemplate build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTemplate(type, regExp);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build Template, some of required attributes are not set " + attributes;
    }
  }
}
