package com.orbitz.consul.model.kv;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.orbitz.consul.util.UnsignedLongDeserializer;
import java.util.List;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link Value}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableValue.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "Value"})
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableValue extends Value {
  private final long createIndex;
  private final long modifyIndex;
  private final long lockIndex;
  private final String key;
  private final long flags;
  private final Optional<String> value;
  private final Optional<String> session;

  private ImmutableValue(
      long createIndex,
      long modifyIndex,
      long lockIndex,
      String key,
      long flags,
      Optional<String> value,
      Optional<String> session) {
    this.createIndex = createIndex;
    this.modifyIndex = modifyIndex;
    this.lockIndex = lockIndex;
    this.key = key;
    this.flags = flags;
    this.value = value;
    this.session = session;
  }

  /**
   * @return The value of the {@code createIndex} attribute
   */
  @JsonProperty(value = "CreateIndex")
  @Override
  public long getCreateIndex() {
    return createIndex;
  }

  /**
   * @return The value of the {@code modifyIndex} attribute
   */
  @JsonProperty(value = "ModifyIndex")
  @Override
  public long getModifyIndex() {
    return modifyIndex;
  }

  /**
   * @return The value of the {@code lockIndex} attribute
   */
  @JsonProperty(value = "LockIndex")
  @Override
  public long getLockIndex() {
    return lockIndex;
  }

  /**
   * @return The value of the {@code key} attribute
   */
  @JsonProperty(value = "Key")
  @Override
  public String getKey() {
    return key;
  }

  /**
   * @return The value of the {@code flags} attribute
   */
  @JsonProperty(value = "Flags")
  @JsonDeserialize(using = UnsignedLongDeserializer.class)
  @Override
  public long getFlags() {
    return flags;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty(value = "Value")
  @Override
  public Optional<String> getValue() {
    return value;
  }

  /**
   * @return The value of the {@code session} attribute
   */
  @JsonProperty(value = "Session")
  @Override
  public Optional<String> getSession() {
    return session;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Value#getCreateIndex() createIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableValue withCreateIndex(long value) {
    if (this.createIndex == value) return this;
    return new ImmutableValue(value, this.modifyIndex, this.lockIndex, this.key, this.flags, this.value, this.session);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Value#getModifyIndex() modifyIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for modifyIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableValue withModifyIndex(long value) {
    if (this.modifyIndex == value) return this;
    return new ImmutableValue(this.createIndex, value, this.lockIndex, this.key, this.flags, this.value, this.session);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Value#getLockIndex() lockIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for lockIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableValue withLockIndex(long value) {
    if (this.lockIndex == value) return this;
    return new ImmutableValue(this.createIndex, this.modifyIndex, value, this.key, this.flags, this.value, this.session);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Value#getKey() key} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for key
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableValue withKey(String value) {
    if (this.key.equals(value)) return this;
    return new ImmutableValue(
        this.createIndex,
        this.modifyIndex,
        this.lockIndex,
        Preconditions.checkNotNull(value, "key"),
        this.flags,
        this.value,
        this.session);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Value#getFlags() flags} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for flags
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableValue withFlags(long value) {
    if (this.flags == value) return this;
    return new ImmutableValue(this.createIndex, this.modifyIndex, this.lockIndex, this.key, value, this.value, this.session);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Value#getValue() value} attribute.
   * @param value The value for value
   * @return A modified copy of {@code this} object
   */
  public final ImmutableValue withValue(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.value.equals(newValue)) return this;
    return new ImmutableValue(
        this.createIndex,
        this.modifyIndex,
        this.lockIndex,
        this.key,
        this.flags,
        newValue,
        this.session);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Value#getValue() value} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for value
   * @return A modified copy of {@code this} object
   */
  public final ImmutableValue withValue(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "value");
    if (this.value.equals(value)) return this;
    return new ImmutableValue(this.createIndex, this.modifyIndex, this.lockIndex, this.key, this.flags, value, this.session);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Value#getSession() session} attribute.
   * @param value The value for session
   * @return A modified copy of {@code this} object
   */
  public final ImmutableValue withSession(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.session.equals(newValue)) return this;
    return new ImmutableValue(this.createIndex, this.modifyIndex, this.lockIndex, this.key, this.flags, this.value, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Value#getSession() session} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for session
   * @return A modified copy of {@code this} object
   */
  public final ImmutableValue withSession(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "session");
    if (this.session.equals(value)) return this;
    return new ImmutableValue(this.createIndex, this.modifyIndex, this.lockIndex, this.key, this.flags, this.value, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableValue
        && equalTo((ImmutableValue) another);
  }

  private boolean equalTo(ImmutableValue another) {
    return createIndex == another.createIndex
        && modifyIndex == another.modifyIndex
        && lockIndex == another.lockIndex
        && key.equals(another.key)
        && flags == another.flags
        && value.equals(another.value)
        && session.equals(another.session);
  }

  /**
   * Computes a hash code from attributes: {@code createIndex}, {@code modifyIndex}, {@code lockIndex}, {@code key}, {@code flags}, {@code value}, {@code session}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Longs.hashCode(createIndex);
    h = h * 17 + Longs.hashCode(modifyIndex);
    h = h * 17 + Longs.hashCode(lockIndex);
    h = h * 17 + key.hashCode();
    h = h * 17 + Longs.hashCode(flags);
    h = h * 17 + value.hashCode();
    h = h * 17 + session.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Value} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Value")
        .omitNullValues()
        .add("createIndex", createIndex)
        .add("modifyIndex", modifyIndex)
        .add("lockIndex", lockIndex)
        .add("key", key)
        .add("flags", flags)
        .add("value", value.orNull())
        .add("session", session.orNull())
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends Value {
    Long createIndex;
    Long modifyIndex;
    Long lockIndex;
    String key;
    Long flags;
    Optional<String> value = Optional.absent();
    Optional<String> session = Optional.absent();
    @JsonProperty(value = "CreateIndex")
    public void setCreateIndex(long createIndex) {
      this.createIndex = createIndex;
    }
    @JsonProperty(value = "ModifyIndex")
    public void setModifyIndex(long modifyIndex) {
      this.modifyIndex = modifyIndex;
    }
    @JsonProperty(value = "LockIndex")
    public void setLockIndex(long lockIndex) {
      this.lockIndex = lockIndex;
    }
    @JsonProperty(value = "Key")
    public void setKey(String key) {
      this.key = key;
    }
    @JsonProperty(value = "Flags")
    @JsonDeserialize(using = UnsignedLongDeserializer.class)
    public void setFlags(long flags) {
      this.flags = flags;
    }
    @JsonProperty(value = "Value")
    public void setValue(Optional<String> value) {
      this.value = value;
    }
    @JsonProperty(value = "Session")
    public void setSession(Optional<String> session) {
      this.session = session;
    }
    @Override
    public long getCreateIndex() { throw new UnsupportedOperationException(); }
    @Override
    public long getModifyIndex() { throw new UnsupportedOperationException(); }
    @Override
    public long getLockIndex() { throw new UnsupportedOperationException(); }
    @Override
    public String getKey() { throw new UnsupportedOperationException(); }
    @Override
    public long getFlags() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getValue() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getSession() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getValueAsString() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableValue fromJson(Json json) {
    ImmutableValue.Builder builder = ImmutableValue.builder();
    if (json.createIndex != null) {
      builder.createIndex(json.createIndex);
    }
    if (json.modifyIndex != null) {
      builder.modifyIndex(json.modifyIndex);
    }
    if (json.lockIndex != null) {
      builder.lockIndex(json.lockIndex);
    }
    if (json.key != null) {
      builder.key(json.key);
    }
    if (json.flags != null) {
      builder.flags(json.flags);
    }
    if (json.value != null) {
      builder.value(json.value);
    }
    if (json.session != null) {
      builder.session(json.session);
    }
    return builder.build();
  }

  private volatile long lazyInitBitmap;

  private static final long VALUE_AS_STRING_LAZY_INIT_BIT = 0x1L;

  private Optional<String> valueAsString;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Value#getValueAsString() valueAsString} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * @return A lazily initialized value of the {@code l.name} attribute
   */
  @Override
  public Optional<String> getValueAsString() {
    if ((lazyInitBitmap & VALUE_AS_STRING_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & VALUE_AS_STRING_LAZY_INIT_BIT) == 0) {
          this.valueAsString = Preconditions.checkNotNull(super.getValueAsString(), "valueAsString");
          lazyInitBitmap |= VALUE_AS_STRING_LAZY_INIT_BIT;
        }
      }
    }
    return valueAsString;
  }

  /**
   * Creates an immutable copy of a {@link Value} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Value instance
   */
  public static ImmutableValue copyOf(Value instance) {
    if (instance instanceof ImmutableValue) {
      return (ImmutableValue) instance;
    }
    return ImmutableValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableValue ImmutableValue}.
   * @return A new ImmutableValue builder
   */
  public static ImmutableValue.Builder builder() {
    return new ImmutableValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableValue ImmutableValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_CREATE_INDEX = 0x1L;
    private static final long INIT_BIT_MODIFY_INDEX = 0x2L;
    private static final long INIT_BIT_LOCK_INDEX = 0x4L;
    private static final long INIT_BIT_KEY = 0x8L;
    private static final long INIT_BIT_FLAGS = 0x10L;
    private long initBits = 0x1f;

    private long createIndex;
    private long modifyIndex;
    private long lockIndex;
    private String key;
    private long flags;
    private Optional<String> value = Optional.absent();
    private Optional<String> session = Optional.absent();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Value} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Value instance) {
      Preconditions.checkNotNull(instance, "instance");
      createIndex(instance.getCreateIndex());
      modifyIndex(instance.getModifyIndex());
      lockIndex(instance.getLockIndex());
      key(instance.getKey());
      flags(instance.getFlags());
      Optional<String> valueOptional = instance.getValue();
      if (valueOptional.isPresent()) {
        value(valueOptional);
      }
      Optional<String> sessionOptional = instance.getSession();
      if (sessionOptional.isPresent()) {
        session(sessionOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Value#getCreateIndex() createIndex} attribute.
     * @param createIndex The value for createIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder createIndex(long createIndex) {
      this.createIndex = createIndex;
      initBits &= ~INIT_BIT_CREATE_INDEX;
      return this;
    }

    /**
     * Initializes the value for the {@link Value#getModifyIndex() modifyIndex} attribute.
     * @param modifyIndex The value for modifyIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder modifyIndex(long modifyIndex) {
      this.modifyIndex = modifyIndex;
      initBits &= ~INIT_BIT_MODIFY_INDEX;
      return this;
    }

    /**
     * Initializes the value for the {@link Value#getLockIndex() lockIndex} attribute.
     * @param lockIndex The value for lockIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder lockIndex(long lockIndex) {
      this.lockIndex = lockIndex;
      initBits &= ~INIT_BIT_LOCK_INDEX;
      return this;
    }

    /**
     * Initializes the value for the {@link Value#getKey() key} attribute.
     * @param key The value for key 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder key(String key) {
      this.key = Preconditions.checkNotNull(key, "key");
      initBits &= ~INIT_BIT_KEY;
      return this;
    }

    /**
     * Initializes the value for the {@link Value#getFlags() flags} attribute.
     * @param flags The value for flags 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder flags(long flags) {
      this.flags = flags;
      initBits &= ~INIT_BIT_FLAGS;
      return this;
    }

    /**
     * Initializes the optional value {@link Value#getValue() value} to value.
     * @param value The value for value
     * @return {@code this} builder for chained invocation
     */
    public final Builder value(String value) {
      this.value = Optional.of(value);
      return this;
    }

    /**
     * Initializes the optional value {@link Value#getValue() value} to value.
     * @param value The value for value
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder value(Optional<String> value) {
      this.value = Preconditions.checkNotNull(value, "value");
      return this;
    }

    /**
     * Initializes the optional value {@link Value#getSession() session} to session.
     * @param session The value for session
     * @return {@code this} builder for chained invocation
     */
    public final Builder session(String session) {
      this.session = Optional.of(session);
      return this;
    }

    /**
     * Initializes the optional value {@link Value#getSession() session} to session.
     * @param session The value for session
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder session(Optional<String> session) {
      this.session = Preconditions.checkNotNull(session, "session");
      return this;
    }

    /**
     * Builds a new {@link ImmutableValue ImmutableValue}.
     * @return An immutable instance of Value
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableValue build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableValue(createIndex, modifyIndex, lockIndex, key, flags, value, session);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_CREATE_INDEX) != 0) attributes.add("createIndex");
      if ((initBits & INIT_BIT_MODIFY_INDEX) != 0) attributes.add("modifyIndex");
      if ((initBits & INIT_BIT_LOCK_INDEX) != 0) attributes.add("lockIndex");
      if ((initBits & INIT_BIT_KEY) != 0) attributes.add("key");
      if ((initBits & INIT_BIT_FLAGS) != 0) attributes.add("flags");
      return "Cannot build Value, some of required attributes are not set " + attributes;
    }
  }
}
