package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import java.util.List;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link Config}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableConfig.builder()}.
 */
@SuppressWarnings({"all", "deprecation"})
@Generated({"Immutables.generator", "Config"})
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableConfig extends Config {
  private final boolean bootstrap;
  private final boolean server;
  private final String datacenter;
  private final String dataDir;
  private final String dnsRecursor;
  private final String domain;
  private final String logLevel;
  private final String nodeName;
  private final String clientAddr;
  private final String bindAddr;
  private final String advertiseAddr;
  private final Ports ports;
  private final boolean leaveOnTerm;
  private final boolean skipLeaveOnInt;
  private final Optional<String> statsiteAddr;
  private final int protocol;
  private final boolean enableDebug;
  private final boolean verifyIncoming;
  private final boolean verifyOutgoing;
  private final String caFile;
  private final String certFile;
  private final String keyFile;
  private final ImmutableList<String> startJoin;
  private final String uiDir;
  private final String pidFile;
  private final boolean enableSyslog;
  private final boolean rejoinAfterLeave;
  private final Optional<Telemetry> telemetry;

  private ImmutableConfig(
      boolean bootstrap,
      boolean server,
      String datacenter,
      String dataDir,
      String dnsRecursor,
      String domain,
      String logLevel,
      String nodeName,
      String clientAddr,
      String bindAddr,
      String advertiseAddr,
      Ports ports,
      boolean leaveOnTerm,
      boolean skipLeaveOnInt,
      Optional<String> statsiteAddr,
      int protocol,
      boolean enableDebug,
      boolean verifyIncoming,
      boolean verifyOutgoing,
      String caFile,
      String certFile,
      String keyFile,
      ImmutableList<String> startJoin,
      String uiDir,
      String pidFile,
      boolean enableSyslog,
      boolean rejoinAfterLeave,
      Optional<Telemetry> telemetry) {
    this.bootstrap = bootstrap;
    this.server = server;
    this.datacenter = datacenter;
    this.dataDir = dataDir;
    this.dnsRecursor = dnsRecursor;
    this.domain = domain;
    this.logLevel = logLevel;
    this.nodeName = nodeName;
    this.clientAddr = clientAddr;
    this.bindAddr = bindAddr;
    this.advertiseAddr = advertiseAddr;
    this.ports = ports;
    this.leaveOnTerm = leaveOnTerm;
    this.skipLeaveOnInt = skipLeaveOnInt;
    this.statsiteAddr = statsiteAddr;
    this.protocol = protocol;
    this.enableDebug = enableDebug;
    this.verifyIncoming = verifyIncoming;
    this.verifyOutgoing = verifyOutgoing;
    this.caFile = caFile;
    this.certFile = certFile;
    this.keyFile = keyFile;
    this.startJoin = startJoin;
    this.uiDir = uiDir;
    this.pidFile = pidFile;
    this.enableSyslog = enableSyslog;
    this.rejoinAfterLeave = rejoinAfterLeave;
    this.telemetry = telemetry;
  }

  /**
   * @return The value of the {@code bootstrap} attribute
   */
  @JsonProperty(value = "Bootstrap")
  @Override
  public boolean getBootstrap() {
    return bootstrap;
  }

  /**
   * @return The value of the {@code server} attribute
   */
  @JsonProperty(value = "Server")
  @Override
  public boolean getServer() {
    return server;
  }

  /**
   * @return The value of the {@code datacenter} attribute
   */
  @JsonProperty(value = "Datacenter")
  @Override
  public String getDatacenter() {
    return datacenter;
  }

  /**
   * @return The value of the {@code dataDir} attribute
   */
  @JsonProperty(value = "DataDir")
  @Override
  public String getDataDir() {
    return dataDir;
  }

  /**
   * @return The value of the {@code dnsRecursor} attribute
   */
  @JsonProperty(value = "DNSRecursor")
  @Override
  public String dnsRecursor() {
    return dnsRecursor;
  }

  /**
   * @return The value of the {@code domain} attribute
   */
  @JsonProperty(value = "Domain")
  @Override
  public String getDomain() {
    return domain;
  }

  /**
   * @return The value of the {@code logLevel} attribute
   */
  @JsonProperty(value = "LogLevel")
  @Override
  public String getLogLevel() {
    return logLevel;
  }

  /**
   * @return The value of the {@code nodeName} attribute
   */
  @JsonProperty(value = "NodeName")
  @Override
  public String getNodeName() {
    return nodeName;
  }

  /**
   * @return The value of the {@code clientAddr} attribute
   */
  @JsonProperty(value = "ClientAddr")
  @Override
  public String getClientAddr() {
    return clientAddr;
  }

  /**
   * @return The value of the {@code bindAddr} attribute
   */
  @JsonProperty(value = "BindAddr")
  @Override
  public String getBindAddr() {
    return bindAddr;
  }

  /**
   * @return The value of the {@code advertiseAddr} attribute
   */
  @JsonProperty(value = "AdvertiseAddr")
  @Override
  public String getAdvertiseAddr() {
    return advertiseAddr;
  }

  /**
   * @return The value of the {@code ports} attribute
   */
  @JsonProperty(value = "Ports")
  @Override
  public Ports getPorts() {
    return ports;
  }

  /**
   * @return The value of the {@code leaveOnTerm} attribute
   */
  @JsonProperty(value = "LeaveOnTerm")
  @Override
  public boolean getLeaveOnTerm() {
    return leaveOnTerm;
  }

  /**
   * @return The value of the {@code skipLeaveOnInt} attribute
   */
  @JsonProperty(value = "SkipLeaveOnInt")
  @Override
  public boolean getSkipLeaveOnInt() {
    return skipLeaveOnInt;
  }

  /**
   * @deprecated GET /v1/agent/self from v0.6.4 does not have this JSON field
   */
  @JsonProperty(value = "StatsiteAddr")
  @Deprecated
  @Override
  public Optional<String> getStatsiteAddr() {
    return statsiteAddr;
  }

  /**
   * @return The value of the {@code protocol} attribute
   */
  @JsonProperty(value = "Protocol")
  @Override
  public int getProtocol() {
    return protocol;
  }

  /**
   * @return The value of the {@code enableDebug} attribute
   */
  @JsonProperty(value = "EnableDebug")
  @Override
  public boolean getEnableDebug() {
    return enableDebug;
  }

  /**
   * @return The value of the {@code verifyIncoming} attribute
   */
  @JsonProperty(value = "VerifyIncoming")
  @Override
  public boolean getVerifyIncoming() {
    return verifyIncoming;
  }

  /**
   * @return The value of the {@code verifyOutgoing} attribute
   */
  @JsonProperty(value = "VerifyOutgoing")
  @Override
  public boolean getVerifyOutgoing() {
    return verifyOutgoing;
  }

  /**
   * @return The value of the {@code caFile} attribute
   */
  @JsonProperty(value = "CAFile")
  @Override
  public String getCaFile() {
    return caFile;
  }

  /**
   * @return The value of the {@code certFile} attribute
   */
  @JsonProperty(value = "CertFile")
  @Override
  public String getCertFile() {
    return certFile;
  }

  /**
   * @return The value of the {@code keyFile} attribute
   */
  @JsonProperty(value = "KeyFile")
  @Override
  public String getKeyFile() {
    return keyFile;
  }

  /**
   * @return The value of the {@code startJoin} attribute
   */
  @JsonProperty(value = "StartJoin")
  @JsonDeserialize(as = ImmutableList.class, contentAs = String.class)
  @Override
  public ImmutableList<String> getStartJoin() {
    return startJoin;
  }

  /**
   * @return The value of the {@code uiDir} attribute
   */
  @JsonProperty(value = "UiDir")
  @Override
  public String getUiDir() {
    return uiDir;
  }

  /**
   * @return The value of the {@code pidFile} attribute
   */
  @JsonProperty(value = "PidFile")
  @Override
  public String getPidFile() {
    return pidFile;
  }

  /**
   * @return The value of the {@code enableSyslog} attribute
   */
  @JsonProperty(value = "EnableSyslog")
  @Override
  public boolean getEnableSyslog() {
    return enableSyslog;
  }

  /**
   * @return The value of the {@code rejoinAfterLeave} attribute
   */
  @JsonProperty(value = "RejoinAfterLeave")
  @Override
  public boolean getRejoinAfterLeave() {
    return rejoinAfterLeave;
  }

  /**
   * New version of consul has Telemetry field
   * TODO: Have to think about back compatibility (I think we shouldn't)
   */
  @JsonProperty(value = "Telemetry")
  @Override
  public Optional<Telemetry> getTelemetry() {
    return telemetry;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#getBootstrap() bootstrap} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bootstrap
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withBootstrap(boolean value) {
    if (this.bootstrap == value) return this;
    return new ImmutableConfig(
        value,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.telemetry);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#getServer() server} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for server
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withServer(boolean value) {
    if (this.server == value) return this;
    return new ImmutableConfig(
        this.bootstrap,
        value,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.telemetry);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#getDatacenter() datacenter} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for datacenter
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withDatacenter(String value) {
    if (this.datacenter.equals(value)) return this;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        Preconditions.checkNotNull(value, "datacenter"),
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.telemetry);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#getDataDir() dataDir} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dataDir
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withDataDir(String value) {
    if (this.dataDir.equals(value)) return this;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        Preconditions.checkNotNull(value, "dataDir"),
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.telemetry);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#dnsRecursor() dnsRecursor} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dnsRecursor
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withDnsRecursor(String value) {
    if (this.dnsRecursor.equals(value)) return this;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        Preconditions.checkNotNull(value, "dnsRecursor"),
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.telemetry);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#getDomain() domain} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for domain
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withDomain(String value) {
    if (this.domain.equals(value)) return this;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        Preconditions.checkNotNull(value, "domain"),
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.telemetry);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#getLogLevel() logLevel} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for logLevel
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withLogLevel(String value) {
    if (this.logLevel.equals(value)) return this;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        Preconditions.checkNotNull(value, "logLevel"),
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.telemetry);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#getNodeName() nodeName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nodeName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withNodeName(String value) {
    if (this.nodeName.equals(value)) return this;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        Preconditions.checkNotNull(value, "nodeName"),
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.telemetry);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#getClientAddr() clientAddr} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clientAddr
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withClientAddr(String value) {
    if (this.clientAddr.equals(value)) return this;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        Preconditions.checkNotNull(value, "clientAddr"),
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.telemetry);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#getBindAddr() bindAddr} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bindAddr
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withBindAddr(String value) {
    if (this.bindAddr.equals(value)) return this;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        Preconditions.checkNotNull(value, "bindAddr"),
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.telemetry);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#getAdvertiseAddr() advertiseAddr} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for advertiseAddr
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withAdvertiseAddr(String value) {
    if (this.advertiseAddr.equals(value)) return this;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        Preconditions.checkNotNull(value, "advertiseAddr"),
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.telemetry);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#getPorts() ports} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ports
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withPorts(Ports value) {
    if (this.ports == value) return this;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        Preconditions.checkNotNull(value, "ports"),
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.telemetry);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#getLeaveOnTerm() leaveOnTerm} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for leaveOnTerm
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withLeaveOnTerm(boolean value) {
    if (this.leaveOnTerm == value) return this;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        value,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.telemetry);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#getSkipLeaveOnInt() skipLeaveOnInt} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for skipLeaveOnInt
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withSkipLeaveOnInt(boolean value) {
    if (this.skipLeaveOnInt == value) return this;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        value,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.telemetry);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Config#getStatsiteAddr() statsiteAddr} attribute.
   * @param value The value for statsiteAddr
   * @return A modified copy of {@code this} object
   */
  @Deprecated
  public final ImmutableConfig withStatsiteAddr(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.statsiteAddr.equals(newValue)) return this;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        newValue,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.telemetry);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Config#getStatsiteAddr() statsiteAddr} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for statsiteAddr
   * @return A modified copy of {@code this} object
   */
  @Deprecated
  public final ImmutableConfig withStatsiteAddr(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "statsiteAddr");
    if (this.statsiteAddr.equals(value)) return this;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        value,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.telemetry);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#getProtocol() protocol} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for protocol
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withProtocol(int value) {
    if (this.protocol == value) return this;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        value,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.telemetry);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#getEnableDebug() enableDebug} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for enableDebug
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withEnableDebug(boolean value) {
    if (this.enableDebug == value) return this;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        value,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.telemetry);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#getVerifyIncoming() verifyIncoming} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for verifyIncoming
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withVerifyIncoming(boolean value) {
    if (this.verifyIncoming == value) return this;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        value,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.telemetry);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#getVerifyOutgoing() verifyOutgoing} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for verifyOutgoing
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withVerifyOutgoing(boolean value) {
    if (this.verifyOutgoing == value) return this;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        value,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.telemetry);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#getCaFile() caFile} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for caFile
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withCaFile(String value) {
    if (this.caFile.equals(value)) return this;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        Preconditions.checkNotNull(value, "caFile"),
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.telemetry);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#getCertFile() certFile} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for certFile
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withCertFile(String value) {
    if (this.certFile.equals(value)) return this;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        Preconditions.checkNotNull(value, "certFile"),
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.telemetry);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#getKeyFile() keyFile} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for keyFile
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withKeyFile(String value) {
    if (this.keyFile.equals(value)) return this;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        Preconditions.checkNotNull(value, "keyFile"),
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.telemetry);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Config#getStartJoin() startJoin}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableConfig withStartJoin(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        newValue,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.telemetry);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Config#getStartJoin() startJoin}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of startJoin elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableConfig withStartJoin(Iterable<String> elements) {
    if (this.startJoin == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        newValue,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.telemetry);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#getUiDir() uiDir} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for uiDir
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withUiDir(String value) {
    if (this.uiDir.equals(value)) return this;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        Preconditions.checkNotNull(value, "uiDir"),
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.telemetry);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#getPidFile() pidFile} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pidFile
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withPidFile(String value) {
    if (this.pidFile.equals(value)) return this;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        Preconditions.checkNotNull(value, "pidFile"),
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.telemetry);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#getEnableSyslog() enableSyslog} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for enableSyslog
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withEnableSyslog(boolean value) {
    if (this.enableSyslog == value) return this;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        value,
        this.rejoinAfterLeave,
        this.telemetry);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#getRejoinAfterLeave() rejoinAfterLeave} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rejoinAfterLeave
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withRejoinAfterLeave(boolean value) {
    if (this.rejoinAfterLeave == value) return this;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        value,
        this.telemetry);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Config#getTelemetry() telemetry} attribute.
   * @param value The value for telemetry
   * @return A modified copy of {@code this} object
   */
  public final ImmutableConfig withTelemetry(Telemetry value) {
    Optional<Telemetry> newValue = Optional.of(value);
    if (this.telemetry.isPresent() && this.telemetry.get() == value) return this;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Config#getTelemetry() telemetry} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for telemetry
   * @return A modified copy of {@code this} object
   */
  public final ImmutableConfig withTelemetry(Optional<Telemetry> optional) {
    Optional<Telemetry> value = Preconditions.checkNotNull(optional, "telemetry");
    if (!this.telemetry.isPresent() && !value.isPresent()) return this;
    if (this.telemetry.isPresent() && value.isPresent() && this.telemetry.get() == value.get()) return this;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableConfig
        && equalTo((ImmutableConfig) another);
  }

  private boolean equalTo(ImmutableConfig another) {
    return bootstrap == another.bootstrap
        && server == another.server
        && datacenter.equals(another.datacenter)
        && dataDir.equals(another.dataDir)
        && dnsRecursor.equals(another.dnsRecursor)
        && domain.equals(another.domain)
        && logLevel.equals(another.logLevel)
        && nodeName.equals(another.nodeName)
        && clientAddr.equals(another.clientAddr)
        && bindAddr.equals(another.bindAddr)
        && advertiseAddr.equals(another.advertiseAddr)
        && ports.equals(another.ports)
        && leaveOnTerm == another.leaveOnTerm
        && skipLeaveOnInt == another.skipLeaveOnInt
        && statsiteAddr.equals(another.statsiteAddr)
        && protocol == another.protocol
        && enableDebug == another.enableDebug
        && verifyIncoming == another.verifyIncoming
        && verifyOutgoing == another.verifyOutgoing
        && caFile.equals(another.caFile)
        && certFile.equals(another.certFile)
        && keyFile.equals(another.keyFile)
        && startJoin.equals(another.startJoin)
        && uiDir.equals(another.uiDir)
        && pidFile.equals(another.pidFile)
        && enableSyslog == another.enableSyslog
        && rejoinAfterLeave == another.rejoinAfterLeave
        && telemetry.equals(another.telemetry);
  }

  /**
   * Computes a hash code from attributes: {@code bootstrap}, {@code server}, {@code datacenter}, {@code dataDir}, {@code dnsRecursor}, {@code domain}, {@code logLevel}, {@code nodeName}, {@code clientAddr}, {@code bindAddr}, {@code advertiseAddr}, {@code ports}, {@code leaveOnTerm}, {@code skipLeaveOnInt}, {@code statsiteAddr}, {@code protocol}, {@code enableDebug}, {@code verifyIncoming}, {@code verifyOutgoing}, {@code caFile}, {@code certFile}, {@code keyFile}, {@code startJoin}, {@code uiDir}, {@code pidFile}, {@code enableSyslog}, {@code rejoinAfterLeave}, {@code telemetry}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Booleans.hashCode(bootstrap);
    h = h * 17 + Booleans.hashCode(server);
    h = h * 17 + datacenter.hashCode();
    h = h * 17 + dataDir.hashCode();
    h = h * 17 + dnsRecursor.hashCode();
    h = h * 17 + domain.hashCode();
    h = h * 17 + logLevel.hashCode();
    h = h * 17 + nodeName.hashCode();
    h = h * 17 + clientAddr.hashCode();
    h = h * 17 + bindAddr.hashCode();
    h = h * 17 + advertiseAddr.hashCode();
    h = h * 17 + ports.hashCode();
    h = h * 17 + Booleans.hashCode(leaveOnTerm);
    h = h * 17 + Booleans.hashCode(skipLeaveOnInt);
    h = h * 17 + statsiteAddr.hashCode();
    h = h * 17 + protocol;
    h = h * 17 + Booleans.hashCode(enableDebug);
    h = h * 17 + Booleans.hashCode(verifyIncoming);
    h = h * 17 + Booleans.hashCode(verifyOutgoing);
    h = h * 17 + caFile.hashCode();
    h = h * 17 + certFile.hashCode();
    h = h * 17 + keyFile.hashCode();
    h = h * 17 + startJoin.hashCode();
    h = h * 17 + uiDir.hashCode();
    h = h * 17 + pidFile.hashCode();
    h = h * 17 + Booleans.hashCode(enableSyslog);
    h = h * 17 + Booleans.hashCode(rejoinAfterLeave);
    h = h * 17 + telemetry.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Config} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Config")
        .omitNullValues()
        .add("bootstrap", bootstrap)
        .add("server", server)
        .add("datacenter", datacenter)
        .add("dataDir", dataDir)
        .add("dnsRecursor", dnsRecursor)
        .add("domain", domain)
        .add("logLevel", logLevel)
        .add("nodeName", nodeName)
        .add("clientAddr", clientAddr)
        .add("bindAddr", bindAddr)
        .add("advertiseAddr", advertiseAddr)
        .add("ports", ports)
        .add("leaveOnTerm", leaveOnTerm)
        .add("skipLeaveOnInt", skipLeaveOnInt)
        .add("statsiteAddr", statsiteAddr.orNull())
        .add("protocol", protocol)
        .add("enableDebug", enableDebug)
        .add("verifyIncoming", verifyIncoming)
        .add("verifyOutgoing", verifyOutgoing)
        .add("caFile", caFile)
        .add("certFile", certFile)
        .add("keyFile", keyFile)
        .add("startJoin", startJoin)
        .add("uiDir", uiDir)
        .add("pidFile", pidFile)
        .add("enableSyslog", enableSyslog)
        .add("rejoinAfterLeave", rejoinAfterLeave)
        .add("telemetry", telemetry.orNull())
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends Config {
    Boolean bootstrap;
    Boolean server;
    String datacenter;
    String dataDir;
    String dnsRecursor;
    String domain;
    String logLevel;
    String nodeName;
    String clientAddr;
    String bindAddr;
    String advertiseAddr;
    Ports ports;
    Boolean leaveOnTerm;
    Boolean skipLeaveOnInt;
    Optional<String> statsiteAddr = Optional.absent();
    Integer protocol;
    Boolean enableDebug;
    Boolean verifyIncoming;
    Boolean verifyOutgoing;
    String caFile;
    String certFile;
    String keyFile;
    List<String> startJoin = ImmutableList.of();
    String uiDir;
    String pidFile;
    Boolean enableSyslog;
    Boolean rejoinAfterLeave;
    Optional<Telemetry> telemetry = Optional.absent();
    @JsonProperty(value = "Bootstrap")
    public void setBootstrap(boolean bootstrap) {
      this.bootstrap = bootstrap;
    }
    @JsonProperty(value = "Server")
    public void setServer(boolean server) {
      this.server = server;
    }
    @JsonProperty(value = "Datacenter")
    public void setDatacenter(String datacenter) {
      this.datacenter = datacenter;
    }
    @JsonProperty(value = "DataDir")
    public void setDataDir(String dataDir) {
      this.dataDir = dataDir;
    }
    @JsonProperty(value = "DNSRecursor")
    public void setDnsRecursor(String dnsRecursor) {
      this.dnsRecursor = dnsRecursor;
    }
    @JsonProperty(value = "Domain")
    public void setDomain(String domain) {
      this.domain = domain;
    }
    @JsonProperty(value = "LogLevel")
    public void setLogLevel(String logLevel) {
      this.logLevel = logLevel;
    }
    @JsonProperty(value = "NodeName")
    public void setNodeName(String nodeName) {
      this.nodeName = nodeName;
    }
    @JsonProperty(value = "ClientAddr")
    public void setClientAddr(String clientAddr) {
      this.clientAddr = clientAddr;
    }
    @JsonProperty(value = "BindAddr")
    public void setBindAddr(String bindAddr) {
      this.bindAddr = bindAddr;
    }
    @JsonProperty(value = "AdvertiseAddr")
    public void setAdvertiseAddr(String advertiseAddr) {
      this.advertiseAddr = advertiseAddr;
    }
    @JsonProperty(value = "Ports")
    public void setPorts(Ports ports) {
      this.ports = ports;
    }
    @JsonProperty(value = "LeaveOnTerm")
    public void setLeaveOnTerm(boolean leaveOnTerm) {
      this.leaveOnTerm = leaveOnTerm;
    }
    @JsonProperty(value = "SkipLeaveOnInt")
    public void setSkipLeaveOnInt(boolean skipLeaveOnInt) {
      this.skipLeaveOnInt = skipLeaveOnInt;
    }
    @JsonProperty(value = "StatsiteAddr")
    public void setStatsiteAddr(Optional<String> statsiteAddr) {
      this.statsiteAddr = statsiteAddr;
    }
    @JsonProperty(value = "Protocol")
    public void setProtocol(int protocol) {
      this.protocol = protocol;
    }
    @JsonProperty(value = "EnableDebug")
    public void setEnableDebug(boolean enableDebug) {
      this.enableDebug = enableDebug;
    }
    @JsonProperty(value = "VerifyIncoming")
    public void setVerifyIncoming(boolean verifyIncoming) {
      this.verifyIncoming = verifyIncoming;
    }
    @JsonProperty(value = "VerifyOutgoing")
    public void setVerifyOutgoing(boolean verifyOutgoing) {
      this.verifyOutgoing = verifyOutgoing;
    }
    @JsonProperty(value = "CAFile")
    public void setCaFile(String caFile) {
      this.caFile = caFile;
    }
    @JsonProperty(value = "CertFile")
    public void setCertFile(String certFile) {
      this.certFile = certFile;
    }
    @JsonProperty(value = "KeyFile")
    public void setKeyFile(String keyFile) {
      this.keyFile = keyFile;
    }
    @JsonProperty(value = "StartJoin")
    @JsonDeserialize(as = ImmutableList.class, contentAs = String.class)
    public void setStartJoin(List<String> startJoin) {
      this.startJoin = startJoin;
    }
    @JsonProperty(value = "UiDir")
    public void setUiDir(String uiDir) {
      this.uiDir = uiDir;
    }
    @JsonProperty(value = "PidFile")
    public void setPidFile(String pidFile) {
      this.pidFile = pidFile;
    }
    @JsonProperty(value = "EnableSyslog")
    public void setEnableSyslog(boolean enableSyslog) {
      this.enableSyslog = enableSyslog;
    }
    @JsonProperty(value = "RejoinAfterLeave")
    public void setRejoinAfterLeave(boolean rejoinAfterLeave) {
      this.rejoinAfterLeave = rejoinAfterLeave;
    }
    @JsonProperty(value = "Telemetry")
    public void setTelemetry(Optional<Telemetry> telemetry) {
      this.telemetry = telemetry;
    }
    @Override
    public boolean getBootstrap() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getServer() { throw new UnsupportedOperationException(); }
    @Override
    public String getDatacenter() { throw new UnsupportedOperationException(); }
    @Override
    public String getDataDir() { throw new UnsupportedOperationException(); }
    @Override
    public String dnsRecursor() { throw new UnsupportedOperationException(); }
    @Override
    public String getDomain() { throw new UnsupportedOperationException(); }
    @Override
    public String getLogLevel() { throw new UnsupportedOperationException(); }
    @Override
    public String getNodeName() { throw new UnsupportedOperationException(); }
    @Override
    public String getClientAddr() { throw new UnsupportedOperationException(); }
    @Override
    public String getBindAddr() { throw new UnsupportedOperationException(); }
    @Override
    public String getAdvertiseAddr() { throw new UnsupportedOperationException(); }
    @Override
    public Ports getPorts() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getLeaveOnTerm() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getSkipLeaveOnInt() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getStatsiteAddr() { throw new UnsupportedOperationException(); }
    @Override
    public int getProtocol() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getEnableDebug() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getVerifyIncoming() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getVerifyOutgoing() { throw new UnsupportedOperationException(); }
    @Override
    public String getCaFile() { throw new UnsupportedOperationException(); }
    @Override
    public String getCertFile() { throw new UnsupportedOperationException(); }
    @Override
    public String getKeyFile() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getStartJoin() { throw new UnsupportedOperationException(); }
    @Override
    public String getUiDir() { throw new UnsupportedOperationException(); }
    @Override
    public String getPidFile() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getEnableSyslog() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getRejoinAfterLeave() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Telemetry> getTelemetry() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableConfig fromJson(Json json) {
    ImmutableConfig.Builder builder = ImmutableConfig.builder();
    if (json.bootstrap != null) {
      builder.bootstrap(json.bootstrap);
    }
    if (json.server != null) {
      builder.server(json.server);
    }
    if (json.datacenter != null) {
      builder.datacenter(json.datacenter);
    }
    if (json.dataDir != null) {
      builder.dataDir(json.dataDir);
    }
    if (json.dnsRecursor != null) {
      builder.dnsRecursor(json.dnsRecursor);
    }
    if (json.domain != null) {
      builder.domain(json.domain);
    }
    if (json.logLevel != null) {
      builder.logLevel(json.logLevel);
    }
    if (json.nodeName != null) {
      builder.nodeName(json.nodeName);
    }
    if (json.clientAddr != null) {
      builder.clientAddr(json.clientAddr);
    }
    if (json.bindAddr != null) {
      builder.bindAddr(json.bindAddr);
    }
    if (json.advertiseAddr != null) {
      builder.advertiseAddr(json.advertiseAddr);
    }
    if (json.ports != null) {
      builder.ports(json.ports);
    }
    if (json.leaveOnTerm != null) {
      builder.leaveOnTerm(json.leaveOnTerm);
    }
    if (json.skipLeaveOnInt != null) {
      builder.skipLeaveOnInt(json.skipLeaveOnInt);
    }
    if (json.statsiteAddr != null) {
      builder.statsiteAddr(json.statsiteAddr);
    }
    if (json.protocol != null) {
      builder.protocol(json.protocol);
    }
    if (json.enableDebug != null) {
      builder.enableDebug(json.enableDebug);
    }
    if (json.verifyIncoming != null) {
      builder.verifyIncoming(json.verifyIncoming);
    }
    if (json.verifyOutgoing != null) {
      builder.verifyOutgoing(json.verifyOutgoing);
    }
    if (json.caFile != null) {
      builder.caFile(json.caFile);
    }
    if (json.certFile != null) {
      builder.certFile(json.certFile);
    }
    if (json.keyFile != null) {
      builder.keyFile(json.keyFile);
    }
    if (json.startJoin != null) {
      builder.addAllStartJoin(json.startJoin);
    }
    if (json.uiDir != null) {
      builder.uiDir(json.uiDir);
    }
    if (json.pidFile != null) {
      builder.pidFile(json.pidFile);
    }
    if (json.enableSyslog != null) {
      builder.enableSyslog(json.enableSyslog);
    }
    if (json.rejoinAfterLeave != null) {
      builder.rejoinAfterLeave(json.rejoinAfterLeave);
    }
    if (json.telemetry != null) {
      builder.telemetry(json.telemetry);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Config} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Config instance
   */
  public static ImmutableConfig copyOf(Config instance) {
    if (instance instanceof ImmutableConfig) {
      return (ImmutableConfig) instance;
    }
    return ImmutableConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableConfig ImmutableConfig}.
   * @return A new ImmutableConfig builder
   */
  public static ImmutableConfig.Builder builder() {
    return new ImmutableConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableConfig ImmutableConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_BOOTSTRAP = 0x1L;
    private static final long INIT_BIT_SERVER = 0x2L;
    private static final long INIT_BIT_DATACENTER = 0x4L;
    private static final long INIT_BIT_DATA_DIR = 0x8L;
    private static final long INIT_BIT_DNS_RECURSOR = 0x10L;
    private static final long INIT_BIT_DOMAIN = 0x20L;
    private static final long INIT_BIT_LOG_LEVEL = 0x40L;
    private static final long INIT_BIT_NODE_NAME = 0x80L;
    private static final long INIT_BIT_CLIENT_ADDR = 0x100L;
    private static final long INIT_BIT_BIND_ADDR = 0x200L;
    private static final long INIT_BIT_ADVERTISE_ADDR = 0x400L;
    private static final long INIT_BIT_PORTS = 0x800L;
    private static final long INIT_BIT_LEAVE_ON_TERM = 0x1000L;
    private static final long INIT_BIT_SKIP_LEAVE_ON_INT = 0x2000L;
    private static final long INIT_BIT_PROTOCOL = 0x4000L;
    private static final long INIT_BIT_ENABLE_DEBUG = 0x8000L;
    private static final long INIT_BIT_VERIFY_INCOMING = 0x10000L;
    private static final long INIT_BIT_VERIFY_OUTGOING = 0x20000L;
    private static final long INIT_BIT_CA_FILE = 0x40000L;
    private static final long INIT_BIT_CERT_FILE = 0x80000L;
    private static final long INIT_BIT_KEY_FILE = 0x100000L;
    private static final long INIT_BIT_UI_DIR = 0x200000L;
    private static final long INIT_BIT_PID_FILE = 0x400000L;
    private static final long INIT_BIT_ENABLE_SYSLOG = 0x800000L;
    private static final long INIT_BIT_REJOIN_AFTER_LEAVE = 0x1000000L;
    private long initBits = 0x1ffffff;

    private boolean bootstrap;
    private boolean server;
    private String datacenter;
    private String dataDir;
    private String dnsRecursor;
    private String domain;
    private String logLevel;
    private String nodeName;
    private String clientAddr;
    private String bindAddr;
    private String advertiseAddr;
    private Ports ports;
    private boolean leaveOnTerm;
    private boolean skipLeaveOnInt;
    private Optional<String> statsiteAddr = Optional.absent();
    private int protocol;
    private boolean enableDebug;
    private boolean verifyIncoming;
    private boolean verifyOutgoing;
    private String caFile;
    private String certFile;
    private String keyFile;
    private ImmutableList.Builder<String> startJoinBuilder = ImmutableList.builder();
    private String uiDir;
    private String pidFile;
    private boolean enableSyslog;
    private boolean rejoinAfterLeave;
    private Optional<Telemetry> telemetry = Optional.absent();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Config} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Config instance) {
      Preconditions.checkNotNull(instance, "instance");
      bootstrap(instance.getBootstrap());
      server(instance.getServer());
      datacenter(instance.getDatacenter());
      dataDir(instance.getDataDir());
      dnsRecursor(instance.dnsRecursor());
      domain(instance.getDomain());
      logLevel(instance.getLogLevel());
      nodeName(instance.getNodeName());
      clientAddr(instance.getClientAddr());
      bindAddr(instance.getBindAddr());
      advertiseAddr(instance.getAdvertiseAddr());
      ports(instance.getPorts());
      leaveOnTerm(instance.getLeaveOnTerm());
      skipLeaveOnInt(instance.getSkipLeaveOnInt());
      Optional<String> statsiteAddrOptional = instance.getStatsiteAddr();
      if (statsiteAddrOptional.isPresent()) {
        statsiteAddr(statsiteAddrOptional);
      }
      protocol(instance.getProtocol());
      enableDebug(instance.getEnableDebug());
      verifyIncoming(instance.getVerifyIncoming());
      verifyOutgoing(instance.getVerifyOutgoing());
      caFile(instance.getCaFile());
      certFile(instance.getCertFile());
      keyFile(instance.getKeyFile());
      addAllStartJoin(instance.getStartJoin());
      uiDir(instance.getUiDir());
      pidFile(instance.getPidFile());
      enableSyslog(instance.getEnableSyslog());
      rejoinAfterLeave(instance.getRejoinAfterLeave());
      Optional<Telemetry> telemetryOptional = instance.getTelemetry();
      if (telemetryOptional.isPresent()) {
        telemetry(telemetryOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Config#getBootstrap() bootstrap} attribute.
     * @param bootstrap The value for bootstrap 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder bootstrap(boolean bootstrap) {
      this.bootstrap = bootstrap;
      initBits &= ~INIT_BIT_BOOTSTRAP;
      return this;
    }

    /**
     * Initializes the value for the {@link Config#getServer() server} attribute.
     * @param server The value for server 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder server(boolean server) {
      this.server = server;
      initBits &= ~INIT_BIT_SERVER;
      return this;
    }

    /**
     * Initializes the value for the {@link Config#getDatacenter() datacenter} attribute.
     * @param datacenter The value for datacenter 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder datacenter(String datacenter) {
      this.datacenter = Preconditions.checkNotNull(datacenter, "datacenter");
      initBits &= ~INIT_BIT_DATACENTER;
      return this;
    }

    /**
     * Initializes the value for the {@link Config#getDataDir() dataDir} attribute.
     * @param dataDir The value for dataDir 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dataDir(String dataDir) {
      this.dataDir = Preconditions.checkNotNull(dataDir, "dataDir");
      initBits &= ~INIT_BIT_DATA_DIR;
      return this;
    }

    /**
     * Initializes the value for the {@link Config#dnsRecursor() dnsRecursor} attribute.
     * @param dnsRecursor The value for dnsRecursor 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dnsRecursor(String dnsRecursor) {
      this.dnsRecursor = Preconditions.checkNotNull(dnsRecursor, "dnsRecursor");
      initBits &= ~INIT_BIT_DNS_RECURSOR;
      return this;
    }

    /**
     * Initializes the value for the {@link Config#getDomain() domain} attribute.
     * @param domain The value for domain 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domain(String domain) {
      this.domain = Preconditions.checkNotNull(domain, "domain");
      initBits &= ~INIT_BIT_DOMAIN;
      return this;
    }

    /**
     * Initializes the value for the {@link Config#getLogLevel() logLevel} attribute.
     * @param logLevel The value for logLevel 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder logLevel(String logLevel) {
      this.logLevel = Preconditions.checkNotNull(logLevel, "logLevel");
      initBits &= ~INIT_BIT_LOG_LEVEL;
      return this;
    }

    /**
     * Initializes the value for the {@link Config#getNodeName() nodeName} attribute.
     * @param nodeName The value for nodeName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder nodeName(String nodeName) {
      this.nodeName = Preconditions.checkNotNull(nodeName, "nodeName");
      initBits &= ~INIT_BIT_NODE_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Config#getClientAddr() clientAddr} attribute.
     * @param clientAddr The value for clientAddr 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientAddr(String clientAddr) {
      this.clientAddr = Preconditions.checkNotNull(clientAddr, "clientAddr");
      initBits &= ~INIT_BIT_CLIENT_ADDR;
      return this;
    }

    /**
     * Initializes the value for the {@link Config#getBindAddr() bindAddr} attribute.
     * @param bindAddr The value for bindAddr 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder bindAddr(String bindAddr) {
      this.bindAddr = Preconditions.checkNotNull(bindAddr, "bindAddr");
      initBits &= ~INIT_BIT_BIND_ADDR;
      return this;
    }

    /**
     * Initializes the value for the {@link Config#getAdvertiseAddr() advertiseAddr} attribute.
     * @param advertiseAddr The value for advertiseAddr 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder advertiseAddr(String advertiseAddr) {
      this.advertiseAddr = Preconditions.checkNotNull(advertiseAddr, "advertiseAddr");
      initBits &= ~INIT_BIT_ADVERTISE_ADDR;
      return this;
    }

    /**
     * Initializes the value for the {@link Config#getPorts() ports} attribute.
     * @param ports The value for ports 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ports(Ports ports) {
      this.ports = Preconditions.checkNotNull(ports, "ports");
      initBits &= ~INIT_BIT_PORTS;
      return this;
    }

    /**
     * Initializes the value for the {@link Config#getLeaveOnTerm() leaveOnTerm} attribute.
     * @param leaveOnTerm The value for leaveOnTerm 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder leaveOnTerm(boolean leaveOnTerm) {
      this.leaveOnTerm = leaveOnTerm;
      initBits &= ~INIT_BIT_LEAVE_ON_TERM;
      return this;
    }

    /**
     * Initializes the value for the {@link Config#getSkipLeaveOnInt() skipLeaveOnInt} attribute.
     * @param skipLeaveOnInt The value for skipLeaveOnInt 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder skipLeaveOnInt(boolean skipLeaveOnInt) {
      this.skipLeaveOnInt = skipLeaveOnInt;
      initBits &= ~INIT_BIT_SKIP_LEAVE_ON_INT;
      return this;
    }

    /**
     * Initializes the optional value {@link Config#getStatsiteAddr() statsiteAddr} to statsiteAddr.
     * @param statsiteAddr The value for statsiteAddr
     * @return {@code this} builder for chained invocation
     */
    @Deprecated
    public final Builder statsiteAddr(String statsiteAddr) {
      this.statsiteAddr = Optional.of(statsiteAddr);
      return this;
    }

    /**
     * Initializes the optional value {@link Config#getStatsiteAddr() statsiteAddr} to statsiteAddr.
     * @param statsiteAddr The value for statsiteAddr
     * @return {@code this} builder for use in a chained invocation
     */
    @Deprecated
    public final Builder statsiteAddr(Optional<String> statsiteAddr) {
      this.statsiteAddr = Preconditions.checkNotNull(statsiteAddr, "statsiteAddr");
      return this;
    }

    /**
     * Initializes the value for the {@link Config#getProtocol() protocol} attribute.
     * @param protocol The value for protocol 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder protocol(int protocol) {
      this.protocol = protocol;
      initBits &= ~INIT_BIT_PROTOCOL;
      return this;
    }

    /**
     * Initializes the value for the {@link Config#getEnableDebug() enableDebug} attribute.
     * @param enableDebug The value for enableDebug 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder enableDebug(boolean enableDebug) {
      this.enableDebug = enableDebug;
      initBits &= ~INIT_BIT_ENABLE_DEBUG;
      return this;
    }

    /**
     * Initializes the value for the {@link Config#getVerifyIncoming() verifyIncoming} attribute.
     * @param verifyIncoming The value for verifyIncoming 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder verifyIncoming(boolean verifyIncoming) {
      this.verifyIncoming = verifyIncoming;
      initBits &= ~INIT_BIT_VERIFY_INCOMING;
      return this;
    }

    /**
     * Initializes the value for the {@link Config#getVerifyOutgoing() verifyOutgoing} attribute.
     * @param verifyOutgoing The value for verifyOutgoing 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder verifyOutgoing(boolean verifyOutgoing) {
      this.verifyOutgoing = verifyOutgoing;
      initBits &= ~INIT_BIT_VERIFY_OUTGOING;
      return this;
    }

    /**
     * Initializes the value for the {@link Config#getCaFile() caFile} attribute.
     * @param caFile The value for caFile 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder caFile(String caFile) {
      this.caFile = Preconditions.checkNotNull(caFile, "caFile");
      initBits &= ~INIT_BIT_CA_FILE;
      return this;
    }

    /**
     * Initializes the value for the {@link Config#getCertFile() certFile} attribute.
     * @param certFile The value for certFile 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder certFile(String certFile) {
      this.certFile = Preconditions.checkNotNull(certFile, "certFile");
      initBits &= ~INIT_BIT_CERT_FILE;
      return this;
    }

    /**
     * Initializes the value for the {@link Config#getKeyFile() keyFile} attribute.
     * @param keyFile The value for keyFile 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder keyFile(String keyFile) {
      this.keyFile = Preconditions.checkNotNull(keyFile, "keyFile");
      initBits &= ~INIT_BIT_KEY_FILE;
      return this;
    }

    /**
     * Adds one element to {@link Config#getStartJoin() startJoin} list.
     * @param element A startJoin element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addStartJoin(String element) {
      startJoinBuilder.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Config#getStartJoin() startJoin} list.
     * @param elements An array of startJoin elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addStartJoin(String... elements) {
      startJoinBuilder.add(elements);
      return this;
    }

    /**
     * Sets or replaces all elements for {@link Config#getStartJoin() startJoin} list.
     * @param elements An iterable of startJoin elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder startJoin(Iterable<String> elements) {
      startJoinBuilder = ImmutableList.builder();
      return addAllStartJoin(elements);
    }

    /**
     * Adds elements to {@link Config#getStartJoin() startJoin} list.
     * @param elements An iterable of startJoin elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllStartJoin(Iterable<String> elements) {
      startJoinBuilder.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link Config#getUiDir() uiDir} attribute.
     * @param uiDir The value for uiDir 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder uiDir(String uiDir) {
      this.uiDir = Preconditions.checkNotNull(uiDir, "uiDir");
      initBits &= ~INIT_BIT_UI_DIR;
      return this;
    }

    /**
     * Initializes the value for the {@link Config#getPidFile() pidFile} attribute.
     * @param pidFile The value for pidFile 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder pidFile(String pidFile) {
      this.pidFile = Preconditions.checkNotNull(pidFile, "pidFile");
      initBits &= ~INIT_BIT_PID_FILE;
      return this;
    }

    /**
     * Initializes the value for the {@link Config#getEnableSyslog() enableSyslog} attribute.
     * @param enableSyslog The value for enableSyslog 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder enableSyslog(boolean enableSyslog) {
      this.enableSyslog = enableSyslog;
      initBits &= ~INIT_BIT_ENABLE_SYSLOG;
      return this;
    }

    /**
     * Initializes the value for the {@link Config#getRejoinAfterLeave() rejoinAfterLeave} attribute.
     * @param rejoinAfterLeave The value for rejoinAfterLeave 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder rejoinAfterLeave(boolean rejoinAfterLeave) {
      this.rejoinAfterLeave = rejoinAfterLeave;
      initBits &= ~INIT_BIT_REJOIN_AFTER_LEAVE;
      return this;
    }

    /**
     * Initializes the optional value {@link Config#getTelemetry() telemetry} to telemetry.
     * @param telemetry The value for telemetry
     * @return {@code this} builder for chained invocation
     */
    public final Builder telemetry(Telemetry telemetry) {
      this.telemetry = Optional.of(telemetry);
      return this;
    }

    /**
     * Initializes the optional value {@link Config#getTelemetry() telemetry} to telemetry.
     * @param telemetry The value for telemetry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder telemetry(Optional<Telemetry> telemetry) {
      this.telemetry = Preconditions.checkNotNull(telemetry, "telemetry");
      return this;
    }

    /**
     * Builds a new {@link ImmutableConfig ImmutableConfig}.
     * @return An immutable instance of Config
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableConfig build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableConfig(
          bootstrap,
          server,
          datacenter,
          dataDir,
          dnsRecursor,
          domain,
          logLevel,
          nodeName,
          clientAddr,
          bindAddr,
          advertiseAddr,
          ports,
          leaveOnTerm,
          skipLeaveOnInt,
          statsiteAddr,
          protocol,
          enableDebug,
          verifyIncoming,
          verifyOutgoing,
          caFile,
          certFile,
          keyFile,
          startJoinBuilder.build(),
          uiDir,
          pidFile,
          enableSyslog,
          rejoinAfterLeave,
          telemetry);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_BOOTSTRAP) != 0) attributes.add("bootstrap");
      if ((initBits & INIT_BIT_SERVER) != 0) attributes.add("server");
      if ((initBits & INIT_BIT_DATACENTER) != 0) attributes.add("datacenter");
      if ((initBits & INIT_BIT_DATA_DIR) != 0) attributes.add("dataDir");
      if ((initBits & INIT_BIT_DNS_RECURSOR) != 0) attributes.add("dnsRecursor");
      if ((initBits & INIT_BIT_DOMAIN) != 0) attributes.add("domain");
      if ((initBits & INIT_BIT_LOG_LEVEL) != 0) attributes.add("logLevel");
      if ((initBits & INIT_BIT_NODE_NAME) != 0) attributes.add("nodeName");
      if ((initBits & INIT_BIT_CLIENT_ADDR) != 0) attributes.add("clientAddr");
      if ((initBits & INIT_BIT_BIND_ADDR) != 0) attributes.add("bindAddr");
      if ((initBits & INIT_BIT_ADVERTISE_ADDR) != 0) attributes.add("advertiseAddr");
      if ((initBits & INIT_BIT_PORTS) != 0) attributes.add("ports");
      if ((initBits & INIT_BIT_LEAVE_ON_TERM) != 0) attributes.add("leaveOnTerm");
      if ((initBits & INIT_BIT_SKIP_LEAVE_ON_INT) != 0) attributes.add("skipLeaveOnInt");
      if ((initBits & INIT_BIT_PROTOCOL) != 0) attributes.add("protocol");
      if ((initBits & INIT_BIT_ENABLE_DEBUG) != 0) attributes.add("enableDebug");
      if ((initBits & INIT_BIT_VERIFY_INCOMING) != 0) attributes.add("verifyIncoming");
      if ((initBits & INIT_BIT_VERIFY_OUTGOING) != 0) attributes.add("verifyOutgoing");
      if ((initBits & INIT_BIT_CA_FILE) != 0) attributes.add("caFile");
      if ((initBits & INIT_BIT_CERT_FILE) != 0) attributes.add("certFile");
      if ((initBits & INIT_BIT_KEY_FILE) != 0) attributes.add("keyFile");
      if ((initBits & INIT_BIT_UI_DIR) != 0) attributes.add("uiDir");
      if ((initBits & INIT_BIT_PID_FILE) != 0) attributes.add("pidFile");
      if ((initBits & INIT_BIT_ENABLE_SYSLOG) != 0) attributes.add("enableSyslog");
      if ((initBits & INIT_BIT_REJOIN_AFTER_LEAVE) != 0) attributes.add("rejoinAfterLeave");
      return "Cannot build Config, some of required attributes are not set " + attributes;
    }
  }
}
