package com.orbitz.consul.model.health;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.catalog.TaggedAddresses;
import java.util.List;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link Node}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNode.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "Node"})
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableNode extends Node {
  private final String node;
  private final String address;
  private final Optional<TaggedAddresses> taggedAddresses;

  private ImmutableNode(
      String node,
      String address,
      Optional<TaggedAddresses> taggedAddresses) {
    this.node = node;
    this.address = address;
    this.taggedAddresses = taggedAddresses;
  }

  /**
   * @return The value of the {@code node} attribute
   */
  @JsonProperty(value = "Node")
  @Override
  public String getNode() {
    return node;
  }

  /**
   * @return The value of the {@code address} attribute
   */
  @JsonProperty(value = "Address")
  @Override
  public String getAddress() {
    return address;
  }

  /**
   * @return The value of the {@code taggedAddresses} attribute
   */
  @JsonProperty(value = "TaggedAddresses")
  @Override
  public Optional<TaggedAddresses> getTaggedAddresses() {
    return taggedAddresses;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Node#getNode() node} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for node
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNode withNode(String value) {
    if (this.node.equals(value)) return this;
    return new ImmutableNode(
        Preconditions.checkNotNull(value, "node"),
        this.address,
        this.taggedAddresses);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Node#getAddress() address} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for address
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNode withAddress(String value) {
    if (this.address.equals(value)) return this;
    return new ImmutableNode(
        this.node,
        Preconditions.checkNotNull(value, "address"),
        this.taggedAddresses);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Node#getTaggedAddresses() taggedAddresses} attribute.
   * @param value The value for taggedAddresses
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNode withTaggedAddresses(TaggedAddresses value) {
    Optional<TaggedAddresses> newValue = Optional.of(value);
    if (this.taggedAddresses.isPresent() && this.taggedAddresses.get() == value) return this;
    return new ImmutableNode(this.node, this.address, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Node#getTaggedAddresses() taggedAddresses} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for taggedAddresses
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNode withTaggedAddresses(Optional<TaggedAddresses> optional) {
    Optional<TaggedAddresses> value = Preconditions.checkNotNull(optional, "taggedAddresses");
    if (!this.taggedAddresses.isPresent() && !value.isPresent()) return this;
    if (this.taggedAddresses.isPresent() && value.isPresent() && this.taggedAddresses.get() == value.get()) return this;
    return new ImmutableNode(this.node, this.address, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNode} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNode
        && equalTo((ImmutableNode) another);
  }

  private boolean equalTo(ImmutableNode another) {
    return node.equals(another.node)
        && address.equals(another.address)
        && taggedAddresses.equals(another.taggedAddresses);
  }

  /**
   * Computes a hash code from attributes: {@code node}, {@code address}, {@code taggedAddresses}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + node.hashCode();
    h = h * 17 + address.hashCode();
    h = h * 17 + taggedAddresses.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Node} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Node")
        .omitNullValues()
        .add("node", node)
        .add("address", address)
        .add("taggedAddresses", taggedAddresses.orNull())
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends Node {
    String node;
    String address;
    Optional<TaggedAddresses> taggedAddresses = Optional.absent();
    @JsonProperty(value = "Node")
    public void setNode(String node) {
      this.node = node;
    }
    @JsonProperty(value = "Address")
    public void setAddress(String address) {
      this.address = address;
    }
    @JsonProperty(value = "TaggedAddresses")
    public void setTaggedAddresses(Optional<TaggedAddresses> taggedAddresses) {
      this.taggedAddresses = taggedAddresses;
    }
    @Override
    public String getNode() { throw new UnsupportedOperationException(); }
    @Override
    public String getAddress() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<TaggedAddresses> getTaggedAddresses() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableNode fromJson(Json json) {
    ImmutableNode.Builder builder = ImmutableNode.builder();
    if (json.node != null) {
      builder.node(json.node);
    }
    if (json.address != null) {
      builder.address(json.address);
    }
    if (json.taggedAddresses != null) {
      builder.taggedAddresses(json.taggedAddresses);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Node} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Node instance
   */
  public static ImmutableNode copyOf(Node instance) {
    if (instance instanceof ImmutableNode) {
      return (ImmutableNode) instance;
    }
    return ImmutableNode.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNode ImmutableNode}.
   * @return A new ImmutableNode builder
   */
  public static ImmutableNode.Builder builder() {
    return new ImmutableNode.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNode ImmutableNode}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NODE = 0x1L;
    private static final long INIT_BIT_ADDRESS = 0x2L;
    private long initBits = 0x3;

    private String node;
    private String address;
    private Optional<TaggedAddresses> taggedAddresses = Optional.absent();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Node} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Node instance) {
      Preconditions.checkNotNull(instance, "instance");
      node(instance.getNode());
      address(instance.getAddress());
      Optional<TaggedAddresses> taggedAddressesOptional = instance.getTaggedAddresses();
      if (taggedAddressesOptional.isPresent()) {
        taggedAddresses(taggedAddressesOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Node#getNode() node} attribute.
     * @param node The value for node 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder node(String node) {
      this.node = Preconditions.checkNotNull(node, "node");
      initBits &= ~INIT_BIT_NODE;
      return this;
    }

    /**
     * Initializes the value for the {@link Node#getAddress() address} attribute.
     * @param address The value for address 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder address(String address) {
      this.address = Preconditions.checkNotNull(address, "address");
      initBits &= ~INIT_BIT_ADDRESS;
      return this;
    }

    /**
     * Initializes the optional value {@link Node#getTaggedAddresses() taggedAddresses} to taggedAddresses.
     * @param taggedAddresses The value for taggedAddresses
     * @return {@code this} builder for chained invocation
     */
    public final Builder taggedAddresses(TaggedAddresses taggedAddresses) {
      this.taggedAddresses = Optional.of(taggedAddresses);
      return this;
    }

    /**
     * Initializes the optional value {@link Node#getTaggedAddresses() taggedAddresses} to taggedAddresses.
     * @param taggedAddresses The value for taggedAddresses
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder taggedAddresses(Optional<TaggedAddresses> taggedAddresses) {
      this.taggedAddresses = Preconditions.checkNotNull(taggedAddresses, "taggedAddresses");
      return this;
    }

    /**
     * Builds a new {@link ImmutableNode ImmutableNode}.
     * @return An immutable instance of Node
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNode build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableNode(node, address, taggedAddresses);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_NODE) != 0) attributes.add("node");
      if ((initBits & INIT_BIT_ADDRESS) != 0) attributes.add("address");
      return "Cannot build Node, some of required attributes are not set " + attributes;
    }
  }
}
