/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.retrofit;

import com.orbitz.okhttp3.MediaType;
import com.orbitz.okhttp3.Request;
import com.orbitz.okhttp3.ResponseBody;
import com.orbitz.okio.Buffer;
import com.orbitz.okio.BufferedSource;
import com.orbitz.okio.ForwardingSource;
import com.orbitz.okio.Okio;
import com.orbitz.retrofit.Call;
import com.orbitz.retrofit.Callback;
import com.orbitz.retrofit.Response;
import com.orbitz.retrofit.ServiceMethod;
import com.orbitz.retrofit.Utils;
import java.io.IOException;

final class OkHttpCall<T>
implements Call<T> {
    private final ServiceMethod<T> serviceMethod;
    private final Object[] args;
    private volatile boolean canceled;
    private com.orbitz.okhttp3.Call rawCall;
    private Throwable creationFailure;
    private boolean executed;

    OkHttpCall(ServiceMethod<T> serviceMethod, Object[] args) {
        this.serviceMethod = serviceMethod;
        this.args = args;
    }

    @Override
    public OkHttpCall<T> clone() {
        return new OkHttpCall<T>(this.serviceMethod, this.args);
    }

    @Override
    public synchronized Request request() {
        com.orbitz.okhttp3.Call call = this.rawCall;
        if (call != null) {
            return call.request();
        }
        if (this.creationFailure != null) {
            if (this.creationFailure instanceof IOException) {
                throw new RuntimeException("Unable to create request.", this.creationFailure);
            }
            throw (RuntimeException)this.creationFailure;
        }
        try {
            this.rawCall = this.createRawCall();
            return this.rawCall.request();
        }
        catch (RuntimeException e) {
            this.creationFailure = e;
            throw e;
        }
        catch (IOException e) {
            this.creationFailure = e;
            throw new RuntimeException("Unable to create request.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(final Callback<T> callback) {
        Throwable failure;
        com.orbitz.okhttp3.Call call;
        if (callback == null) {
            throw new NullPointerException("callback == null");
        }
        OkHttpCall okHttpCall = this;
        synchronized (okHttpCall) {
            if (this.executed) {
                throw new IllegalStateException("Already executed.");
            }
            this.executed = true;
            call = this.rawCall;
            failure = this.creationFailure;
            if (call == null && failure == null) {
                try {
                    call = this.rawCall = this.createRawCall();
                }
                catch (Throwable t) {
                    failure = this.creationFailure = t;
                }
            }
        }
        if (failure != null) {
            callback.onFailure(this, failure);
            return;
        }
        if (this.canceled) {
            call.cancel();
        }
        call.enqueue(new com.orbitz.okhttp3.Callback(){

            @Override
            public void onResponse(com.orbitz.okhttp3.Call call, com.orbitz.okhttp3.Response rawResponse) throws IOException {
                Response response;
                try {
                    response = OkHttpCall.this.parseResponse(rawResponse);
                }
                catch (Throwable e) {
                    this.callFailure(e);
                    return;
                }
                this.callSuccess(response);
            }

            @Override
            public void onFailure(com.orbitz.okhttp3.Call call, IOException e) {
                try {
                    callback.onFailure(OkHttpCall.this, e);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }

            private void callFailure(Throwable e) {
                try {
                    callback.onFailure(OkHttpCall.this, e);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }

            private void callSuccess(Response<T> response) {
                try {
                    callback.onResponse(OkHttpCall.this, response);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
    }

    @Override
    public synchronized boolean isExecuted() {
        return this.executed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response<T> execute() throws IOException {
        com.orbitz.okhttp3.Call call;
        OkHttpCall okHttpCall = this;
        synchronized (okHttpCall) {
            if (this.executed) {
                throw new IllegalStateException("Already executed.");
            }
            this.executed = true;
            if (this.creationFailure != null) {
                if (this.creationFailure instanceof IOException) {
                    throw (IOException)this.creationFailure;
                }
                throw (RuntimeException)this.creationFailure;
            }
            call = this.rawCall;
            if (call == null) {
                try {
                    call = this.rawCall = this.createRawCall();
                }
                catch (IOException | RuntimeException e) {
                    this.creationFailure = e;
                    throw e;
                }
            }
        }
        if (this.canceled) {
            call.cancel();
        }
        return this.parseResponse(call.execute());
    }

    private com.orbitz.okhttp3.Call createRawCall() throws IOException {
        Request request = this.serviceMethod.toRequest(this.args);
        com.orbitz.okhttp3.Call call = this.serviceMethod.callFactory.newCall(request);
        if (call == null) {
            throw new NullPointerException("Call.Factory returned null.");
        }
        return call;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response<T> parseResponse(com.orbitz.okhttp3.Response rawResponse) throws IOException {
        ResponseBody rawBody = rawResponse.body();
        int code = (rawResponse = rawResponse.newBuilder().body(new NoContentResponseBody(rawBody.contentType(), rawBody.contentLength())).build()).code();
        if (code < 200 || code >= 300) {
            try {
                ResponseBody bufferedBody = Utils.buffer(rawBody);
                Response response = Response.error(bufferedBody, rawResponse);
                return response;
            }
            finally {
                rawBody.close();
            }
        }
        if (code == 204 || code == 205) {
            return Response.success(null, rawResponse);
        }
        ExceptionCatchingRequestBody catchingBody = new ExceptionCatchingRequestBody(rawBody);
        try {
            T body = this.serviceMethod.toResponse(catchingBody);
            return Response.success(body, rawResponse);
        }
        catch (RuntimeException e) {
            catchingBody.throwIfCaught();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        com.orbitz.okhttp3.Call call;
        this.canceled = true;
        OkHttpCall okHttpCall = this;
        synchronized (okHttpCall) {
            call = this.rawCall;
        }
        if (call != null) {
            call.cancel();
        }
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    static final class ExceptionCatchingRequestBody
    extends ResponseBody {
        private final ResponseBody delegate;
        IOException thrownException;

        ExceptionCatchingRequestBody(ResponseBody delegate) {
            this.delegate = delegate;
        }

        @Override
        public MediaType contentType() {
            return this.delegate.contentType();
        }

        @Override
        public long contentLength() {
            return this.delegate.contentLength();
        }

        @Override
        public BufferedSource source() {
            return Okio.buffer(new ForwardingSource(this.delegate.source()){

                @Override
                public long read(Buffer sink, long byteCount) throws IOException {
                    try {
                        return super.read(sink, byteCount);
                    }
                    catch (IOException e) {
                        ExceptionCatchingRequestBody.this.thrownException = e;
                        throw e;
                    }
                }
            });
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        void throwIfCaught() throws IOException {
            if (this.thrownException != null) {
                throw this.thrownException;
            }
        }
    }

    static final class NoContentResponseBody
    extends ResponseBody {
        private final MediaType contentType;
        private final long contentLength;

        NoContentResponseBody(MediaType contentType, long contentLength) {
            this.contentType = contentType;
            this.contentLength = contentLength;
        }

        @Override
        public MediaType contentType() {
            return this.contentType;
        }

        @Override
        public long contentLength() {
            return this.contentLength;
        }

        @Override
        public BufferedSource source() {
            throw new IllegalStateException("Cannot read raw response body of a converted body.");
        }
    }
}

