/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul;

import com.google.common.collect.ImmutableMap;
import com.orbitz.consul.ConsulException;
import com.orbitz.consul.async.EventResponseCallback;
import com.orbitz.consul.model.EventResponse;
import com.orbitz.consul.model.ImmutableEventResponse;
import com.orbitz.consul.model.event.Event;
import com.orbitz.consul.option.EventOptions;
import com.orbitz.consul.option.QueryOptions;
import com.orbitz.consul.util.Http;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.apache.commons.lang3.StringUtils;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.QueryMap;

public class EventClient {
    private final Api api;

    EventClient(Retrofit retrofit) {
        this.api = (Api)retrofit.create(Api.class);
    }

    public Event fireEvent(String name, EventOptions eventOptions, String payload) {
        return Http.extract(this.api.fireEvent(name, RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)payload), eventOptions.toQuery()));
    }

    public Event fireEvent(String name) {
        return this.fireEvent(name, EventOptions.BLANK);
    }

    public Event fireEvent(String name, EventOptions eventOptions) {
        return Http.extract(this.api.fireEvent(name, eventOptions.toQuery()));
    }

    public Event fireEvent(String name, String payload) {
        return this.fireEvent(name, EventOptions.BLANK, payload);
    }

    public EventResponse listEvents(String name, QueryOptions queryOptions) {
        ImmutableMap query = Collections.emptyMap();
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            query = ImmutableMap.of((Object)"name", (Object)name);
        }
        return EventClient.response(this.api.listEvents((Map<String, String>)query));
    }

    public EventResponse listEvents(String name) {
        return this.listEvents(name, QueryOptions.BLANK);
    }

    public EventResponse listEvents(QueryOptions queryOptions) {
        return this.listEvents(null, queryOptions);
    }

    public EventResponse listEvents() {
        return this.listEvents(null, QueryOptions.BLANK);
    }

    public void listEvents(String name, QueryOptions queryOptions, EventResponseCallback callback) {
        ImmutableMap query = Collections.emptyMap();
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            query = ImmutableMap.of((Object)"name", (Object)name);
        }
        EventClient.response(this.api.listEvents((Map<String, String>)query), callback);
    }

    public void listEvents(QueryOptions queryOptions, EventResponseCallback callback) {
        this.listEvents(null, queryOptions, callback);
    }

    public void listEvents(EventResponseCallback callback) {
        this.listEvents(null, QueryOptions.BLANK, callback);
    }

    private static void response(Call<List<Event>> call, final EventResponseCallback callback) {
        call.enqueue((Callback)new Callback<List<Event>>(){

            public void onResponse(Call<List<Event>> call, Response<List<Event>> response) {
                try {
                    callback.onComplete(EventClient.eventResponse((Response<List<Event>>)response));
                }
                catch (Exception ex) {
                    callback.onFailure(ex);
                }
            }

            public void onFailure(Call<List<Event>> call, Throwable t) {
                callback.onFailure(t);
            }
        });
    }

    private static EventResponse response(Call<List<Event>> call) {
        Response response;
        try {
            response = call.execute();
        }
        catch (IOException e) {
            throw new ConsulException(e);
        }
        if (!response.isSuccessful()) {
            throw new ConsulException(response.code(), response);
        }
        return EventClient.eventResponse((Response<List<Event>>)response);
    }

    private static EventResponse eventResponse(Response<List<Event>> response) {
        String indexHeaderValue = response.headers().get("X-Consul-Index");
        BigInteger index = new BigInteger(indexHeaderValue);
        return ImmutableEventResponse.of((List)response.body(), index);
    }

    static interface Api {
        @PUT(value="event/fire/{name}")
        public Call<Event> fireEvent(@Path(value="name") String var1, @Body RequestBody var2, @QueryMap Map<String, Object> var3);

        @PUT(value="event/fire/{name}")
        public Call<Event> fireEvent(@Path(value="name") String var1, @QueryMap Map<String, Object> var2);

        @GET(value="event/list")
        public Call<List<Event>> listEvents(@QueryMap Map<String, String> var1);
    }
}

