/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul;

import com.google.common.collect.ImmutableMap;
import com.orbitz.consul.async.ConsulResponseCallback;
import com.orbitz.consul.model.ConsulResponse;
import com.orbitz.consul.model.State;
import com.orbitz.consul.model.health.HealthCheck;
import com.orbitz.consul.model.health.ServiceHealth;
import com.orbitz.consul.option.CatalogOptions;
import com.orbitz.consul.option.Options;
import com.orbitz.consul.option.QueryOptions;
import com.orbitz.consul.util.Http;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Path;
import retrofit2.http.QueryMap;

public class HealthClient {
    private final Api api;

    HealthClient(Retrofit retrofit) {
        this.api = (Api)retrofit.create(Api.class);
    }

    public ConsulResponse<List<HealthCheck>> getNodeChecks(String node) {
        return this.getNodeChecks(node, null, QueryOptions.BLANK);
    }

    public ConsulResponse<List<HealthCheck>> getNodeChecks(String node, CatalogOptions catalogOptions) {
        return this.getNodeChecks(node, catalogOptions, QueryOptions.BLANK);
    }

    public ConsulResponse<List<HealthCheck>> getNodeChecks(String node, QueryOptions queryOptions) {
        return this.getNodeChecks(node, null, queryOptions);
    }

    public ConsulResponse<List<HealthCheck>> getNodeChecks(String node, CatalogOptions catalogOptions, QueryOptions queryOptions) {
        return Http.extractConsulResponse(this.api.getNodeChecks(node, Options.from(catalogOptions, queryOptions)));
    }

    public ConsulResponse<List<HealthCheck>> getServiceChecks(String service) {
        return this.getServiceChecks(service, null, QueryOptions.BLANK);
    }

    public ConsulResponse<List<HealthCheck>> getServiceChecks(String service, CatalogOptions catalogOptions) {
        return this.getServiceChecks(service, catalogOptions, QueryOptions.BLANK);
    }

    public ConsulResponse<List<HealthCheck>> getServiceChecks(String service, QueryOptions queryOptions) {
        return this.getServiceChecks(service, null, queryOptions);
    }

    public ConsulResponse<List<HealthCheck>> getServiceChecks(String service, CatalogOptions catalogOptions, QueryOptions queryOptions) {
        return Http.extractConsulResponse(this.api.getServiceChecks(service, Options.from(catalogOptions, queryOptions)));
    }

    public void getServiceChecks(String service, QueryOptions queryOptions, ConsulResponseCallback<List<HealthCheck>> callback) {
        Http.extractConsulResponse(this.api.getServiceChecks(service, queryOptions.toQuery()), callback);
    }

    public void getServiceChecks(String service, CatalogOptions catalogOptions, QueryOptions queryOptions, ConsulResponseCallback<List<HealthCheck>> callback) {
        Http.extractConsulResponse(this.api.getServiceChecks(service, Options.from(queryOptions, catalogOptions)), callback);
    }

    public ConsulResponse<List<HealthCheck>> getChecksByState(State state) {
        return this.getChecksByState(state, null, QueryOptions.BLANK);
    }

    public ConsulResponse<List<HealthCheck>> getChecksByState(State state, CatalogOptions catalogOptions) {
        return this.getChecksByState(state, catalogOptions, QueryOptions.BLANK);
    }

    public ConsulResponse<List<HealthCheck>> getChecksByState(State state, QueryOptions queryOptions) {
        return this.getChecksByState(state, null, queryOptions);
    }

    public ConsulResponse<List<HealthCheck>> getChecksByState(State state, CatalogOptions catalogOptions, QueryOptions queryOptions) {
        return Http.extractConsulResponse(this.api.getChecksByState(state.getName(), Options.from(catalogOptions, queryOptions)));
    }

    public void getChecksByState(State state, CatalogOptions catalogOptions, QueryOptions queryOptions, ConsulResponseCallback<List<HealthCheck>> callback) {
        Http.extractConsulResponse(this.api.getChecksByState(state.getName(), Options.from(catalogOptions, queryOptions)), callback);
    }

    public ConsulResponse<List<ServiceHealth>> getHealthyServiceInstances(String service) {
        return this.getHealthyServiceInstances(service, null, QueryOptions.BLANK);
    }

    public ConsulResponse<List<ServiceHealth>> getHealthyServiceInstances(String service, CatalogOptions catalogOptions) {
        return this.getHealthyServiceInstances(service, catalogOptions, QueryOptions.BLANK);
    }

    public ConsulResponse<List<ServiceHealth>> getHealthyServiceInstances(String service, QueryOptions queryOptions) {
        return this.getHealthyServiceInstances(service, null, queryOptions);
    }

    public ConsulResponse<List<ServiceHealth>> getHealthyServiceInstances(String service, CatalogOptions catalogOptions, QueryOptions queryOptions) {
        return Http.extractConsulResponse(this.api.getServiceInstances(service, HealthClient.optionsFrom(new Map[]{ImmutableMap.of((Object)"passing", (Object)"true"), Options.from(catalogOptions, queryOptions)})));
    }

    public void getHealthyServiceInstances(String service, CatalogOptions catalogOptions, QueryOptions queryOptions, ConsulResponseCallback<List<ServiceHealth>> callback) {
        Http.extractConsulResponse(this.api.getServiceInstances(service, HealthClient.optionsFrom(new Map[]{ImmutableMap.of((Object)"passing", (Object)"true"), Options.from(catalogOptions, queryOptions)})), callback);
    }

    public void getHealthyServiceInstances(String service, QueryOptions queryOptions, ConsulResponseCallback<List<ServiceHealth>> callback) {
        Http.extractConsulResponse(this.api.getServiceInstances(service, HealthClient.optionsFrom(new Map[]{ImmutableMap.of((Object)"passing", (Object)"true"), queryOptions.toQuery()})), callback);
    }

    public ConsulResponse<List<ServiceHealth>> getAllServiceInstances(String service) {
        return this.getAllServiceInstances(service, null, QueryOptions.BLANK);
    }

    public ConsulResponse<List<ServiceHealth>> getAllServiceInstances(String service, CatalogOptions catalogOptions) {
        return this.getAllServiceInstances(service, catalogOptions, QueryOptions.BLANK);
    }

    public ConsulResponse<List<ServiceHealth>> getAllServiceInstances(String service, QueryOptions queryOptions) {
        return this.getAllServiceInstances(service, null, queryOptions);
    }

    public ConsulResponse<List<ServiceHealth>> getAllServiceInstances(String service, CatalogOptions catalogOptions, QueryOptions queryOptions) {
        return Http.extractConsulResponse(this.api.getServiceInstances(service, Options.from(catalogOptions, queryOptions)));
    }

    public void getAllServiceInstances(String service, CatalogOptions catalogOptions, QueryOptions queryOptions, ConsulResponseCallback<List<ServiceHealth>> callback) {
        Http.extractConsulResponse(this.api.getServiceInstances(service, Options.from(catalogOptions, queryOptions)), callback);
    }

    public void getAllServiceInstances(String service, QueryOptions queryOptions, ConsulResponseCallback<List<ServiceHealth>> callback) {
        Http.extractConsulResponse(this.api.getServiceInstances(service, queryOptions.toQuery()), callback);
    }

    private static Map<String, Object> optionsFrom(Map<String, ?> ... options) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map<String, ?> option : options) {
            result.putAll(option);
        }
        return result;
    }

    static interface Api {
        @GET(value="health/node/{node}")
        public Call<List<HealthCheck>> getNodeChecks(@Path(value="node") String var1, @QueryMap Map<String, Object> var2);

        @GET(value="health/checks/{service}")
        public Call<List<HealthCheck>> getServiceChecks(@Path(value="service") String var1, @QueryMap Map<String, Object> var2);

        @GET(value="health/state/{state}")
        public Call<List<HealthCheck>> getChecksByState(@Path(value="state") String var1, @QueryMap Map<String, Object> var2);

        @GET(value="health/service/{service}")
        public Call<List<ServiceHealth>> getServiceInstances(@Path(value="service") String var1, @QueryMap Map<String, Object> var2);
    }
}

