package com.orbitz.consul.model.coordinate;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link Datacenter}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDatacenter.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "Datacenter"})
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableDatacenter extends Datacenter {
  private final String datacenter;
  private final ImmutableList<Coordinate> coordinates;

  private ImmutableDatacenter(
      String datacenter,
      ImmutableList<Coordinate> coordinates) {
    this.datacenter = datacenter;
    this.coordinates = coordinates;
  }

  /**
   * @return The value of the {@code datacenter} attribute
   */
  @JsonProperty(value = "Datacenter")
  @Override
  public String getDatacenter() {
    return datacenter;
  }

  /**
   * @return The value of the {@code coordinates} attribute
   */
  @JsonProperty(value = "Coordinates")
  @Override
  public ImmutableList<Coordinate> getCoordinates() {
    return coordinates;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Datacenter#getDatacenter() datacenter} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for datacenter
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDatacenter withDatacenter(String value) {
    if (this.datacenter.equals(value)) return this;
    return new ImmutableDatacenter(Preconditions.checkNotNull(value, "datacenter"), this.coordinates);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Datacenter#getCoordinates() coordinates}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDatacenter withCoordinates(Coordinate... elements) {
    ImmutableList<Coordinate> newValue = ImmutableList.copyOf(elements);
    return new ImmutableDatacenter(this.datacenter, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Datacenter#getCoordinates() coordinates}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of coordinates elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDatacenter withCoordinates(Iterable<? extends Coordinate> elements) {
    if (this.coordinates == elements) return this;
    ImmutableList<Coordinate> newValue = ImmutableList.copyOf(elements);
    return new ImmutableDatacenter(this.datacenter, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDatacenter} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDatacenter
        && equalTo((ImmutableDatacenter) another);
  }

  private boolean equalTo(ImmutableDatacenter another) {
    return datacenter.equals(another.datacenter)
        && coordinates.equals(another.coordinates);
  }

  /**
   * Computes a hash code from attributes: {@code datacenter}, {@code coordinates}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + datacenter.hashCode();
    h = h * 17 + coordinates.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Datacenter} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Datacenter")
        .omitNullValues()
        .add("datacenter", datacenter)
        .add("coordinates", coordinates)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends Datacenter {
    @Nullable String datacenter;
    List<Coordinate> coordinates = ImmutableList.of();
    @JsonProperty(value = "Datacenter")
    public void setDatacenter(String datacenter) {
      this.datacenter = datacenter;
    }
    @JsonProperty(value = "Coordinates")
    public void setCoordinates(List<Coordinate> coordinates) {
      this.coordinates = coordinates;
    }
    @Override
    public String getDatacenter() { throw new UnsupportedOperationException(); }
    @Override
    public List<Coordinate> getCoordinates() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableDatacenter fromJson(Json json) {
    ImmutableDatacenter.Builder builder = ImmutableDatacenter.builder();
    if (json.datacenter != null) {
      builder.datacenter(json.datacenter);
    }
    if (json.coordinates != null) {
      builder.addAllCoordinates(json.coordinates);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Datacenter} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Datacenter instance
   */
  public static ImmutableDatacenter copyOf(Datacenter instance) {
    if (instance instanceof ImmutableDatacenter) {
      return (ImmutableDatacenter) instance;
    }
    return ImmutableDatacenter.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDatacenter ImmutableDatacenter}.
   * @return A new ImmutableDatacenter builder
   */
  public static ImmutableDatacenter.Builder builder() {
    return new ImmutableDatacenter.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDatacenter ImmutableDatacenter}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_DATACENTER = 0x1L;
    private long initBits = 0x1;

    private @Nullable String datacenter;
    private ImmutableList.Builder<Coordinate> coordinatesBuilder = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Datacenter} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Datacenter instance) {
      Preconditions.checkNotNull(instance, "instance");
      datacenter(instance.getDatacenter());
      addAllCoordinates(instance.getCoordinates());
      return this;
    }

    /**
     * Initializes the value for the {@link Datacenter#getDatacenter() datacenter} attribute.
     * @param datacenter The value for datacenter 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder datacenter(String datacenter) {
      this.datacenter = Preconditions.checkNotNull(datacenter, "datacenter");
      initBits &= ~INIT_BIT_DATACENTER;
      return this;
    }

    /**
     * Adds one element to {@link Datacenter#getCoordinates() coordinates} list.
     * @param element A coordinates element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addCoordinates(Coordinate element) {
      coordinatesBuilder.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Datacenter#getCoordinates() coordinates} list.
     * @param elements An array of coordinates elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addCoordinates(Coordinate... elements) {
      coordinatesBuilder.add(elements);
      return this;
    }

    /**
     * Sets or replaces all elements for {@link Datacenter#getCoordinates() coordinates} list.
     * @param elements An iterable of coordinates elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder coordinates(Iterable<? extends Coordinate> elements) {
      coordinatesBuilder = ImmutableList.builder();
      return addAllCoordinates(elements);
    }

    /**
     * Adds elements to {@link Datacenter#getCoordinates() coordinates} list.
     * @param elements An iterable of coordinates elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllCoordinates(Iterable<? extends Coordinate> elements) {
      coordinatesBuilder.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableDatacenter ImmutableDatacenter}.
     * @return An immutable instance of Datacenter
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDatacenter build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDatacenter(datacenter, coordinatesBuilder.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_DATACENTER) != 0) attributes.add("datacenter");
      return "Cannot build Datacenter, some of required attributes are not set " + attributes;
    }
  }
}
