package com.orbitz.consul.option;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link CatalogOptions}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCatalogOptions.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "CatalogOptions"})
@Immutable
public final class ImmutableCatalogOptions extends CatalogOptions {
  private final Optional<String> datacenter;
  private final ImmutableList<String> tag;

  private ImmutableCatalogOptions(
      Optional<String> datacenter,
      ImmutableList<String> tag) {
    this.datacenter = datacenter;
    this.tag = tag;
  }

  /**
   * @return The value of the {@code datacenter} attribute
   */
  @Override
  public Optional<String> getDatacenter() {
    return datacenter;
  }

  /**
   * @return The value of the {@code tag} attribute
   */
  @Override
  public ImmutableList<String> getTag() {
    return tag;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CatalogOptions#getDatacenter() datacenter} attribute.
   * @param value The value for datacenter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogOptions withDatacenter(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.datacenter.equals(newValue)) return this;
    return new ImmutableCatalogOptions(newValue, this.tag);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CatalogOptions#getDatacenter() datacenter} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for datacenter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogOptions withDatacenter(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "datacenter");
    if (this.datacenter.equals(value)) return this;
    return new ImmutableCatalogOptions(value, this.tag);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CatalogOptions#getTag() tag}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogOptions withTag(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCatalogOptions(this.datacenter, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CatalogOptions#getTag() tag}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of tag elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogOptions withTag(Iterable<String> elements) {
    if (this.tag == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCatalogOptions(this.datacenter, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCatalogOptions} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCatalogOptions
        && equalTo((ImmutableCatalogOptions) another);
  }

  private boolean equalTo(ImmutableCatalogOptions another) {
    return datacenter.equals(another.datacenter)
        && tag.equals(another.tag);
  }

  /**
   * Computes a hash code from attributes: {@code datacenter}, {@code tag}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + datacenter.hashCode();
    h = h * 17 + tag.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CatalogOptions} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CatalogOptions")
        .omitNullValues()
        .add("datacenter", datacenter.orNull())
        .add("tag", tag)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link CatalogOptions} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CatalogOptions instance
   */
  public static ImmutableCatalogOptions copyOf(CatalogOptions instance) {
    if (instance instanceof ImmutableCatalogOptions) {
      return (ImmutableCatalogOptions) instance;
    }
    return ImmutableCatalogOptions.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCatalogOptions ImmutableCatalogOptions}.
   * @return A new ImmutableCatalogOptions builder
   */
  public static ImmutableCatalogOptions.Builder builder() {
    return new ImmutableCatalogOptions.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCatalogOptions ImmutableCatalogOptions}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private Optional<String> datacenter = Optional.absent();
    private ImmutableList.Builder<String> tagBuilder = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CatalogOptions} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CatalogOptions instance) {
      Preconditions.checkNotNull(instance, "instance");
      Optional<String> datacenterOptional = instance.getDatacenter();
      if (datacenterOptional.isPresent()) {
        datacenter(datacenterOptional);
      }
      addAllTag(instance.getTag());
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogOptions#getDatacenter() datacenter} to datacenter.
     * @param datacenter The value for datacenter
     * @return {@code this} builder for chained invocation
     */
    public final Builder datacenter(String datacenter) {
      this.datacenter = Optional.of(datacenter);
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogOptions#getDatacenter() datacenter} to datacenter.
     * @param datacenter The value for datacenter
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder datacenter(Optional<String> datacenter) {
      this.datacenter = Preconditions.checkNotNull(datacenter, "datacenter");
      return this;
    }

    /**
     * Adds one element to {@link CatalogOptions#getTag() tag} list.
     * @param element A tag element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addTag(String element) {
      tagBuilder.add(element);
      return this;
    }

    /**
     * Adds elements to {@link CatalogOptions#getTag() tag} list.
     * @param elements An array of tag elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addTag(String... elements) {
      tagBuilder.add(elements);
      return this;
    }

    /**
     * Sets or replaces all elements for {@link CatalogOptions#getTag() tag} list.
     * @param elements An iterable of tag elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tag(Iterable<String> elements) {
      tagBuilder = ImmutableList.builder();
      return addAllTag(elements);
    }

    /**
     * Adds elements to {@link CatalogOptions#getTag() tag} list.
     * @param elements An iterable of tag elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTag(Iterable<String> elements) {
      tagBuilder.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableCatalogOptions ImmutableCatalogOptions}.
     * @return An immutable instance of CatalogOptions
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCatalogOptions build() {
      return new ImmutableCatalogOptions(datacenter, tagBuilder.build());
    }
  }
}
