/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.option;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.orbitz.consul.option.CatalogOptions;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableCatalogOptions
extends CatalogOptions {
    private final Optional<String> datacenter;
    private final ImmutableList<String> tag;

    private ImmutableCatalogOptions(Optional<String> datacenter, ImmutableList<String> tag) {
        this.datacenter = datacenter;
        this.tag = tag;
    }

    @Override
    public Optional<String> getDatacenter() {
        return this.datacenter;
    }

    public ImmutableList<String> getTag() {
        return this.tag;
    }

    public final ImmutableCatalogOptions withDatacenter(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.datacenter.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableCatalogOptions((Optional<String>)newValue, this.tag);
    }

    public final ImmutableCatalogOptions withDatacenter(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"datacenter");
        if (this.datacenter.equals((Object)value)) {
            return this;
        }
        return new ImmutableCatalogOptions((Optional<String>)value, this.tag);
    }

    public final ImmutableCatalogOptions withTag(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCatalogOptions(this.datacenter, (ImmutableList<String>)newValue);
    }

    public final ImmutableCatalogOptions withTag(Iterable<String> elements) {
        if (this.tag == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCatalogOptions(this.datacenter, (ImmutableList<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCatalogOptions && this.equalTo((ImmutableCatalogOptions)another);
    }

    private boolean equalTo(ImmutableCatalogOptions another) {
        return this.datacenter.equals(another.datacenter) && this.tag.equals(another.tag);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.datacenter.hashCode();
        h = h * 17 + this.tag.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CatalogOptions").omitNullValues().add("datacenter", this.datacenter.orNull()).add("tag", this.tag).toString();
    }

    public static ImmutableCatalogOptions copyOf(CatalogOptions instance) {
        if (instance instanceof ImmutableCatalogOptions) {
            return (ImmutableCatalogOptions)instance;
        }
        return ImmutableCatalogOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private Optional<String> datacenter = Optional.absent();
        private ImmutableList.Builder<String> tagBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(CatalogOptions instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Optional<String> datacenterOptional = instance.getDatacenter();
            if (datacenterOptional.isPresent()) {
                this.datacenter(datacenterOptional);
            }
            this.addAllTag(instance.getTag());
            return this;
        }

        public final Builder datacenter(String datacenter) {
            this.datacenter = Optional.of((Object)datacenter);
            return this;
        }

        public final Builder datacenter(Optional<String> datacenter) {
            this.datacenter = (Optional)Preconditions.checkNotNull(datacenter, (Object)"datacenter");
            return this;
        }

        public final Builder addTag(String element) {
            this.tagBuilder.add((Object)element);
            return this;
        }

        public final Builder addTag(String ... elements) {
            this.tagBuilder.add((Object[])elements);
            return this;
        }

        public final Builder tag(Iterable<String> elements) {
            this.tagBuilder = ImmutableList.builder();
            return this.addAllTag(elements);
        }

        public final Builder addAllTag(Iterable<String> elements) {
            this.tagBuilder.addAll(elements);
            return this;
        }

        public ImmutableCatalogOptions build() {
            return new ImmutableCatalogOptions(this.datacenter, this.tagBuilder.build());
        }
    }
}

