/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul;

import java.io.IOException;
import retrofit2.Response;

public class ConsulException
extends RuntimeException {
    private int code;

    public ConsulException(String message) {
        super(message);
    }

    public ConsulException(String message, Throwable throwable) {
        super(message, throwable);
    }

    public ConsulException(int code, Response<?> response) {
        super(String.format("Consul request failed with status [%s]: %s", code, ConsulException.message(response)));
        this.code = code;
    }

    public ConsulException(Throwable throwable) {
        super("Consul request failed", throwable);
    }

    static String message(Response response) {
        try {
            return response.errorBody().string();
        }
        catch (IOException e) {
            return response.message();
        }
    }

    public int getCode() {
        return this.code;
    }
}

