package com.orbitz.consul.option;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Booleans;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link DeleteOptions}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDeleteOptions.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "DeleteOptions"})
@Immutable
public final class ImmutableDeleteOptions extends DeleteOptions {
  private final Optional<Long> cas;
  private final Optional<Boolean> recurse;
  private final boolean isRecurse;

  private ImmutableDeleteOptions(
      Optional<Long> cas,
      Optional<Boolean> recurse) {
    this.cas = cas;
    this.recurse = recurse;
    this.isRecurse = super.isRecurse();
  }

  /**
   * @return The value of the {@code cas} attribute
   */
  @Override
  public Optional<Long> getCas() {
    return cas;
  }

  /**
   * @return The value of the {@code recurse} attribute
   */
  @Override
  public Optional<Boolean> getRecurse() {
    return recurse;
  }

  /**
   * @return The computed-at-construction value of the {@code isRecurse} attribute
   */
  @Override
  public boolean isRecurse() {
    return isRecurse;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link DeleteOptions#getCas() cas} attribute.
   * @param value The value for cas
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDeleteOptions withCas(long value) {
    Optional<Long> newValue = Optional.of(value);
    if (this.cas.equals(newValue)) return this;
    return new ImmutableDeleteOptions(newValue, this.recurse);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link DeleteOptions#getCas() cas} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for cas
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDeleteOptions withCas(Optional<Long> optional) {
    Optional<Long> value = Preconditions.checkNotNull(optional, "cas");
    if (this.cas.equals(value)) return this;
    return new ImmutableDeleteOptions(value, this.recurse);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link DeleteOptions#getRecurse() recurse} attribute.
   * @param value The value for recurse
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDeleteOptions withRecurse(boolean value) {
    Optional<Boolean> newValue = Optional.of(value);
    if (this.recurse.equals(newValue)) return this;
    return new ImmutableDeleteOptions(this.cas, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link DeleteOptions#getRecurse() recurse} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for recurse
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDeleteOptions withRecurse(Optional<Boolean> optional) {
    Optional<Boolean> value = Preconditions.checkNotNull(optional, "recurse");
    if (this.recurse.equals(value)) return this;
    return new ImmutableDeleteOptions(this.cas, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDeleteOptions} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDeleteOptions
        && equalTo((ImmutableDeleteOptions) another);
  }

  private boolean equalTo(ImmutableDeleteOptions another) {
    return cas.equals(another.cas)
        && recurse.equals(another.recurse)
        && isRecurse == another.isRecurse;
  }

  /**
   * Computes a hash code from attributes: {@code cas}, {@code recurse}, {@code isRecurse}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + cas.hashCode();
    h = h * 17 + recurse.hashCode();
    h = h * 17 + Booleans.hashCode(isRecurse);
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteOptions} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("DeleteOptions")
        .omitNullValues()
        .add("cas", cas.orNull())
        .add("recurse", recurse.orNull())
        .add("isRecurse", isRecurse)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link DeleteOptions} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DeleteOptions instance
   */
  public static ImmutableDeleteOptions copyOf(DeleteOptions instance) {
    if (instance instanceof ImmutableDeleteOptions) {
      return (ImmutableDeleteOptions) instance;
    }
    return ImmutableDeleteOptions.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDeleteOptions ImmutableDeleteOptions}.
   * @return A new ImmutableDeleteOptions builder
   */
  public static ImmutableDeleteOptions.Builder builder() {
    return new ImmutableDeleteOptions.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDeleteOptions ImmutableDeleteOptions}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private Optional<Long> cas = Optional.absent();
    private Optional<Boolean> recurse = Optional.absent();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteOptions} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteOptions instance) {
      Preconditions.checkNotNull(instance, "instance");
      Optional<Long> casOptional = instance.getCas();
      if (casOptional.isPresent()) {
        cas(casOptional);
      }
      Optional<Boolean> recurseOptional = instance.getRecurse();
      if (recurseOptional.isPresent()) {
        recurse(recurseOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link DeleteOptions#getCas() cas} to cas.
     * @param cas The value for cas
     * @return {@code this} builder for chained invocation
     */
    public final Builder cas(long cas) {
      this.cas = Optional.of(cas);
      return this;
    }

    /**
     * Initializes the optional value {@link DeleteOptions#getCas() cas} to cas.
     * @param cas The value for cas
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder cas(Optional<Long> cas) {
      this.cas = Preconditions.checkNotNull(cas, "cas");
      return this;
    }

    /**
     * Initializes the optional value {@link DeleteOptions#getRecurse() recurse} to recurse.
     * @param recurse The value for recurse
     * @return {@code this} builder for chained invocation
     */
    public final Builder recurse(boolean recurse) {
      this.recurse = Optional.of(recurse);
      return this;
    }

    /**
     * Initializes the optional value {@link DeleteOptions#getRecurse() recurse} to recurse.
     * @param recurse The value for recurse
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder recurse(Optional<Boolean> recurse) {
      this.recurse = Preconditions.checkNotNull(recurse, "recurse");
      return this;
    }

    /**
     * Builds a new {@link ImmutableDeleteOptions ImmutableDeleteOptions}.
     * @return An immutable instance of DeleteOptions
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDeleteOptions build() {
      return new ImmutableDeleteOptions(cas, recurse);
    }
  }
}
