package com.orbitz.consul.model.coordinate;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link Coord}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCoord.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "Coord"})
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableCoord extends Coord {
  private final double adjustment;
  private final double error;
  private final double height;
  private final double[] vec;

  private ImmutableCoord(double adjustment, double error, double height, double[] vec) {
    this.adjustment = adjustment;
    this.error = error;
    this.height = height;
    this.vec = vec;
  }

  /**
   * @return The value of the {@code adjustment} attribute
   */
  @JsonProperty(value = "Adjustment")
  @Override
  public double getAdjustment() {
    return adjustment;
  }

  /**
   * @return The value of the {@code error} attribute
   */
  @JsonProperty(value = "Error")
  @Override
  public double getError() {
    return error;
  }

  /**
   * @return The value of the {@code height} attribute
   */
  @JsonProperty(value = "Height")
  @Override
  public double getHeight() {
    return height;
  }

  /**
   * @return A cloned {@code vec} array
   */
  @JsonProperty(value = "Vec")
  @Override
  public double[] getVec() {
    return vec.clone();
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Coord#getAdjustment() adjustment} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for adjustment
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCoord withAdjustment(double value) {
    if (Double.doubleToLongBits(this.adjustment) == Double.doubleToLongBits(value)) return this;
    return new ImmutableCoord(value, this.error, this.height, this.vec);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Coord#getError() error} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for error
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCoord withError(double value) {
    if (Double.doubleToLongBits(this.error) == Double.doubleToLongBits(value)) return this;
    return new ImmutableCoord(this.adjustment, value, this.height, this.vec);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Coord#getHeight() height} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for height
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCoord withHeight(double value) {
    if (Double.doubleToLongBits(this.height) == Double.doubleToLongBits(value)) return this;
    return new ImmutableCoord(this.adjustment, this.error, value, this.vec);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Coord#getVec() vec}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for vec
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCoord withVec(double... elements) {
    double[] newValue = elements.clone();
    return new ImmutableCoord(this.adjustment, this.error, this.height, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCoord} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCoord
        && equalTo((ImmutableCoord) another);
  }

  private boolean equalTo(ImmutableCoord another) {
    return Double.doubleToLongBits(adjustment) == Double.doubleToLongBits(another.adjustment)
        && Double.doubleToLongBits(error) == Double.doubleToLongBits(another.error)
        && Double.doubleToLongBits(height) == Double.doubleToLongBits(another.height)
        && Arrays.equals(vec, another.vec);
  }

  /**
   * Computes a hash code from attributes: {@code adjustment}, {@code error}, {@code height}, {@code vec}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Doubles.hashCode(adjustment);
    h = h * 17 + Doubles.hashCode(error);
    h = h * 17 + Doubles.hashCode(height);
    h = h * 17 + Arrays.hashCode(vec);
    return h;
  }

  /**
   * Prints the immutable value {@code Coord} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Coord")
        .omitNullValues()
        .add("adjustment", adjustment)
        .add("error", error)
        .add("height", height)
        .add("vec", Arrays.toString(vec))
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends Coord {
    @Nullable Double adjustment;
    @Nullable Double error;
    @Nullable Double height;
    @Nullable double[] vec;
    @JsonProperty(value = "Adjustment")
    public void setAdjustment(double adjustment) {
      this.adjustment = adjustment;
    }
    @JsonProperty(value = "Error")
    public void setError(double error) {
      this.error = error;
    }
    @JsonProperty(value = "Height")
    public void setHeight(double height) {
      this.height = height;
    }
    @JsonProperty(value = "Vec")
    public void setVec(double[] vec) {
      this.vec = vec;
    }
    @Override
    public double getAdjustment() { throw new UnsupportedOperationException(); }
    @Override
    public double getError() { throw new UnsupportedOperationException(); }
    @Override
    public double getHeight() { throw new UnsupportedOperationException(); }
    @Override
    public double[] getVec() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableCoord fromJson(Json json) {
    ImmutableCoord.Builder builder = ImmutableCoord.builder();
    if (json.adjustment != null) {
      builder.adjustment(json.adjustment);
    }
    if (json.error != null) {
      builder.error(json.error);
    }
    if (json.height != null) {
      builder.height(json.height);
    }
    if (json.vec != null) {
      builder.vec(json.vec);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Coord} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Coord instance
   */
  public static ImmutableCoord copyOf(Coord instance) {
    if (instance instanceof ImmutableCoord) {
      return (ImmutableCoord) instance;
    }
    return ImmutableCoord.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCoord ImmutableCoord}.
   * @return A new ImmutableCoord builder
   */
  public static ImmutableCoord.Builder builder() {
    return new ImmutableCoord.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCoord ImmutableCoord}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ADJUSTMENT = 0x1L;
    private static final long INIT_BIT_ERROR = 0x2L;
    private static final long INIT_BIT_HEIGHT = 0x4L;
    private static final long INIT_BIT_VEC = 0x8L;
    private long initBits = 0xf;

    private double adjustment;
    private double error;
    private double height;
    private @Nullable double[] vec;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Coord} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Coord instance) {
      Preconditions.checkNotNull(instance, "instance");
      adjustment(instance.getAdjustment());
      error(instance.getError());
      height(instance.getHeight());
      vec(instance.getVec());
      return this;
    }

    /**
     * Initializes the value for the {@link Coord#getAdjustment() adjustment} attribute.
     * @param adjustment The value for adjustment 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder adjustment(double adjustment) {
      this.adjustment = adjustment;
      initBits &= ~INIT_BIT_ADJUSTMENT;
      return this;
    }

    /**
     * Initializes the value for the {@link Coord#getError() error} attribute.
     * @param error The value for error 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder error(double error) {
      this.error = error;
      initBits &= ~INIT_BIT_ERROR;
      return this;
    }

    /**
     * Initializes the value for the {@link Coord#getHeight() height} attribute.
     * @param height The value for height 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder height(double height) {
      this.height = height;
      initBits &= ~INIT_BIT_HEIGHT;
      return this;
    }

    /**
     * Initializes the value for the {@link Coord#getVec() vec} attribute.
     * @param elements The elements for vec
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder vec(double... elements) {
      this.vec = elements.clone();
      initBits &= ~INIT_BIT_VEC;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCoord ImmutableCoord}.
     * @return An immutable instance of Coord
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCoord build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCoord(adjustment, error, height, vec);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_ADJUSTMENT) != 0) attributes.add("adjustment");
      if ((initBits & INIT_BIT_ERROR) != 0) attributes.add("error");
      if ((initBits & INIT_BIT_HEIGHT) != 0) attributes.add("height");
      if ((initBits & INIT_BIT_VEC) != 0) attributes.add("vec");
      return "Cannot build Coord, some of required attributes are not set " + attributes;
    }
  }
}
