package com.orbitz.consul.model.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link PreparedQuery}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePreparedQuery.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "PreparedQuery"})
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutablePreparedQuery extends PreparedQuery {
  private final String name;
  private final Optional<String> session;
  private final Optional<String> token;
  private final ServiceQuery service;
  private final Optional<DnsQuery> dns;

  private ImmutablePreparedQuery(
      String name,
      Optional<String> session,
      Optional<String> token,
      ServiceQuery service,
      Optional<DnsQuery> dns) {
    this.name = name;
    this.session = session;
    this.token = token;
    this.service = service;
    this.dns = dns;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty(value = "Name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code session} attribute
   */
  @JsonProperty(value = "Session")
  @Override
  public Optional<String> getSession() {
    return session;
  }

  /**
   * @return The value of the {@code token} attribute
   */
  @JsonProperty(value = "Token")
  @Override
  public Optional<String> getToken() {
    return token;
  }

  /**
   * @return The value of the {@code service} attribute
   */
  @JsonProperty(value = "Service")
  @Override
  public ServiceQuery getService() {
    return service;
  }

  /**
   * @return The value of the {@code dns} attribute
   */
  @JsonProperty(value = "DNS")
  @Override
  public Optional<DnsQuery> getDns() {
    return dns;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PreparedQuery#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePreparedQuery withName(String value) {
    if (this.name.equals(value)) return this;
    return new ImmutablePreparedQuery(
        Preconditions.checkNotNull(value, "name"),
        this.session,
        this.token,
        this.service,
        this.dns);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PreparedQuery#getSession() session} attribute.
   * @param value The value for session
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePreparedQuery withSession(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.session.equals(newValue)) return this;
    return new ImmutablePreparedQuery(this.name, newValue, this.token, this.service, this.dns);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PreparedQuery#getSession() session} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for session
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePreparedQuery withSession(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "session");
    if (this.session.equals(value)) return this;
    return new ImmutablePreparedQuery(this.name, value, this.token, this.service, this.dns);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PreparedQuery#getToken() token} attribute.
   * @param value The value for token
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePreparedQuery withToken(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.token.equals(newValue)) return this;
    return new ImmutablePreparedQuery(this.name, this.session, newValue, this.service, this.dns);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PreparedQuery#getToken() token} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for token
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePreparedQuery withToken(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "token");
    if (this.token.equals(value)) return this;
    return new ImmutablePreparedQuery(this.name, this.session, value, this.service, this.dns);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PreparedQuery#getService() service} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for service
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePreparedQuery withService(ServiceQuery value) {
    if (this.service == value) return this;
    return new ImmutablePreparedQuery(
        this.name,
        this.session,
        this.token,
        Preconditions.checkNotNull(value, "service"),
        this.dns);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PreparedQuery#getDns() dns} attribute.
   * @param value The value for dns
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePreparedQuery withDns(DnsQuery value) {
    Optional<DnsQuery> newValue = Optional.of(value);
    if (this.dns.isPresent() && this.dns.get() == value) return this;
    return new ImmutablePreparedQuery(this.name, this.session, this.token, this.service, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PreparedQuery#getDns() dns} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for dns
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePreparedQuery withDns(Optional<DnsQuery> optional) {
    Optional<DnsQuery> value = Preconditions.checkNotNull(optional, "dns");
    if (!this.dns.isPresent() && !value.isPresent()) return this;
    if (this.dns.isPresent() && value.isPresent() && this.dns.get() == value.get()) return this;
    return new ImmutablePreparedQuery(this.name, this.session, this.token, this.service, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePreparedQuery} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePreparedQuery
        && equalTo((ImmutablePreparedQuery) another);
  }

  private boolean equalTo(ImmutablePreparedQuery another) {
    return name.equals(another.name)
        && session.equals(another.session)
        && token.equals(another.token)
        && service.equals(another.service)
        && dns.equals(another.dns);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code session}, {@code token}, {@code service}, {@code dns}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + name.hashCode();
    h = h * 17 + session.hashCode();
    h = h * 17 + token.hashCode();
    h = h * 17 + service.hashCode();
    h = h * 17 + dns.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PreparedQuery} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PreparedQuery")
        .omitNullValues()
        .add("name", name)
        .add("session", session.orNull())
        .add("token", token.orNull())
        .add("service", service)
        .add("dns", dns.orNull())
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends PreparedQuery {
    @Nullable String name;
    Optional<String> session = Optional.absent();
    Optional<String> token = Optional.absent();
    @Nullable ServiceQuery service;
    Optional<DnsQuery> dns = Optional.absent();
    @JsonProperty(value = "Name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty(value = "Session")
    public void setSession(Optional<String> session) {
      this.session = session;
    }
    @JsonProperty(value = "Token")
    public void setToken(Optional<String> token) {
      this.token = token;
    }
    @JsonProperty(value = "Service")
    public void setService(ServiceQuery service) {
      this.service = service;
    }
    @JsonProperty(value = "DNS")
    public void setDns(Optional<DnsQuery> dns) {
      this.dns = dns;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getSession() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getToken() { throw new UnsupportedOperationException(); }
    @Override
    public ServiceQuery getService() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<DnsQuery> getDns() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutablePreparedQuery fromJson(Json json) {
    ImmutablePreparedQuery.Builder builder = ImmutablePreparedQuery.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.session != null) {
      builder.session(json.session);
    }
    if (json.token != null) {
      builder.token(json.token);
    }
    if (json.service != null) {
      builder.service(json.service);
    }
    if (json.dns != null) {
      builder.dns(json.dns);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PreparedQuery} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PreparedQuery instance
   */
  public static ImmutablePreparedQuery copyOf(PreparedQuery instance) {
    if (instance instanceof ImmutablePreparedQuery) {
      return (ImmutablePreparedQuery) instance;
    }
    return ImmutablePreparedQuery.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePreparedQuery ImmutablePreparedQuery}.
   * @return A new ImmutablePreparedQuery builder
   */
  public static ImmutablePreparedQuery.Builder builder() {
    return new ImmutablePreparedQuery.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePreparedQuery ImmutablePreparedQuery}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_SERVICE = 0x2L;
    private long initBits = 0x3;

    private @Nullable String name;
    private Optional<String> session = Optional.absent();
    private Optional<String> token = Optional.absent();
    private @Nullable ServiceQuery service;
    private Optional<DnsQuery> dns = Optional.absent();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PreparedQuery} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PreparedQuery instance) {
      Preconditions.checkNotNull(instance, "instance");
      name(instance.getName());
      Optional<String> sessionOptional = instance.getSession();
      if (sessionOptional.isPresent()) {
        session(sessionOptional);
      }
      Optional<String> tokenOptional = instance.getToken();
      if (tokenOptional.isPresent()) {
        token(tokenOptional);
      }
      service(instance.getService());
      Optional<DnsQuery> dnsOptional = instance.getDns();
      if (dnsOptional.isPresent()) {
        dns(dnsOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link PreparedQuery#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Preconditions.checkNotNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the optional value {@link PreparedQuery#getSession() session} to session.
     * @param session The value for session
     * @return {@code this} builder for chained invocation
     */
    public final Builder session(String session) {
      this.session = Optional.of(session);
      return this;
    }

    /**
     * Initializes the optional value {@link PreparedQuery#getSession() session} to session.
     * @param session The value for session
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder session(Optional<String> session) {
      this.session = Preconditions.checkNotNull(session, "session");
      return this;
    }

    /**
     * Initializes the optional value {@link PreparedQuery#getToken() token} to token.
     * @param token The value for token
     * @return {@code this} builder for chained invocation
     */
    public final Builder token(String token) {
      this.token = Optional.of(token);
      return this;
    }

    /**
     * Initializes the optional value {@link PreparedQuery#getToken() token} to token.
     * @param token The value for token
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder token(Optional<String> token) {
      this.token = Preconditions.checkNotNull(token, "token");
      return this;
    }

    /**
     * Initializes the value for the {@link PreparedQuery#getService() service} attribute.
     * @param service The value for service 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder service(ServiceQuery service) {
      this.service = Preconditions.checkNotNull(service, "service");
      initBits &= ~INIT_BIT_SERVICE;
      return this;
    }

    /**
     * Initializes the optional value {@link PreparedQuery#getDns() dns} to dns.
     * @param dns The value for dns
     * @return {@code this} builder for chained invocation
     */
    public final Builder dns(DnsQuery dns) {
      this.dns = Optional.of(dns);
      return this;
    }

    /**
     * Initializes the optional value {@link PreparedQuery#getDns() dns} to dns.
     * @param dns The value for dns
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dns(Optional<DnsQuery> dns) {
      this.dns = Preconditions.checkNotNull(dns, "dns");
      return this;
    }

    /**
     * Builds a new {@link ImmutablePreparedQuery ImmutablePreparedQuery}.
     * @return An immutable instance of PreparedQuery
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePreparedQuery build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePreparedQuery(name, session, token, service, dns);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_SERVICE) != 0) attributes.add("service");
      return "Cannot build PreparedQuery, some of required attributes are not set " + attributes;
    }
  }
}
