package com.orbitz.consul.model.session;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.orbitz.consul.util.SecondsDeserializer;
import com.orbitz.consul.util.SecondsSerializer;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SessionInfo}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSessionInfo.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SessionInfo"})
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableSessionInfo extends SessionInfo {
  private final long createIndex;
  private final Long lockDelay;
  private final Optional<String> name;
  private final String node;
  private final ImmutableList<String> checks;
  private final String behavior;
  private final Optional<String> ttl;
  private final String id;

  private ImmutableSessionInfo(
      long createIndex,
      Long lockDelay,
      Optional<String> name,
      String node,
      ImmutableList<String> checks,
      String behavior,
      Optional<String> ttl,
      String id) {
    this.createIndex = createIndex;
    this.lockDelay = lockDelay;
    this.name = name;
    this.node = node;
    this.checks = checks;
    this.behavior = behavior;
    this.ttl = ttl;
    this.id = id;
  }

  /**
   * @return The value of the {@code createIndex} attribute
   */
  @JsonProperty(value = "CreateIndex")
  @Override
  public long getCreateIndex() {
    return createIndex;
  }

  /**
   * @return The value of the {@code lockDelay} attribute
   */
  @JsonProperty(value = "LockDelay")
  @JsonSerialize(using = SecondsSerializer.class)
  @JsonDeserialize(using = SecondsDeserializer.class)
  @Override
  public Long getLockDelay() {
    return lockDelay;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty(value = "Name")
  @Override
  public Optional<String> getName() {
    return name;
  }

  /**
   * @return The value of the {@code node} attribute
   */
  @JsonProperty(value = "Node")
  @Override
  public String getNode() {
    return node;
  }

  /**
   * @return The value of the {@code checks} attribute
   */
  @JsonProperty(value = "Checks")
  @Override
  public ImmutableList<String> getChecks() {
    return checks;
  }

  /**
   * @return The value of the {@code behavior} attribute
   */
  @JsonProperty(value = "Behavior")
  @Override
  public String getBehavior() {
    return behavior;
  }

  /**
   * @return The value of the {@code ttl} attribute
   */
  @JsonProperty(value = "TTL")
  @Override
  public Optional<String> getTtl() {
    return ttl;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty(value = "ID")
  @Override
  public String getId() {
    return id;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SessionInfo#getCreateIndex() createIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSessionInfo withCreateIndex(long value) {
    if (this.createIndex == value) return this;
    return new ImmutableSessionInfo(value, this.lockDelay, this.name, this.node, this.checks, this.behavior, this.ttl, this.id);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SessionInfo#getLockDelay() lockDelay} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for lockDelay
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSessionInfo withLockDelay(Long value) {
    if (this.lockDelay.equals(value)) return this;
    return new ImmutableSessionInfo(
        this.createIndex,
        Preconditions.checkNotNull(value, "lockDelay"),
        this.name,
        this.node,
        this.checks,
        this.behavior,
        this.ttl,
        this.id);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SessionInfo#getName() name} attribute.
   * @param value The value for name
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSessionInfo withName(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.name.equals(newValue)) return this;
    return new ImmutableSessionInfo(
        this.createIndex,
        this.lockDelay,
        newValue,
        this.node,
        this.checks,
        this.behavior,
        this.ttl,
        this.id);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SessionInfo#getName() name} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for name
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSessionInfo withName(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "name");
    if (this.name.equals(value)) return this;
    return new ImmutableSessionInfo(
        this.createIndex,
        this.lockDelay,
        value,
        this.node,
        this.checks,
        this.behavior,
        this.ttl,
        this.id);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SessionInfo#getNode() node} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for node
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSessionInfo withNode(String value) {
    if (this.node.equals(value)) return this;
    return new ImmutableSessionInfo(
        this.createIndex,
        this.lockDelay,
        this.name,
        Preconditions.checkNotNull(value, "node"),
        this.checks,
        this.behavior,
        this.ttl,
        this.id);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SessionInfo#getChecks() checks}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSessionInfo withChecks(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSessionInfo(
        this.createIndex,
        this.lockDelay,
        this.name,
        this.node,
        newValue,
        this.behavior,
        this.ttl,
        this.id);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SessionInfo#getChecks() checks}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of checks elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSessionInfo withChecks(Iterable<String> elements) {
    if (this.checks == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSessionInfo(
        this.createIndex,
        this.lockDelay,
        this.name,
        this.node,
        newValue,
        this.behavior,
        this.ttl,
        this.id);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SessionInfo#getBehavior() behavior} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for behavior
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSessionInfo withBehavior(String value) {
    if (this.behavior.equals(value)) return this;
    return new ImmutableSessionInfo(
        this.createIndex,
        this.lockDelay,
        this.name,
        this.node,
        this.checks,
        Preconditions.checkNotNull(value, "behavior"),
        this.ttl,
        this.id);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SessionInfo#getTtl() ttl} attribute.
   * @param value The value for ttl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSessionInfo withTtl(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.ttl.equals(newValue)) return this;
    return new ImmutableSessionInfo(
        this.createIndex,
        this.lockDelay,
        this.name,
        this.node,
        this.checks,
        this.behavior,
        newValue,
        this.id);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SessionInfo#getTtl() ttl} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for ttl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSessionInfo withTtl(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "ttl");
    if (this.ttl.equals(value)) return this;
    return new ImmutableSessionInfo(
        this.createIndex,
        this.lockDelay,
        this.name,
        this.node,
        this.checks,
        this.behavior,
        value,
        this.id);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SessionInfo#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSessionInfo withId(String value) {
    if (this.id.equals(value)) return this;
    return new ImmutableSessionInfo(
        this.createIndex,
        this.lockDelay,
        this.name,
        this.node,
        this.checks,
        this.behavior,
        this.ttl,
        Preconditions.checkNotNull(value, "id"));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSessionInfo} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSessionInfo
        && equalTo((ImmutableSessionInfo) another);
  }

  private boolean equalTo(ImmutableSessionInfo another) {
    return createIndex == another.createIndex
        && lockDelay.equals(another.lockDelay)
        && name.equals(another.name)
        && node.equals(another.node)
        && checks.equals(another.checks)
        && behavior.equals(another.behavior)
        && ttl.equals(another.ttl)
        && id.equals(another.id);
  }

  /**
   * Computes a hash code from attributes: {@code createIndex}, {@code lockDelay}, {@code name}, {@code node}, {@code checks}, {@code behavior}, {@code ttl}, {@code id}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Longs.hashCode(createIndex);
    h = h * 17 + lockDelay.hashCode();
    h = h * 17 + name.hashCode();
    h = h * 17 + node.hashCode();
    h = h * 17 + checks.hashCode();
    h = h * 17 + behavior.hashCode();
    h = h * 17 + ttl.hashCode();
    h = h * 17 + id.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SessionInfo} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SessionInfo")
        .omitNullValues()
        .add("createIndex", createIndex)
        .add("lockDelay", lockDelay)
        .add("name", name.orNull())
        .add("node", node)
        .add("checks", checks)
        .add("behavior", behavior)
        .add("ttl", ttl.orNull())
        .add("id", id)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends SessionInfo {
    @Nullable Long createIndex;
    @Nullable Long lockDelay;
    Optional<String> name = Optional.absent();
    @Nullable String node;
    List<String> checks = ImmutableList.of();
    @Nullable String behavior;
    Optional<String> ttl = Optional.absent();
    @Nullable String id;
    @JsonProperty(value = "CreateIndex")
    public void setCreateIndex(long createIndex) {
      this.createIndex = createIndex;
    }
    @JsonProperty(value = "LockDelay")
    @JsonSerialize(using = SecondsSerializer.class)
    @JsonDeserialize(using = SecondsDeserializer.class)
    public void setLockDelay(Long lockDelay) {
      this.lockDelay = lockDelay;
    }
    @JsonProperty(value = "Name")
    public void setName(Optional<String> name) {
      this.name = name;
    }
    @JsonProperty(value = "Node")
    public void setNode(String node) {
      this.node = node;
    }
    @JsonProperty(value = "Checks")
    public void setChecks(List<String> checks) {
      this.checks = checks;
    }
    @JsonProperty(value = "Behavior")
    public void setBehavior(String behavior) {
      this.behavior = behavior;
    }
    @JsonProperty(value = "TTL")
    public void setTtl(Optional<String> ttl) {
      this.ttl = ttl;
    }
    @JsonProperty(value = "ID")
    public void setId(String id) {
      this.id = id;
    }
    @Override
    public long getCreateIndex() { throw new UnsupportedOperationException(); }
    @Override
    public Long getLockDelay() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getNode() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getChecks() { throw new UnsupportedOperationException(); }
    @Override
    public String getBehavior() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getTtl() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableSessionInfo fromJson(Json json) {
    ImmutableSessionInfo.Builder builder = ImmutableSessionInfo.builder();
    if (json.createIndex != null) {
      builder.createIndex(json.createIndex);
    }
    if (json.lockDelay != null) {
      builder.lockDelay(json.lockDelay);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.node != null) {
      builder.node(json.node);
    }
    if (json.checks != null) {
      builder.addAllChecks(json.checks);
    }
    if (json.behavior != null) {
      builder.behavior(json.behavior);
    }
    if (json.ttl != null) {
      builder.ttl(json.ttl);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SessionInfo} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SessionInfo instance
   */
  public static ImmutableSessionInfo copyOf(SessionInfo instance) {
    if (instance instanceof ImmutableSessionInfo) {
      return (ImmutableSessionInfo) instance;
    }
    return ImmutableSessionInfo.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSessionInfo ImmutableSessionInfo}.
   * @return A new ImmutableSessionInfo builder
   */
  public static ImmutableSessionInfo.Builder builder() {
    return new ImmutableSessionInfo.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSessionInfo ImmutableSessionInfo}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CREATE_INDEX = 0x1L;
    private static final long INIT_BIT_LOCK_DELAY = 0x2L;
    private static final long INIT_BIT_NODE = 0x4L;
    private static final long INIT_BIT_BEHAVIOR = 0x8L;
    private static final long INIT_BIT_ID = 0x10L;
    private long initBits = 0x1f;

    private long createIndex;
    private @Nullable Long lockDelay;
    private Optional<String> name = Optional.absent();
    private @Nullable String node;
    private ImmutableList.Builder<String> checksBuilder = ImmutableList.builder();
    private @Nullable String behavior;
    private Optional<String> ttl = Optional.absent();
    private @Nullable String id;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SessionInfo} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SessionInfo instance) {
      Preconditions.checkNotNull(instance, "instance");
      createIndex(instance.getCreateIndex());
      lockDelay(instance.getLockDelay());
      Optional<String> nameOptional = instance.getName();
      if (nameOptional.isPresent()) {
        name(nameOptional);
      }
      node(instance.getNode());
      addAllChecks(instance.getChecks());
      behavior(instance.getBehavior());
      Optional<String> ttlOptional = instance.getTtl();
      if (ttlOptional.isPresent()) {
        ttl(ttlOptional);
      }
      id(instance.getId());
      return this;
    }

    /**
     * Initializes the value for the {@link SessionInfo#getCreateIndex() createIndex} attribute.
     * @param createIndex The value for createIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder createIndex(long createIndex) {
      this.createIndex = createIndex;
      initBits &= ~INIT_BIT_CREATE_INDEX;
      return this;
    }

    /**
     * Initializes the value for the {@link SessionInfo#getLockDelay() lockDelay} attribute.
     * @param lockDelay The value for lockDelay 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder lockDelay(Long lockDelay) {
      this.lockDelay = Preconditions.checkNotNull(lockDelay, "lockDelay");
      initBits &= ~INIT_BIT_LOCK_DELAY;
      return this;
    }

    /**
     * Initializes the optional value {@link SessionInfo#getName() name} to name.
     * @param name The value for name
     * @return {@code this} builder for chained invocation
     */
    public final Builder name(String name) {
      this.name = Optional.of(name);
      return this;
    }

    /**
     * Initializes the optional value {@link SessionInfo#getName() name} to name.
     * @param name The value for name
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(Optional<String> name) {
      this.name = Preconditions.checkNotNull(name, "name");
      return this;
    }

    /**
     * Initializes the value for the {@link SessionInfo#getNode() node} attribute.
     * @param node The value for node 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder node(String node) {
      this.node = Preconditions.checkNotNull(node, "node");
      initBits &= ~INIT_BIT_NODE;
      return this;
    }

    /**
     * Adds one element to {@link SessionInfo#getChecks() checks} list.
     * @param element A checks element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addChecks(String element) {
      checksBuilder.add(element);
      return this;
    }

    /**
     * Adds elements to {@link SessionInfo#getChecks() checks} list.
     * @param elements An array of checks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addChecks(String... elements) {
      checksBuilder.add(elements);
      return this;
    }

    /**
     * Sets or replaces all elements for {@link SessionInfo#getChecks() checks} list.
     * @param elements An iterable of checks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder checks(Iterable<String> elements) {
      checksBuilder = ImmutableList.builder();
      return addAllChecks(elements);
    }

    /**
     * Adds elements to {@link SessionInfo#getChecks() checks} list.
     * @param elements An iterable of checks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllChecks(Iterable<String> elements) {
      checksBuilder.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link SessionInfo#getBehavior() behavior} attribute.
     * @param behavior The value for behavior 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder behavior(String behavior) {
      this.behavior = Preconditions.checkNotNull(behavior, "behavior");
      initBits &= ~INIT_BIT_BEHAVIOR;
      return this;
    }

    /**
     * Initializes the optional value {@link SessionInfo#getTtl() ttl} to ttl.
     * @param ttl The value for ttl
     * @return {@code this} builder for chained invocation
     */
    public final Builder ttl(String ttl) {
      this.ttl = Optional.of(ttl);
      return this;
    }

    /**
     * Initializes the optional value {@link SessionInfo#getTtl() ttl} to ttl.
     * @param ttl The value for ttl
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ttl(Optional<String> ttl) {
      this.ttl = Preconditions.checkNotNull(ttl, "ttl");
      return this;
    }

    /**
     * Initializes the value for the {@link SessionInfo#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Preconditions.checkNotNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSessionInfo ImmutableSessionInfo}.
     * @return An immutable instance of SessionInfo
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSessionInfo build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSessionInfo(createIndex, lockDelay, name, node, checksBuilder.build(), behavior, ttl, id);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_CREATE_INDEX) != 0) attributes.add("createIndex");
      if ((initBits & INIT_BIT_LOCK_DELAY) != 0) attributes.add("lockDelay");
      if ((initBits & INIT_BIT_NODE) != 0) attributes.add("node");
      if ((initBits & INIT_BIT_BEHAVIOR) != 0) attributes.add("behavior");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build SessionInfo, some of required attributes are not set " + attributes;
    }
  }
}
