/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.orbitz.consul.model.acl.AclToken;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableAclToken
extends AclToken {
    private final Optional<String> id;
    private final Optional<String> name;
    private final Optional<String> type;
    private final Optional<String> rules;

    private ImmutableAclToken(Optional<String> id, Optional<String> name, Optional<String> type, Optional<String> rules) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.rules = rules;
    }

    @Override
    @JsonProperty(value="ID")
    public Optional<String> id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Name")
    public Optional<String> name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Type")
    public Optional<String> type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="Rules")
    public Optional<String> rules() {
        return this.rules;
    }

    public final ImmutableAclToken withId(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.id.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableAclToken((Optional<String>)newValue, this.name, this.type, this.rules);
    }

    public final ImmutableAclToken withId(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"id");
        if (this.id.equals((Object)value)) {
            return this;
        }
        return new ImmutableAclToken((Optional<String>)value, this.name, this.type, this.rules);
    }

    public final ImmutableAclToken withName(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.name.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableAclToken(this.id, (Optional<String>)newValue, this.type, this.rules);
    }

    public final ImmutableAclToken withName(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"name");
        if (this.name.equals((Object)value)) {
            return this;
        }
        return new ImmutableAclToken(this.id, (Optional<String>)value, this.type, this.rules);
    }

    public final ImmutableAclToken withType(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.type.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableAclToken(this.id, this.name, (Optional<String>)newValue, this.rules);
    }

    public final ImmutableAclToken withType(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"type");
        if (this.type.equals((Object)value)) {
            return this;
        }
        return new ImmutableAclToken(this.id, this.name, (Optional<String>)value, this.rules);
    }

    public final ImmutableAclToken withRules(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.rules.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableAclToken(this.id, this.name, this.type, (Optional<String>)newValue);
    }

    public final ImmutableAclToken withRules(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"rules");
        if (this.rules.equals((Object)value)) {
            return this;
        }
        return new ImmutableAclToken(this.id, this.name, this.type, (Optional<String>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAclToken && this.equalTo((ImmutableAclToken)another);
    }

    private boolean equalTo(ImmutableAclToken another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && this.type.equals(another.type) && this.rules.equals(another.rules);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id.hashCode();
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.rules.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AclToken").omitNullValues().add("id", this.id.orNull()).add("name", this.name.orNull()).add("type", this.type.orNull()).add("rules", this.rules.orNull()).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableAclToken fromJson(Json json) {
        Builder builder = ImmutableAclToken.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.rules != null) {
            builder.rules(json.rules);
        }
        return builder.build();
    }

    public static ImmutableAclToken copyOf(AclToken instance) {
        if (instance instanceof ImmutableAclToken) {
            return (ImmutableAclToken)instance;
        }
        return ImmutableAclToken.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private Optional<String> id = Optional.absent();
        private Optional<String> name = Optional.absent();
        private Optional<String> type = Optional.absent();
        private Optional<String> rules = Optional.absent();

        private Builder() {
        }

        public final Builder from(AclToken instance) {
            Optional<String> rulesOptional;
            Optional<String> typeOptional;
            Optional<String> nameOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Optional<String> idOptional = instance.id();
            if (idOptional.isPresent()) {
                this.id(idOptional);
            }
            if ((nameOptional = instance.name()).isPresent()) {
                this.name(nameOptional);
            }
            if ((typeOptional = instance.type()).isPresent()) {
                this.type(typeOptional);
            }
            if ((rulesOptional = instance.rules()).isPresent()) {
                this.rules(rulesOptional);
            }
            return this;
        }

        public final Builder id(String id) {
            this.id = Optional.of((Object)id);
            return this;
        }

        public final Builder id(Optional<String> id) {
            this.id = (Optional)Preconditions.checkNotNull(id, (Object)"id");
            return this;
        }

        public final Builder name(String name) {
            this.name = Optional.of((Object)name);
            return this;
        }

        public final Builder name(Optional<String> name) {
            this.name = (Optional)Preconditions.checkNotNull(name, (Object)"name");
            return this;
        }

        public final Builder type(String type) {
            this.type = Optional.of((Object)type);
            return this;
        }

        public final Builder type(Optional<String> type) {
            this.type = (Optional)Preconditions.checkNotNull(type, (Object)"type");
            return this;
        }

        public final Builder rules(String rules) {
            this.rules = Optional.of((Object)rules);
            return this;
        }

        public final Builder rules(Optional<String> rules) {
            this.rules = (Optional)Preconditions.checkNotNull(rules, (Object)"rules");
            return this;
        }

        public ImmutableAclToken build() {
            return new ImmutableAclToken(this.id, this.name, this.type, this.rules);
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends AclToken {
        Optional<String> id = Optional.absent();
        Optional<String> name = Optional.absent();
        Optional<String> type = Optional.absent();
        Optional<String> rules = Optional.absent();

        Json() {
        }

        @JsonProperty(value="ID")
        public void setId(Optional<String> id) {
            this.id = id;
        }

        @JsonProperty(value="Name")
        public void setName(Optional<String> name) {
            this.name = name;
        }

        @JsonProperty(value="Type")
        public void setType(Optional<String> type) {
            this.type = type;
        }

        @JsonProperty(value="Rules")
        public void setRules(Optional<String> rules) {
            this.rules = rules;
        }

        @Override
        public Optional<String> id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> rules() {
            throw new UnsupportedOperationException();
        }
    }
}

