package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link DebugConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDebugConfig.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "DebugConfig"})
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableDebugConfig extends DebugConfig {
  private final boolean bootstrap;
  private final String datacenter;
  private final String dataDir;
  private final ImmutableList<String> dnsRecursors;
  private final String dnsDomain;
  private final String logLevel;
  private final String nodeName;
  private final ImmutableList<String> clientAddrs;
  private final String bindAddr;
  private final boolean leaveOnTerm;
  private final boolean skipLeaveOnInt;
  private final boolean enableDebug;
  private final boolean verifyIncoming;
  private final boolean verifyOutgoing;
  private final String caFile;
  private final String certFile;
  private final String keyFile;
  private final Optional<String> uiDir;
  private final String pidFile;
  private final boolean enableSyslog;
  private final boolean rejoinAfterLeave;
  private final String advertiseAddrLAN;
  private final String advertiseAddrWAN;

  private ImmutableDebugConfig(
      boolean bootstrap,
      String datacenter,
      String dataDir,
      ImmutableList<String> dnsRecursors,
      String dnsDomain,
      String logLevel,
      String nodeName,
      ImmutableList<String> clientAddrs,
      String bindAddr,
      boolean leaveOnTerm,
      boolean skipLeaveOnInt,
      boolean enableDebug,
      boolean verifyIncoming,
      boolean verifyOutgoing,
      String caFile,
      String certFile,
      String keyFile,
      Optional<String> uiDir,
      String pidFile,
      boolean enableSyslog,
      boolean rejoinAfterLeave,
      String advertiseAddrLAN,
      String advertiseAddrWAN) {
    this.bootstrap = bootstrap;
    this.datacenter = datacenter;
    this.dataDir = dataDir;
    this.dnsRecursors = dnsRecursors;
    this.dnsDomain = dnsDomain;
    this.logLevel = logLevel;
    this.nodeName = nodeName;
    this.clientAddrs = clientAddrs;
    this.bindAddr = bindAddr;
    this.leaveOnTerm = leaveOnTerm;
    this.skipLeaveOnInt = skipLeaveOnInt;
    this.enableDebug = enableDebug;
    this.verifyIncoming = verifyIncoming;
    this.verifyOutgoing = verifyOutgoing;
    this.caFile = caFile;
    this.certFile = certFile;
    this.keyFile = keyFile;
    this.uiDir = uiDir;
    this.pidFile = pidFile;
    this.enableSyslog = enableSyslog;
    this.rejoinAfterLeave = rejoinAfterLeave;
    this.advertiseAddrLAN = advertiseAddrLAN;
    this.advertiseAddrWAN = advertiseAddrWAN;
  }

  /**
   * @return The value of the {@code bootstrap} attribute
   */
  @JsonProperty(value = "Bootstrap")
  @Override
  public boolean getBootstrap() {
    return bootstrap;
  }

  /**
   * @return The value of the {@code datacenter} attribute
   */
  @JsonProperty(value = "Datacenter")
  @Override
  public String getDatacenter() {
    return datacenter;
  }

  /**
   * @return The value of the {@code dataDir} attribute
   */
  @JsonProperty(value = "DataDir")
  @Override
  public String getDataDir() {
    return dataDir;
  }

  /**
   * @return The value of the {@code dnsRecursors} attribute
   */
  @JsonProperty(value = "DNSRecursors")
  @Override
  public ImmutableList<String> dnsRecursors() {
    return dnsRecursors;
  }

  /**
   * @return The value of the {@code dnsDomain} attribute
   */
  @JsonProperty(value = "DNSDomain")
  @Override
  public String getDnsDomain() {
    return dnsDomain;
  }

  /**
   * @return The value of the {@code logLevel} attribute
   */
  @JsonProperty(value = "LogLevel")
  @Override
  public String getLogLevel() {
    return logLevel;
  }

  /**
   * @return The value of the {@code nodeName} attribute
   */
  @JsonProperty(value = "NodeName")
  @Override
  public String getNodeName() {
    return nodeName;
  }

  /**
   * @return The value of the {@code clientAddrs} attribute
   */
  @JsonProperty(value = "ClientAddrs")
  @Override
  public ImmutableList<String> getClientAddrs() {
    return clientAddrs;
  }

  /**
   * @return The value of the {@code bindAddr} attribute
   */
  @JsonProperty(value = "BindAddr")
  @Override
  public String getBindAddr() {
    return bindAddr;
  }

  /**
   * @return The value of the {@code leaveOnTerm} attribute
   */
  @JsonProperty(value = "LeaveOnTerm")
  @Override
  public boolean getLeaveOnTerm() {
    return leaveOnTerm;
  }

  /**
   * @return The value of the {@code skipLeaveOnInt} attribute
   */
  @JsonProperty(value = "SkipLeaveOnInt")
  @Override
  public boolean getSkipLeaveOnInt() {
    return skipLeaveOnInt;
  }

  /**
   * @return The value of the {@code enableDebug} attribute
   */
  @JsonProperty(value = "EnableDebug")
  @Override
  public boolean getEnableDebug() {
    return enableDebug;
  }

  /**
   * @return The value of the {@code verifyIncoming} attribute
   */
  @JsonProperty(value = "VerifyIncoming")
  @Override
  public boolean getVerifyIncoming() {
    return verifyIncoming;
  }

  /**
   * @return The value of the {@code verifyOutgoing} attribute
   */
  @JsonProperty(value = "VerifyOutgoing")
  @Override
  public boolean getVerifyOutgoing() {
    return verifyOutgoing;
  }

  /**
   * @return The value of the {@code caFile} attribute
   */
  @JsonProperty(value = "CAFile")
  @Override
  public String getCaFile() {
    return caFile;
  }

  /**
   * @return The value of the {@code certFile} attribute
   */
  @JsonProperty(value = "CertFile")
  @Override
  public String getCertFile() {
    return certFile;
  }

  /**
   * @return The value of the {@code keyFile} attribute
   */
  @JsonProperty(value = "KeyFile")
  @Override
  public String getKeyFile() {
    return keyFile;
  }

  /**
   * @return The value of the {@code uiDir} attribute
   */
  @JsonProperty(value = "UiDir")
  @Override
  public Optional<String> getUiDir() {
    return uiDir;
  }

  /**
   * @return The value of the {@code pidFile} attribute
   */
  @JsonProperty(value = "PidFile")
  @Override
  public String getPidFile() {
    return pidFile;
  }

  /**
   * @return The value of the {@code enableSyslog} attribute
   */
  @JsonProperty(value = "EnableSyslog")
  @Override
  public boolean getEnableSyslog() {
    return enableSyslog;
  }

  /**
   * @return The value of the {@code rejoinAfterLeave} attribute
   */
  @JsonProperty(value = "RejoinAfterLeave")
  @Override
  public boolean getRejoinAfterLeave() {
    return rejoinAfterLeave;
  }

  /**
   * @return The value of the {@code advertiseAddrLAN} attribute
   */
  @JsonProperty(value = "AdvertiseAddrLAN")
  @Override
  public String getAdvertiseAddrLAN() {
    return advertiseAddrLAN;
  }

  /**
   * @return The value of the {@code advertiseAddrWAN} attribute
   */
  @JsonProperty(value = "AdvertiseAddrWAN")
  @Override
  public String getAdvertiseAddrWAN() {
    return advertiseAddrWAN;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getBootstrap() bootstrap} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bootstrap
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withBootstrap(boolean value) {
    if (this.bootstrap == value) return this;
    return new ImmutableDebugConfig(
        value,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getDatacenter() datacenter} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for datacenter
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withDatacenter(String value) {
    if (this.datacenter.equals(value)) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        Preconditions.checkNotNull(value, "datacenter"),
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getDataDir() dataDir} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dataDir
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withDataDir(String value) {
    if (this.dataDir.equals(value)) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        Preconditions.checkNotNull(value, "dataDir"),
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DebugConfig#dnsRecursors() dnsRecursors}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDebugConfig withDnsRecursors(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        newValue,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DebugConfig#dnsRecursors() dnsRecursors}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of dnsRecursors elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDebugConfig withDnsRecursors(Iterable<String> elements) {
    if (this.dnsRecursors == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        newValue,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getDnsDomain() dnsDomain} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dnsDomain
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withDnsDomain(String value) {
    if (this.dnsDomain.equals(value)) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        Preconditions.checkNotNull(value, "dnsDomain"),
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getLogLevel() logLevel} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for logLevel
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withLogLevel(String value) {
    if (this.logLevel.equals(value)) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        Preconditions.checkNotNull(value, "logLevel"),
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getNodeName() nodeName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nodeName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withNodeName(String value) {
    if (this.nodeName.equals(value)) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        Preconditions.checkNotNull(value, "nodeName"),
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DebugConfig#getClientAddrs() clientAddrs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDebugConfig withClientAddrs(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        newValue,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DebugConfig#getClientAddrs() clientAddrs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of clientAddrs elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDebugConfig withClientAddrs(Iterable<String> elements) {
    if (this.clientAddrs == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        newValue,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getBindAddr() bindAddr} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bindAddr
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withBindAddr(String value) {
    if (this.bindAddr.equals(value)) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        Preconditions.checkNotNull(value, "bindAddr"),
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getLeaveOnTerm() leaveOnTerm} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for leaveOnTerm
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withLeaveOnTerm(boolean value) {
    if (this.leaveOnTerm == value) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        value,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getSkipLeaveOnInt() skipLeaveOnInt} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for skipLeaveOnInt
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withSkipLeaveOnInt(boolean value) {
    if (this.skipLeaveOnInt == value) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        value,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getEnableDebug() enableDebug} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for enableDebug
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withEnableDebug(boolean value) {
    if (this.enableDebug == value) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        value,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getVerifyIncoming() verifyIncoming} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for verifyIncoming
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withVerifyIncoming(boolean value) {
    if (this.verifyIncoming == value) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        value,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getVerifyOutgoing() verifyOutgoing} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for verifyOutgoing
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withVerifyOutgoing(boolean value) {
    if (this.verifyOutgoing == value) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        value,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getCaFile() caFile} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for caFile
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withCaFile(String value) {
    if (this.caFile.equals(value)) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        Preconditions.checkNotNull(value, "caFile"),
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getCertFile() certFile} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for certFile
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withCertFile(String value) {
    if (this.certFile.equals(value)) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        Preconditions.checkNotNull(value, "certFile"),
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getKeyFile() keyFile} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for keyFile
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withKeyFile(String value) {
    if (this.keyFile.equals(value)) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        Preconditions.checkNotNull(value, "keyFile"),
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link DebugConfig#getUiDir() uiDir} attribute.
   * @param value The value for uiDir
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDebugConfig withUiDir(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.uiDir.equals(newValue)) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        newValue,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link DebugConfig#getUiDir() uiDir} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for uiDir
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDebugConfig withUiDir(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "uiDir");
    if (this.uiDir.equals(value)) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        value,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getPidFile() pidFile} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pidFile
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withPidFile(String value) {
    if (this.pidFile.equals(value)) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        Preconditions.checkNotNull(value, "pidFile"),
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getEnableSyslog() enableSyslog} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for enableSyslog
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withEnableSyslog(boolean value) {
    if (this.enableSyslog == value) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        value,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getRejoinAfterLeave() rejoinAfterLeave} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rejoinAfterLeave
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withRejoinAfterLeave(boolean value) {
    if (this.rejoinAfterLeave == value) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        value,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getAdvertiseAddrLAN() advertiseAddrLAN} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for advertiseAddrLAN
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withAdvertiseAddrLAN(String value) {
    if (this.advertiseAddrLAN.equals(value)) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        Preconditions.checkNotNull(value, "advertiseAddrLAN"),
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getAdvertiseAddrWAN() advertiseAddrWAN} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for advertiseAddrWAN
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withAdvertiseAddrWAN(String value) {
    if (this.advertiseAddrWAN.equals(value)) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        Preconditions.checkNotNull(value, "advertiseAddrWAN"));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDebugConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDebugConfig
        && equalTo((ImmutableDebugConfig) another);
  }

  private boolean equalTo(ImmutableDebugConfig another) {
    return bootstrap == another.bootstrap
        && datacenter.equals(another.datacenter)
        && dataDir.equals(another.dataDir)
        && dnsRecursors.equals(another.dnsRecursors)
        && dnsDomain.equals(another.dnsDomain)
        && logLevel.equals(another.logLevel)
        && nodeName.equals(another.nodeName)
        && clientAddrs.equals(another.clientAddrs)
        && bindAddr.equals(another.bindAddr)
        && leaveOnTerm == another.leaveOnTerm
        && skipLeaveOnInt == another.skipLeaveOnInt
        && enableDebug == another.enableDebug
        && verifyIncoming == another.verifyIncoming
        && verifyOutgoing == another.verifyOutgoing
        && caFile.equals(another.caFile)
        && certFile.equals(another.certFile)
        && keyFile.equals(another.keyFile)
        && uiDir.equals(another.uiDir)
        && pidFile.equals(another.pidFile)
        && enableSyslog == another.enableSyslog
        && rejoinAfterLeave == another.rejoinAfterLeave
        && advertiseAddrLAN.equals(another.advertiseAddrLAN)
        && advertiseAddrWAN.equals(another.advertiseAddrWAN);
  }

  /**
   * Computes a hash code from attributes: {@code bootstrap}, {@code datacenter}, {@code dataDir}, {@code dnsRecursors}, {@code dnsDomain}, {@code logLevel}, {@code nodeName}, {@code clientAddrs}, {@code bindAddr}, {@code leaveOnTerm}, {@code skipLeaveOnInt}, {@code enableDebug}, {@code verifyIncoming}, {@code verifyOutgoing}, {@code caFile}, {@code certFile}, {@code keyFile}, {@code uiDir}, {@code pidFile}, {@code enableSyslog}, {@code rejoinAfterLeave}, {@code advertiseAddrLAN}, {@code advertiseAddrWAN}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Booleans.hashCode(bootstrap);
    h = h * 17 + datacenter.hashCode();
    h = h * 17 + dataDir.hashCode();
    h = h * 17 + dnsRecursors.hashCode();
    h = h * 17 + dnsDomain.hashCode();
    h = h * 17 + logLevel.hashCode();
    h = h * 17 + nodeName.hashCode();
    h = h * 17 + clientAddrs.hashCode();
    h = h * 17 + bindAddr.hashCode();
    h = h * 17 + Booleans.hashCode(leaveOnTerm);
    h = h * 17 + Booleans.hashCode(skipLeaveOnInt);
    h = h * 17 + Booleans.hashCode(enableDebug);
    h = h * 17 + Booleans.hashCode(verifyIncoming);
    h = h * 17 + Booleans.hashCode(verifyOutgoing);
    h = h * 17 + caFile.hashCode();
    h = h * 17 + certFile.hashCode();
    h = h * 17 + keyFile.hashCode();
    h = h * 17 + uiDir.hashCode();
    h = h * 17 + pidFile.hashCode();
    h = h * 17 + Booleans.hashCode(enableSyslog);
    h = h * 17 + Booleans.hashCode(rejoinAfterLeave);
    h = h * 17 + advertiseAddrLAN.hashCode();
    h = h * 17 + advertiseAddrWAN.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DebugConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("DebugConfig")
        .omitNullValues()
        .add("bootstrap", bootstrap)
        .add("datacenter", datacenter)
        .add("dataDir", dataDir)
        .add("dnsRecursors", dnsRecursors)
        .add("dnsDomain", dnsDomain)
        .add("logLevel", logLevel)
        .add("nodeName", nodeName)
        .add("clientAddrs", clientAddrs)
        .add("bindAddr", bindAddr)
        .add("leaveOnTerm", leaveOnTerm)
        .add("skipLeaveOnInt", skipLeaveOnInt)
        .add("enableDebug", enableDebug)
        .add("verifyIncoming", verifyIncoming)
        .add("verifyOutgoing", verifyOutgoing)
        .add("caFile", caFile)
        .add("certFile", certFile)
        .add("keyFile", keyFile)
        .add("uiDir", uiDir.orNull())
        .add("pidFile", pidFile)
        .add("enableSyslog", enableSyslog)
        .add("rejoinAfterLeave", rejoinAfterLeave)
        .add("advertiseAddrLAN", advertiseAddrLAN)
        .add("advertiseAddrWAN", advertiseAddrWAN)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends DebugConfig {
    @Nullable Boolean bootstrap;
    @Nullable String datacenter;
    @Nullable String dataDir;
    List<String> dnsRecursors = ImmutableList.of();
    @Nullable String dnsDomain;
    @Nullable String logLevel;
    @Nullable String nodeName;
    List<String> clientAddrs = ImmutableList.of();
    @Nullable String bindAddr;
    @Nullable Boolean leaveOnTerm;
    @Nullable Boolean skipLeaveOnInt;
    @Nullable Boolean enableDebug;
    @Nullable Boolean verifyIncoming;
    @Nullable Boolean verifyOutgoing;
    @Nullable String caFile;
    @Nullable String certFile;
    @Nullable String keyFile;
    Optional<String> uiDir = Optional.absent();
    @Nullable String pidFile;
    @Nullable Boolean enableSyslog;
    @Nullable Boolean rejoinAfterLeave;
    @Nullable String advertiseAddrLAN;
    @Nullable String advertiseAddrWAN;
    @JsonProperty(value = "Bootstrap")
    public void setBootstrap(boolean bootstrap) {
      this.bootstrap = bootstrap;
    }
    @JsonProperty(value = "Datacenter")
    public void setDatacenter(String datacenter) {
      this.datacenter = datacenter;
    }
    @JsonProperty(value = "DataDir")
    public void setDataDir(String dataDir) {
      this.dataDir = dataDir;
    }
    @JsonProperty(value = "DNSRecursors")
    public void setDnsRecursors(List<String> dnsRecursors) {
      this.dnsRecursors = dnsRecursors;
    }
    @JsonProperty(value = "DNSDomain")
    public void setDnsDomain(String dnsDomain) {
      this.dnsDomain = dnsDomain;
    }
    @JsonProperty(value = "LogLevel")
    public void setLogLevel(String logLevel) {
      this.logLevel = logLevel;
    }
    @JsonProperty(value = "NodeName")
    public void setNodeName(String nodeName) {
      this.nodeName = nodeName;
    }
    @JsonProperty(value = "ClientAddrs")
    public void setClientAddrs(List<String> clientAddrs) {
      this.clientAddrs = clientAddrs;
    }
    @JsonProperty(value = "BindAddr")
    public void setBindAddr(String bindAddr) {
      this.bindAddr = bindAddr;
    }
    @JsonProperty(value = "LeaveOnTerm")
    public void setLeaveOnTerm(boolean leaveOnTerm) {
      this.leaveOnTerm = leaveOnTerm;
    }
    @JsonProperty(value = "SkipLeaveOnInt")
    public void setSkipLeaveOnInt(boolean skipLeaveOnInt) {
      this.skipLeaveOnInt = skipLeaveOnInt;
    }
    @JsonProperty(value = "EnableDebug")
    public void setEnableDebug(boolean enableDebug) {
      this.enableDebug = enableDebug;
    }
    @JsonProperty(value = "VerifyIncoming")
    public void setVerifyIncoming(boolean verifyIncoming) {
      this.verifyIncoming = verifyIncoming;
    }
    @JsonProperty(value = "VerifyOutgoing")
    public void setVerifyOutgoing(boolean verifyOutgoing) {
      this.verifyOutgoing = verifyOutgoing;
    }
    @JsonProperty(value = "CAFile")
    public void setCaFile(String caFile) {
      this.caFile = caFile;
    }
    @JsonProperty(value = "CertFile")
    public void setCertFile(String certFile) {
      this.certFile = certFile;
    }
    @JsonProperty(value = "KeyFile")
    public void setKeyFile(String keyFile) {
      this.keyFile = keyFile;
    }
    @JsonProperty(value = "UiDir")
    public void setUiDir(Optional<String> uiDir) {
      this.uiDir = uiDir;
    }
    @JsonProperty(value = "PidFile")
    public void setPidFile(String pidFile) {
      this.pidFile = pidFile;
    }
    @JsonProperty(value = "EnableSyslog")
    public void setEnableSyslog(boolean enableSyslog) {
      this.enableSyslog = enableSyslog;
    }
    @JsonProperty(value = "RejoinAfterLeave")
    public void setRejoinAfterLeave(boolean rejoinAfterLeave) {
      this.rejoinAfterLeave = rejoinAfterLeave;
    }
    @JsonProperty(value = "AdvertiseAddrLAN")
    public void setAdvertiseAddrLAN(String advertiseAddrLAN) {
      this.advertiseAddrLAN = advertiseAddrLAN;
    }
    @JsonProperty(value = "AdvertiseAddrWAN")
    public void setAdvertiseAddrWAN(String advertiseAddrWAN) {
      this.advertiseAddrWAN = advertiseAddrWAN;
    }
    @Override
    public boolean getBootstrap() { throw new UnsupportedOperationException(); }
    @Override
    public String getDatacenter() { throw new UnsupportedOperationException(); }
    @Override
    public String getDataDir() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> dnsRecursors() { throw new UnsupportedOperationException(); }
    @Override
    public String getDnsDomain() { throw new UnsupportedOperationException(); }
    @Override
    public String getLogLevel() { throw new UnsupportedOperationException(); }
    @Override
    public String getNodeName() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getClientAddrs() { throw new UnsupportedOperationException(); }
    @Override
    public String getBindAddr() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getLeaveOnTerm() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getSkipLeaveOnInt() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getEnableDebug() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getVerifyIncoming() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getVerifyOutgoing() { throw new UnsupportedOperationException(); }
    @Override
    public String getCaFile() { throw new UnsupportedOperationException(); }
    @Override
    public String getCertFile() { throw new UnsupportedOperationException(); }
    @Override
    public String getKeyFile() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getUiDir() { throw new UnsupportedOperationException(); }
    @Override
    public String getPidFile() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getEnableSyslog() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getRejoinAfterLeave() { throw new UnsupportedOperationException(); }
    @Override
    public String getAdvertiseAddrLAN() { throw new UnsupportedOperationException(); }
    @Override
    public String getAdvertiseAddrWAN() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableDebugConfig fromJson(Json json) {
    ImmutableDebugConfig.Builder builder = ImmutableDebugConfig.builder();
    if (json.bootstrap != null) {
      builder.bootstrap(json.bootstrap);
    }
    if (json.datacenter != null) {
      builder.datacenter(json.datacenter);
    }
    if (json.dataDir != null) {
      builder.dataDir(json.dataDir);
    }
    if (json.dnsRecursors != null) {
      builder.addAllDnsRecursors(json.dnsRecursors);
    }
    if (json.dnsDomain != null) {
      builder.dnsDomain(json.dnsDomain);
    }
    if (json.logLevel != null) {
      builder.logLevel(json.logLevel);
    }
    if (json.nodeName != null) {
      builder.nodeName(json.nodeName);
    }
    if (json.clientAddrs != null) {
      builder.addAllClientAddrs(json.clientAddrs);
    }
    if (json.bindAddr != null) {
      builder.bindAddr(json.bindAddr);
    }
    if (json.leaveOnTerm != null) {
      builder.leaveOnTerm(json.leaveOnTerm);
    }
    if (json.skipLeaveOnInt != null) {
      builder.skipLeaveOnInt(json.skipLeaveOnInt);
    }
    if (json.enableDebug != null) {
      builder.enableDebug(json.enableDebug);
    }
    if (json.verifyIncoming != null) {
      builder.verifyIncoming(json.verifyIncoming);
    }
    if (json.verifyOutgoing != null) {
      builder.verifyOutgoing(json.verifyOutgoing);
    }
    if (json.caFile != null) {
      builder.caFile(json.caFile);
    }
    if (json.certFile != null) {
      builder.certFile(json.certFile);
    }
    if (json.keyFile != null) {
      builder.keyFile(json.keyFile);
    }
    if (json.uiDir != null) {
      builder.uiDir(json.uiDir);
    }
    if (json.pidFile != null) {
      builder.pidFile(json.pidFile);
    }
    if (json.enableSyslog != null) {
      builder.enableSyslog(json.enableSyslog);
    }
    if (json.rejoinAfterLeave != null) {
      builder.rejoinAfterLeave(json.rejoinAfterLeave);
    }
    if (json.advertiseAddrLAN != null) {
      builder.advertiseAddrLAN(json.advertiseAddrLAN);
    }
    if (json.advertiseAddrWAN != null) {
      builder.advertiseAddrWAN(json.advertiseAddrWAN);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DebugConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DebugConfig instance
   */
  public static ImmutableDebugConfig copyOf(DebugConfig instance) {
    if (instance instanceof ImmutableDebugConfig) {
      return (ImmutableDebugConfig) instance;
    }
    return ImmutableDebugConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDebugConfig ImmutableDebugConfig}.
   * @return A new ImmutableDebugConfig builder
   */
  public static ImmutableDebugConfig.Builder builder() {
    return new ImmutableDebugConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDebugConfig ImmutableDebugConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_BOOTSTRAP = 0x1L;
    private static final long INIT_BIT_DATACENTER = 0x2L;
    private static final long INIT_BIT_DATA_DIR = 0x4L;
    private static final long INIT_BIT_DNS_DOMAIN = 0x8L;
    private static final long INIT_BIT_LOG_LEVEL = 0x10L;
    private static final long INIT_BIT_NODE_NAME = 0x20L;
    private static final long INIT_BIT_BIND_ADDR = 0x40L;
    private static final long INIT_BIT_LEAVE_ON_TERM = 0x80L;
    private static final long INIT_BIT_SKIP_LEAVE_ON_INT = 0x100L;
    private static final long INIT_BIT_ENABLE_DEBUG = 0x200L;
    private static final long INIT_BIT_VERIFY_INCOMING = 0x400L;
    private static final long INIT_BIT_VERIFY_OUTGOING = 0x800L;
    private static final long INIT_BIT_CA_FILE = 0x1000L;
    private static final long INIT_BIT_CERT_FILE = 0x2000L;
    private static final long INIT_BIT_KEY_FILE = 0x4000L;
    private static final long INIT_BIT_PID_FILE = 0x8000L;
    private static final long INIT_BIT_ENABLE_SYSLOG = 0x10000L;
    private static final long INIT_BIT_REJOIN_AFTER_LEAVE = 0x20000L;
    private static final long INIT_BIT_ADVERTISE_ADDR_L_A_N = 0x40000L;
    private static final long INIT_BIT_ADVERTISE_ADDR_W_A_N = 0x80000L;
    private long initBits = 0xfffff;

    private boolean bootstrap;
    private @Nullable String datacenter;
    private @Nullable String dataDir;
    private ImmutableList.Builder<String> dnsRecursorsBuilder = ImmutableList.builder();
    private @Nullable String dnsDomain;
    private @Nullable String logLevel;
    private @Nullable String nodeName;
    private ImmutableList.Builder<String> clientAddrsBuilder = ImmutableList.builder();
    private @Nullable String bindAddr;
    private boolean leaveOnTerm;
    private boolean skipLeaveOnInt;
    private boolean enableDebug;
    private boolean verifyIncoming;
    private boolean verifyOutgoing;
    private @Nullable String caFile;
    private @Nullable String certFile;
    private @Nullable String keyFile;
    private Optional<String> uiDir = Optional.absent();
    private @Nullable String pidFile;
    private boolean enableSyslog;
    private boolean rejoinAfterLeave;
    private @Nullable String advertiseAddrLAN;
    private @Nullable String advertiseAddrWAN;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DebugConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DebugConfig instance) {
      Preconditions.checkNotNull(instance, "instance");
      bootstrap(instance.getBootstrap());
      datacenter(instance.getDatacenter());
      dataDir(instance.getDataDir());
      addAllDnsRecursors(instance.dnsRecursors());
      dnsDomain(instance.getDnsDomain());
      logLevel(instance.getLogLevel());
      nodeName(instance.getNodeName());
      addAllClientAddrs(instance.getClientAddrs());
      bindAddr(instance.getBindAddr());
      leaveOnTerm(instance.getLeaveOnTerm());
      skipLeaveOnInt(instance.getSkipLeaveOnInt());
      enableDebug(instance.getEnableDebug());
      verifyIncoming(instance.getVerifyIncoming());
      verifyOutgoing(instance.getVerifyOutgoing());
      caFile(instance.getCaFile());
      certFile(instance.getCertFile());
      keyFile(instance.getKeyFile());
      Optional<String> uiDirOptional = instance.getUiDir();
      if (uiDirOptional.isPresent()) {
        uiDir(uiDirOptional);
      }
      pidFile(instance.getPidFile());
      enableSyslog(instance.getEnableSyslog());
      rejoinAfterLeave(instance.getRejoinAfterLeave());
      advertiseAddrLAN(instance.getAdvertiseAddrLAN());
      advertiseAddrWAN(instance.getAdvertiseAddrWAN());
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getBootstrap() bootstrap} attribute.
     * @param bootstrap The value for bootstrap 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder bootstrap(boolean bootstrap) {
      this.bootstrap = bootstrap;
      initBits &= ~INIT_BIT_BOOTSTRAP;
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getDatacenter() datacenter} attribute.
     * @param datacenter The value for datacenter 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder datacenter(String datacenter) {
      this.datacenter = Preconditions.checkNotNull(datacenter, "datacenter");
      initBits &= ~INIT_BIT_DATACENTER;
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getDataDir() dataDir} attribute.
     * @param dataDir The value for dataDir 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dataDir(String dataDir) {
      this.dataDir = Preconditions.checkNotNull(dataDir, "dataDir");
      initBits &= ~INIT_BIT_DATA_DIR;
      return this;
    }

    /**
     * Adds one element to {@link DebugConfig#dnsRecursors() dnsRecursors} list.
     * @param element A dnsRecursors element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDnsRecursors(String element) {
      dnsRecursorsBuilder.add(element);
      return this;
    }

    /**
     * Adds elements to {@link DebugConfig#dnsRecursors() dnsRecursors} list.
     * @param elements An array of dnsRecursors elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDnsRecursors(String... elements) {
      dnsRecursorsBuilder.add(elements);
      return this;
    }

    /**
     * Sets or replaces all elements for {@link DebugConfig#dnsRecursors() dnsRecursors} list.
     * @param elements An iterable of dnsRecursors elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dnsRecursors(Iterable<String> elements) {
      dnsRecursorsBuilder = ImmutableList.builder();
      return addAllDnsRecursors(elements);
    }

    /**
     * Adds elements to {@link DebugConfig#dnsRecursors() dnsRecursors} list.
     * @param elements An iterable of dnsRecursors elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDnsRecursors(Iterable<String> elements) {
      dnsRecursorsBuilder.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getDnsDomain() dnsDomain} attribute.
     * @param dnsDomain The value for dnsDomain 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dnsDomain(String dnsDomain) {
      this.dnsDomain = Preconditions.checkNotNull(dnsDomain, "dnsDomain");
      initBits &= ~INIT_BIT_DNS_DOMAIN;
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getLogLevel() logLevel} attribute.
     * @param logLevel The value for logLevel 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder logLevel(String logLevel) {
      this.logLevel = Preconditions.checkNotNull(logLevel, "logLevel");
      initBits &= ~INIT_BIT_LOG_LEVEL;
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getNodeName() nodeName} attribute.
     * @param nodeName The value for nodeName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder nodeName(String nodeName) {
      this.nodeName = Preconditions.checkNotNull(nodeName, "nodeName");
      initBits &= ~INIT_BIT_NODE_NAME;
      return this;
    }

    /**
     * Adds one element to {@link DebugConfig#getClientAddrs() clientAddrs} list.
     * @param element A clientAddrs element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addClientAddrs(String element) {
      clientAddrsBuilder.add(element);
      return this;
    }

    /**
     * Adds elements to {@link DebugConfig#getClientAddrs() clientAddrs} list.
     * @param elements An array of clientAddrs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addClientAddrs(String... elements) {
      clientAddrsBuilder.add(elements);
      return this;
    }

    /**
     * Sets or replaces all elements for {@link DebugConfig#getClientAddrs() clientAddrs} list.
     * @param elements An iterable of clientAddrs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientAddrs(Iterable<String> elements) {
      clientAddrsBuilder = ImmutableList.builder();
      return addAllClientAddrs(elements);
    }

    /**
     * Adds elements to {@link DebugConfig#getClientAddrs() clientAddrs} list.
     * @param elements An iterable of clientAddrs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllClientAddrs(Iterable<String> elements) {
      clientAddrsBuilder.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getBindAddr() bindAddr} attribute.
     * @param bindAddr The value for bindAddr 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder bindAddr(String bindAddr) {
      this.bindAddr = Preconditions.checkNotNull(bindAddr, "bindAddr");
      initBits &= ~INIT_BIT_BIND_ADDR;
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getLeaveOnTerm() leaveOnTerm} attribute.
     * @param leaveOnTerm The value for leaveOnTerm 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder leaveOnTerm(boolean leaveOnTerm) {
      this.leaveOnTerm = leaveOnTerm;
      initBits &= ~INIT_BIT_LEAVE_ON_TERM;
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getSkipLeaveOnInt() skipLeaveOnInt} attribute.
     * @param skipLeaveOnInt The value for skipLeaveOnInt 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder skipLeaveOnInt(boolean skipLeaveOnInt) {
      this.skipLeaveOnInt = skipLeaveOnInt;
      initBits &= ~INIT_BIT_SKIP_LEAVE_ON_INT;
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getEnableDebug() enableDebug} attribute.
     * @param enableDebug The value for enableDebug 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder enableDebug(boolean enableDebug) {
      this.enableDebug = enableDebug;
      initBits &= ~INIT_BIT_ENABLE_DEBUG;
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getVerifyIncoming() verifyIncoming} attribute.
     * @param verifyIncoming The value for verifyIncoming 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder verifyIncoming(boolean verifyIncoming) {
      this.verifyIncoming = verifyIncoming;
      initBits &= ~INIT_BIT_VERIFY_INCOMING;
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getVerifyOutgoing() verifyOutgoing} attribute.
     * @param verifyOutgoing The value for verifyOutgoing 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder verifyOutgoing(boolean verifyOutgoing) {
      this.verifyOutgoing = verifyOutgoing;
      initBits &= ~INIT_BIT_VERIFY_OUTGOING;
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getCaFile() caFile} attribute.
     * @param caFile The value for caFile 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder caFile(String caFile) {
      this.caFile = Preconditions.checkNotNull(caFile, "caFile");
      initBits &= ~INIT_BIT_CA_FILE;
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getCertFile() certFile} attribute.
     * @param certFile The value for certFile 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder certFile(String certFile) {
      this.certFile = Preconditions.checkNotNull(certFile, "certFile");
      initBits &= ~INIT_BIT_CERT_FILE;
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getKeyFile() keyFile} attribute.
     * @param keyFile The value for keyFile 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder keyFile(String keyFile) {
      this.keyFile = Preconditions.checkNotNull(keyFile, "keyFile");
      initBits &= ~INIT_BIT_KEY_FILE;
      return this;
    }

    /**
     * Initializes the optional value {@link DebugConfig#getUiDir() uiDir} to uiDir.
     * @param uiDir The value for uiDir
     * @return {@code this} builder for chained invocation
     */
    public final Builder uiDir(String uiDir) {
      this.uiDir = Optional.of(uiDir);
      return this;
    }

    /**
     * Initializes the optional value {@link DebugConfig#getUiDir() uiDir} to uiDir.
     * @param uiDir The value for uiDir
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder uiDir(Optional<String> uiDir) {
      this.uiDir = Preconditions.checkNotNull(uiDir, "uiDir");
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getPidFile() pidFile} attribute.
     * @param pidFile The value for pidFile 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder pidFile(String pidFile) {
      this.pidFile = Preconditions.checkNotNull(pidFile, "pidFile");
      initBits &= ~INIT_BIT_PID_FILE;
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getEnableSyslog() enableSyslog} attribute.
     * @param enableSyslog The value for enableSyslog 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder enableSyslog(boolean enableSyslog) {
      this.enableSyslog = enableSyslog;
      initBits &= ~INIT_BIT_ENABLE_SYSLOG;
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getRejoinAfterLeave() rejoinAfterLeave} attribute.
     * @param rejoinAfterLeave The value for rejoinAfterLeave 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder rejoinAfterLeave(boolean rejoinAfterLeave) {
      this.rejoinAfterLeave = rejoinAfterLeave;
      initBits &= ~INIT_BIT_REJOIN_AFTER_LEAVE;
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getAdvertiseAddrLAN() advertiseAddrLAN} attribute.
     * @param advertiseAddrLAN The value for advertiseAddrLAN 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder advertiseAddrLAN(String advertiseAddrLAN) {
      this.advertiseAddrLAN = Preconditions.checkNotNull(advertiseAddrLAN, "advertiseAddrLAN");
      initBits &= ~INIT_BIT_ADVERTISE_ADDR_L_A_N;
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getAdvertiseAddrWAN() advertiseAddrWAN} attribute.
     * @param advertiseAddrWAN The value for advertiseAddrWAN 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder advertiseAddrWAN(String advertiseAddrWAN) {
      this.advertiseAddrWAN = Preconditions.checkNotNull(advertiseAddrWAN, "advertiseAddrWAN");
      initBits &= ~INIT_BIT_ADVERTISE_ADDR_W_A_N;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDebugConfig ImmutableDebugConfig}.
     * @return An immutable instance of DebugConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDebugConfig build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDebugConfig(
          bootstrap,
          datacenter,
          dataDir,
          dnsRecursorsBuilder.build(),
          dnsDomain,
          logLevel,
          nodeName,
          clientAddrsBuilder.build(),
          bindAddr,
          leaveOnTerm,
          skipLeaveOnInt,
          enableDebug,
          verifyIncoming,
          verifyOutgoing,
          caFile,
          certFile,
          keyFile,
          uiDir,
          pidFile,
          enableSyslog,
          rejoinAfterLeave,
          advertiseAddrLAN,
          advertiseAddrWAN);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_BOOTSTRAP) != 0) attributes.add("bootstrap");
      if ((initBits & INIT_BIT_DATACENTER) != 0) attributes.add("datacenter");
      if ((initBits & INIT_BIT_DATA_DIR) != 0) attributes.add("dataDir");
      if ((initBits & INIT_BIT_DNS_DOMAIN) != 0) attributes.add("dnsDomain");
      if ((initBits & INIT_BIT_LOG_LEVEL) != 0) attributes.add("logLevel");
      if ((initBits & INIT_BIT_NODE_NAME) != 0) attributes.add("nodeName");
      if ((initBits & INIT_BIT_BIND_ADDR) != 0) attributes.add("bindAddr");
      if ((initBits & INIT_BIT_LEAVE_ON_TERM) != 0) attributes.add("leaveOnTerm");
      if ((initBits & INIT_BIT_SKIP_LEAVE_ON_INT) != 0) attributes.add("skipLeaveOnInt");
      if ((initBits & INIT_BIT_ENABLE_DEBUG) != 0) attributes.add("enableDebug");
      if ((initBits & INIT_BIT_VERIFY_INCOMING) != 0) attributes.add("verifyIncoming");
      if ((initBits & INIT_BIT_VERIFY_OUTGOING) != 0) attributes.add("verifyOutgoing");
      if ((initBits & INIT_BIT_CA_FILE) != 0) attributes.add("caFile");
      if ((initBits & INIT_BIT_CERT_FILE) != 0) attributes.add("certFile");
      if ((initBits & INIT_BIT_KEY_FILE) != 0) attributes.add("keyFile");
      if ((initBits & INIT_BIT_PID_FILE) != 0) attributes.add("pidFile");
      if ((initBits & INIT_BIT_ENABLE_SYSLOG) != 0) attributes.add("enableSyslog");
      if ((initBits & INIT_BIT_REJOIN_AFTER_LEAVE) != 0) attributes.add("rejoinAfterLeave");
      if ((initBits & INIT_BIT_ADVERTISE_ADDR_L_A_N) != 0) attributes.add("advertiseAddrLAN");
      if ((initBits & INIT_BIT_ADVERTISE_ADDR_W_A_N) != 0) attributes.add("advertiseAddrWAN");
      return "Cannot build DebugConfig, some of required attributes are not set " + attributes;
    }
  }
}
